/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.content.Context;
import android.os.Build;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.widget.FrameLayout;
import org.chromium.base.JNINamespace;
import org.chromium.content.browser.ContentView;
import org.chromium.content.browser.ContentViewCore;
import org.chromium.content.browser.VSyncManager;
import org.chromium.content.browser.VSyncMonitor;

@JNINamespace(value="content")
public class ContentViewRenderView
extends FrameLayout {
    private int mNativeContentViewRenderView = ContentViewRenderView.nativeInit();
    private final SurfaceHolder.Callback mSurfaceCallback;
    private SurfaceView mSurfaceView;
    private VSyncAdapter mVSyncAdapter;
    private ContentView mCurrentContentView;

    public ContentViewRenderView(Context context) {
        super(context);
        assert (this.mNativeContentViewRenderView != 0);
        this.mSurfaceView = this.createSurfaceView(this.getContext());
        this.mSurfaceCallback = new SurfaceHolder.Callback(){

            public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
                assert (ContentViewRenderView.this.mNativeContentViewRenderView != 0);
                ContentViewRenderView.this.nativeSurfaceSetSize(ContentViewRenderView.this.mNativeContentViewRenderView, width, height);
                if (ContentViewRenderView.this.mCurrentContentView != null) {
                    ContentViewRenderView.this.mCurrentContentView.getContentViewCore().onPhysicalBackingSizeChanged(width, height);
                }
            }

            public void surfaceCreated(SurfaceHolder holder) {
                assert (ContentViewRenderView.this.mNativeContentViewRenderView != 0);
                ContentViewRenderView.this.nativeSurfaceCreated(ContentViewRenderView.this.mNativeContentViewRenderView, holder.getSurface());
                ContentViewRenderView.this.onReadyToRender();
            }

            public void surfaceDestroyed(SurfaceHolder holder) {
                assert (ContentViewRenderView.this.mNativeContentViewRenderView != 0);
                ContentViewRenderView.this.nativeSurfaceDestroyed(ContentViewRenderView.this.mNativeContentViewRenderView);
            }
        };
        this.mSurfaceView.getHolder().addCallback(this.mSurfaceCallback);
        this.mVSyncAdapter = new VSyncAdapter(this.getContext());
        this.addView((View)this.mSurfaceView, new FrameLayout.LayoutParams(-1, -1));
    }

    public void destroy() {
        this.mSurfaceView.getHolder().removeCallback(this.mSurfaceCallback);
        this.nativeDestroy(this.mNativeContentViewRenderView);
        this.mNativeContentViewRenderView = 0;
    }

    public void setCurrentContentView(ContentView contentView) {
        assert (this.mNativeContentViewRenderView != 0);
        ContentViewCore contentViewCore = contentView.getContentViewCore();
        this.nativeSetCurrentContentView(this.mNativeContentViewRenderView, contentViewCore.getNativeContentViewCore());
        this.mCurrentContentView = contentView;
        contentViewCore.onPhysicalBackingSizeChanged(this.getWidth(), this.getHeight());
        this.mVSyncAdapter.setVSyncListener(contentViewCore.getVSyncListener(this.mVSyncAdapter));
    }

    protected void onReadyToRender() {
    }

    protected SurfaceView createSurfaceView(Context context) {
        return new SurfaceView(context);
    }

    public boolean isInitialized() {
        return this.mSurfaceView.getHolder().getSurface() != null;
    }

    private static native int nativeInit();

    private native void nativeDestroy(int var1);

    private native void nativeSetCurrentContentView(int var1, int var2);

    private native void nativeSurfaceCreated(int var1, Surface var2);

    private native void nativeSurfaceDestroyed(int var1);

    private native void nativeSurfaceSetSize(int var1, int var2, int var3);

    private static class VSyncAdapter
    implements VSyncManager.Provider,
    VSyncMonitor.Listener {
        private final VSyncMonitor mVSyncMonitor;
        private boolean mVSyncNotificationEnabled;
        private VSyncManager.Listener mVSyncListener;
        private static final long INPUT_EVENT_LAG_FROM_VSYNC_MICROSECONDS = 3200L;

        VSyncAdapter(Context context) {
            this.mVSyncMonitor = new VSyncMonitor(context, this);
        }

        public void onVSync(VSyncMonitor monitor, long vsyncTimeMicros) {
            if (this.mVSyncListener == null) {
                return;
            }
            if (this.mVSyncNotificationEnabled) {
                this.mVSyncListener.onVSync(vsyncTimeMicros);
                this.mVSyncMonitor.requestUpdate();
            } else {
                if (Build.VERSION.SDK_INT >= 16) {
                    vsyncTimeMicros += 3200L;
                }
                this.mVSyncListener.updateVSync(vsyncTimeMicros, this.mVSyncMonitor.getVSyncPeriodInMicroseconds());
            }
        }

        public void registerVSyncListener(VSyncManager.Listener listener) {
            if (!this.mVSyncNotificationEnabled) {
                this.mVSyncMonitor.requestUpdate();
            }
            this.mVSyncNotificationEnabled = true;
        }

        public void unregisterVSyncListener(VSyncManager.Listener listener) {
            this.mVSyncNotificationEnabled = false;
        }

        void setVSyncListener(VSyncManager.Listener listener) {
            this.mVSyncListener = listener;
            if (this.mVSyncListener != null) {
                this.mVSyncMonitor.requestUpdate();
            }
        }
    }
}

