/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import java.util.Map;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JNINamespace(value="content")
public class LoadUrlParams {
    public static int LOAD_TYPE_DEFAULT;
    public static int LOAD_TYPE_BROWSER_INITIATED_HTTP_POST;
    public static int LOAD_TYPE_DATA;
    public static int UA_OVERRIDE_INHERIT;
    public static int UA_OVERRIDE_FALSE;
    public static int UA_OVERRIDE_TRUE;
    final String mUrl;
    int mLoadUrlType;
    int mTransitionType;
    int mUaOverrideOption;
    private Map<String, String> mExtraHeaders;
    byte[] mPostData;
    String mBaseUrlForDataUrl;
    String mVirtualUrlForDataUrl;
    boolean mCanLoadLocalResources;

    public LoadUrlParams(String url) {
        assert (LOAD_TYPE_DEFAULT != LOAD_TYPE_BROWSER_INITIATED_HTTP_POST);
        this.mUrl = url;
        this.mLoadUrlType = LOAD_TYPE_DEFAULT;
        this.mTransitionType = 0;
        this.mUaOverrideOption = UA_OVERRIDE_INHERIT;
        this.mPostData = null;
        this.mBaseUrlForDataUrl = null;
        this.mVirtualUrlForDataUrl = null;
    }

    public static LoadUrlParams createLoadDataParams(String data, String mimeType, boolean isBase64Encoded) {
        return LoadUrlParams.createLoadDataParams(data, mimeType, isBase64Encoded, null);
    }

    public static LoadUrlParams createLoadDataParams(String data, String mimeType, boolean isBase64Encoded, String charset) {
        StringBuilder dataUrl = new StringBuilder("data:");
        dataUrl.append(mimeType);
        if (charset != null && !charset.isEmpty()) {
            dataUrl.append(";charset=" + charset);
        }
        if (isBase64Encoded) {
            dataUrl.append(";base64");
        }
        dataUrl.append(",");
        dataUrl.append(data);
        LoadUrlParams params = new LoadUrlParams(dataUrl.toString());
        params.setLoadType(LOAD_TYPE_DATA);
        params.setTransitionType(1);
        return params;
    }

    public static LoadUrlParams createLoadDataParamsWithBaseUrl(String data, String mimeType, boolean isBase64Encoded, String baseUrl, String historyUrl) {
        return LoadUrlParams.createLoadDataParamsWithBaseUrl(data, mimeType, isBase64Encoded, baseUrl, historyUrl, null);
    }

    public static LoadUrlParams createLoadDataParamsWithBaseUrl(String data, String mimeType, boolean isBase64Encoded, String baseUrl, String historyUrl, String charset) {
        LoadUrlParams params = LoadUrlParams.createLoadDataParams(data, mimeType, isBase64Encoded, charset);
        if (baseUrl == null || !baseUrl.toLowerCase().startsWith("data:")) {
            params.setBaseUrlForDataUrl(baseUrl != null ? baseUrl : "about:blank");
            params.setVirtualUrlForDataUrl(historyUrl != null ? historyUrl : "about:blank");
        }
        return params;
    }

    public static LoadUrlParams createLoadHttpPostParams(String url, byte[] postData) {
        LoadUrlParams params = new LoadUrlParams(url);
        params.setLoadType(LOAD_TYPE_BROWSER_INITIATED_HTTP_POST);
        params.setTransitionType(1);
        params.setPostData(postData);
        return params;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public String getBaseUrl() {
        return this.mBaseUrlForDataUrl;
    }

    public void setLoadType(int loadType) {
        this.mLoadUrlType = loadType;
    }

    public void setTransitionType(int transitionType) {
        this.mTransitionType = transitionType;
    }

    public int getTransitionType() {
        return this.mTransitionType;
    }

    public void setOverrideUserAgent(int uaOption) {
        this.mUaOverrideOption = uaOption;
    }

    public void setExtraHeaders(Map<String, String> extraHeaders) {
        this.mExtraHeaders = extraHeaders;
    }

    String getExtraHeadersString() {
        if (this.mExtraHeaders == null) {
            return null;
        }
        StringBuilder headerBuilder = new StringBuilder();
        for (Map.Entry<String, String> header : this.mExtraHeaders.entrySet()) {
            if (headerBuilder.length() > 0) {
                headerBuilder.append("\n");
            }
            headerBuilder.append(header.getKey().toLowerCase());
            headerBuilder.append(":");
            headerBuilder.append(header.getValue());
        }
        return headerBuilder.toString();
    }

    public void setPostData(byte[] postData) {
        this.mPostData = postData;
    }

    public void setBaseUrlForDataUrl(String baseUrl) {
        this.mBaseUrlForDataUrl = baseUrl;
    }

    public void setVirtualUrlForDataUrl(String virtualUrl) {
        this.mVirtualUrlForDataUrl = virtualUrl;
    }

    public void setCanLoadLocalResources(boolean canLoad) {
        this.mCanLoadLocalResources = canLoad;
    }

    public int getLoadUrlType() {
        return this.mLoadUrlType;
    }

    public boolean isBaseUrlDataScheme() {
        if (this.mBaseUrlForDataUrl == null && this.mLoadUrlType == LOAD_TYPE_DATA) {
            return true;
        }
        return LoadUrlParams.nativeIsDataScheme(this.mBaseUrlForDataUrl);
    }

    @CalledByNative
    private static void initializeConstants(int load_type_default, int load_type_browser_initiated_http_post, int load_type_data, int ua_override_inherit, int ua_override_false, int ua_override_true) {
        LOAD_TYPE_DEFAULT = load_type_default;
        LOAD_TYPE_BROWSER_INITIATED_HTTP_POST = load_type_browser_initiated_http_post;
        LOAD_TYPE_DATA = load_type_data;
        UA_OVERRIDE_INHERIT = ua_override_inherit;
        UA_OVERRIDE_FALSE = ua_override_false;
        UA_OVERRIDE_TRUE = ua_override_true;
    }

    private static native boolean nativeIsDataScheme(String var0);
}

