/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

public class RenderCoordinates {
    private float mScrollXCss;
    private float mScrollYCss;
    private float mContentWidthCss;
    private float mContentHeightCss;
    private float mLastFrameViewportWidthCss;
    private float mLastFrameViewportHeightCss;
    private float mPageScaleFactor = 1.0f;
    private float mMinPageScaleFactor = 1.0f;
    private float mMaxPageScaleFactor = 1.0f;
    private float mDeviceScaleFactor;
    private float mContentOffsetYPix;

    void reset() {
        this.mScrollYCss = 0.0f;
        this.mScrollXCss = 0.0f;
        this.mPageScaleFactor = 1.0f;
    }

    void updateContentSizeCss(float contentWidthCss, float contentHeightCss) {
        this.mContentWidthCss = contentWidthCss;
        this.mContentHeightCss = contentHeightCss;
    }

    void setDeviceScaleFactor(float deviceScaleFactor) {
        this.mDeviceScaleFactor = deviceScaleFactor;
    }

    void updateFrameInfo(float scrollXCss, float scrollYCss, float contentWidthCss, float contentHeightCss, float viewportWidthCss, float viewportHeightCss, float pageScaleFactor, float minPageScaleFactor, float maxPageScaleFactor, float contentOffsetYPix) {
        this.mScrollXCss = scrollXCss;
        this.mScrollYCss = scrollYCss;
        this.mPageScaleFactor = pageScaleFactor;
        this.mMinPageScaleFactor = minPageScaleFactor;
        this.mMaxPageScaleFactor = maxPageScaleFactor;
        this.mContentOffsetYPix = contentOffsetYPix;
        this.updateContentSizeCss(contentWidthCss, contentHeightCss);
        this.mLastFrameViewportWidthCss = viewportWidthCss;
        this.mLastFrameViewportHeightCss = viewportHeightCss;
    }

    public NormalizedPoint createNormalizedPoint() {
        return new NormalizedPoint();
    }

    public float getScrollX() {
        return this.mScrollXCss;
    }

    public float getScrollY() {
        return this.mScrollYCss;
    }

    public float getScrollXPix() {
        return this.fromLocalCssToPix(this.mScrollXCss);
    }

    public float getScrollYPix() {
        return this.fromLocalCssToPix(this.mScrollYCss);
    }

    public int getScrollXPixInt() {
        return (int)Math.floor(this.getScrollXPix());
    }

    public int getScrollYPixInt() {
        return (int)Math.floor(this.getScrollYPix());
    }

    public float getContentWidthCss() {
        return this.mContentWidthCss;
    }

    public float getContentHeightCss() {
        return this.mContentHeightCss;
    }

    public float getContentWidthPix() {
        return this.fromLocalCssToPix(this.mContentWidthCss);
    }

    public float getContentHeightPix() {
        return this.fromLocalCssToPix(this.mContentHeightCss);
    }

    public int getContentWidthPixInt() {
        return (int)Math.ceil(this.getContentWidthPix());
    }

    public int getContentHeightPixInt() {
        return (int)Math.ceil(this.getContentHeightPix());
    }

    public float getLastFrameViewportWidthCss() {
        return this.mLastFrameViewportWidthCss;
    }

    public float getLastFrameViewportHeightCss() {
        return this.mLastFrameViewportHeightCss;
    }

    public float getLastFrameViewportWidthPix() {
        return this.fromLocalCssToPix(this.mLastFrameViewportWidthCss);
    }

    public float getLastFrameViewportHeightPix() {
        return this.fromLocalCssToPix(this.mLastFrameViewportHeightCss);
    }

    public int getLastFrameViewportWidthPixInt() {
        return (int)Math.ceil(this.getLastFrameViewportWidthPix());
    }

    public int getLastFrameViewportHeightPixInt() {
        return (int)Math.ceil(this.getLastFrameViewportHeightPix());
    }

    public float getContentOffsetYPix() {
        return this.mContentOffsetYPix;
    }

    public float getPageScaleFactor() {
        return this.mPageScaleFactor;
    }

    public float getMinPageScaleFactor() {
        return this.mMinPageScaleFactor;
    }

    public float getMaxPageScaleFactor() {
        return this.mMaxPageScaleFactor;
    }

    public float getDeviceScaleFactor() {
        return this.mDeviceScaleFactor;
    }

    public boolean hasFixedPageScale() {
        return this.mMinPageScaleFactor == this.mMaxPageScaleFactor;
    }

    public float getMaxHorizontalScrollPix() {
        return this.getContentWidthPix() - this.getLastFrameViewportWidthPix();
    }

    public float getMaxVerticalScrollPix() {
        return this.getContentHeightPix() - this.getLastFrameViewportHeightPix();
    }

    public int getMaxHorizontalScrollPixInt() {
        return (int)Math.floor(this.getMaxHorizontalScrollPix());
    }

    public int getMaxVerticalScrollPixInt() {
        return (int)Math.floor(this.getMaxVerticalScrollPix());
    }

    public float fromPixToDip(float pix) {
        return pix / this.mDeviceScaleFactor;
    }

    public float fromDipToPix(float dip) {
        return dip * this.mDeviceScaleFactor;
    }

    public float fromPixToLocalCss(float pix) {
        return pix / (this.mDeviceScaleFactor * this.mPageScaleFactor);
    }

    public float fromLocalCssToPix(float css) {
        return css * this.mPageScaleFactor * this.mDeviceScaleFactor;
    }

    public class NormalizedPoint {
        private float mXAbsoluteCss;
        private float mYAbsoluteCss;

        private NormalizedPoint() {
        }

        public float getXAbsoluteCss() {
            return this.mXAbsoluteCss;
        }

        public float getYAbsoluteCss() {
            return this.mYAbsoluteCss;
        }

        public float getXLocalDip() {
            return (this.mXAbsoluteCss - RenderCoordinates.this.mScrollXCss) * RenderCoordinates.this.mPageScaleFactor;
        }

        public float getYLocalDip() {
            return (this.mYAbsoluteCss - RenderCoordinates.this.mScrollYCss) * RenderCoordinates.this.mPageScaleFactor;
        }

        public float getXPix() {
            return this.getXLocalDip() * RenderCoordinates.this.mDeviceScaleFactor;
        }

        public float getYPix() {
            return this.getYLocalDip() * RenderCoordinates.this.mDeviceScaleFactor + RenderCoordinates.this.mContentOffsetYPix;
        }

        public void setAbsoluteCss(float xCss, float yCss) {
            this.mXAbsoluteCss = xCss;
            this.mYAbsoluteCss = yCss;
        }

        public void setLocalDip(float xDip, float yDip) {
            this.setAbsoluteCss(xDip / RenderCoordinates.this.mPageScaleFactor + RenderCoordinates.this.mScrollXCss, yDip / RenderCoordinates.this.mPageScaleFactor + RenderCoordinates.this.mScrollYCss);
        }

        public void setScreen(float xPix, float yPix) {
            this.setLocalDip(xPix / RenderCoordinates.this.mDeviceScaleFactor, yPix / RenderCoordinates.this.mDeviceScaleFactor);
        }
    }
}

