/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.accessibility;

import android.graphics.Rect;
import android.os.Build;
import android.os.Bundle;
import android.view.MotionEvent;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityNodeProvider;
import java.util.ArrayList;
import java.util.List;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.content.browser.ContentViewCore;
import org.chromium.content.browser.RenderCoordinates;
import org.chromium.content.browser.accessibility.JellyBeanBrowserAccessibilityManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JNINamespace(value="content")
public class BrowserAccessibilityManager {
    private static final String TAG = "BrowserAccessibilityManager";
    private ContentViewCore mContentViewCore;
    private AccessibilityManager mAccessibilityManager;
    private RenderCoordinates mRenderCoordinates;
    private int mNativeObj;
    private int mAccessibilityFocusId;
    private int mCurrentHoverId;
    private final int[] mTempLocation = new int[2];
    private View mView;
    private boolean mUserHasTouchExplored;
    private boolean mFrameInfoInitialized;
    private boolean mFocusPageOnLoad;

    @CalledByNative
    private static BrowserAccessibilityManager create(int nativeBrowserAccessibilityManagerAndroid, ContentViewCore contentViewCore) {
        if (Build.VERSION.SDK_INT >= 16) {
            return new JellyBeanBrowserAccessibilityManager(nativeBrowserAccessibilityManagerAndroid, contentViewCore);
        }
        return new BrowserAccessibilityManager(nativeBrowserAccessibilityManagerAndroid, contentViewCore);
    }

    protected BrowserAccessibilityManager(int nativeBrowserAccessibilityManagerAndroid, ContentViewCore contentViewCore) {
        this.mNativeObj = nativeBrowserAccessibilityManagerAndroid;
        this.mContentViewCore = contentViewCore;
        this.mContentViewCore.setBrowserAccessibilityManager(this);
        this.mAccessibilityFocusId = -1;
        this.mCurrentHoverId = -1;
        this.mView = this.mContentViewCore.getContainerView();
        this.mRenderCoordinates = this.mContentViewCore.getRenderCoordinates();
        this.mAccessibilityManager = (AccessibilityManager)this.mContentViewCore.getContext().getSystemService("accessibility");
    }

    @CalledByNative
    private void onNativeObjectDestroyed() {
        if (this.mContentViewCore.getBrowserAccessibilityManager() == this) {
            this.mContentViewCore.setBrowserAccessibilityManager(null);
        }
        this.mNativeObj = 0;
        this.mContentViewCore = null;
    }

    public AccessibilityNodeProvider getAccessibilityNodeProvider() {
        return null;
    }

    protected AccessibilityNodeInfo createAccessibilityNodeInfo(int virtualViewId) {
        if (!this.mAccessibilityManager.isEnabled() || this.mNativeObj == 0 || !this.mFrameInfoInitialized) {
            return null;
        }
        int rootId = this.nativeGetRootId(this.mNativeObj);
        if (virtualViewId == -1) {
            virtualViewId = rootId;
        }
        if (this.mAccessibilityFocusId == -1) {
            this.mAccessibilityFocusId = rootId;
        }
        AccessibilityNodeInfo info = AccessibilityNodeInfo.obtain(this.mView);
        info.setPackageName(this.mContentViewCore.getContext().getPackageName());
        info.setSource(this.mView, virtualViewId);
        if (this.nativePopulateAccessibilityNodeInfo(this.mNativeObj, info, virtualViewId)) {
            return info;
        }
        return null;
    }

    protected List<AccessibilityNodeInfo> findAccessibilityNodeInfosByText(String text, int virtualViewId) {
        return new ArrayList<AccessibilityNodeInfo>();
    }

    protected boolean performAction(int virtualViewId, int action, Bundle arguments) {
        if (!this.mAccessibilityManager.isEnabled() || this.mNativeObj == 0) {
            return false;
        }
        switch (action) {
            case 64: {
                if (this.mAccessibilityFocusId == virtualViewId) {
                    return true;
                }
                this.mAccessibilityFocusId = virtualViewId;
                this.sendAccessibilityEvent(this.mAccessibilityFocusId, 32768);
                return true;
            }
            case 128: {
                if (this.mAccessibilityFocusId == virtualViewId) {
                    this.mAccessibilityFocusId = -1;
                }
                return true;
            }
            case 16: {
                this.nativeClick(this.mNativeObj, virtualViewId);
                break;
            }
            case 1: {
                this.nativeFocus(this.mNativeObj, virtualViewId);
                break;
            }
            case 2: {
                this.nativeBlur(this.mNativeObj);
                break;
            }
        }
        return false;
    }

    public boolean onHoverEvent(MotionEvent event) {
        int cssY;
        if (!this.mAccessibilityManager.isEnabled() || this.mNativeObj == 0) {
            return false;
        }
        if (event.getAction() == 10) {
            return true;
        }
        this.mUserHasTouchExplored = true;
        float x = event.getX();
        float y = event.getY();
        int cssX = (int)(this.mRenderCoordinates.fromPixToLocalCss(x) + this.mRenderCoordinates.getScrollX());
        int id2 = this.nativeHitTest(this.mNativeObj, cssX, cssY = (int)(this.mRenderCoordinates.fromPixToLocalCss(y) + this.mRenderCoordinates.getScrollY()));
        if (this.mCurrentHoverId != id2) {
            this.sendAccessibilityEvent(this.mCurrentHoverId, 256);
            this.sendAccessibilityEvent(id2, 128);
            this.mCurrentHoverId = id2;
        }
        return true;
    }

    public void notifyFrameInfoInitialized() {
        if (this.mFrameInfoInitialized) {
            return;
        }
        this.mFrameInfoInitialized = true;
        if (this.mAccessibilityFocusId != -1) {
            this.sendAccessibilityEvent(this.mAccessibilityFocusId, 32768);
        }
    }

    private void sendAccessibilityEvent(int virtualViewId, int eventType) {
        if (!this.mAccessibilityManager.isEnabled() || this.mNativeObj == 0) {
            return;
        }
        AccessibilityEvent event = AccessibilityEvent.obtain(eventType);
        event.setPackageName(this.mContentViewCore.getContext().getPackageName());
        int rootId = this.nativeGetRootId(this.mNativeObj);
        if (virtualViewId == rootId) {
            virtualViewId = -1;
        }
        event.setSource(this.mView, virtualViewId);
        if (!this.nativePopulateAccessibilityEvent(this.mNativeObj, event, virtualViewId, eventType)) {
            return;
        }
        this.mContentViewCore.getContainerView().postInvalidate();
        this.mContentViewCore.getContainerView().requestSendAccessibilityEvent(this.mView, event);
    }

    @CalledByNative
    private void handlePageLoaded(int id2) {
        if (this.mUserHasTouchExplored) {
            return;
        }
        if (this.mFocusPageOnLoad) {
            this.mAccessibilityFocusId = id2;
            this.sendAccessibilityEvent(id2, 8);
        }
    }

    @CalledByNative
    private void handleFocusChanged(int id2) {
        if (this.mAccessibilityFocusId == id2) {
            return;
        }
        this.mAccessibilityFocusId = id2;
        this.sendAccessibilityEvent(id2, 8);
    }

    @CalledByNative
    private void handleCheckStateChanged(int id2) {
        this.sendAccessibilityEvent(id2, 1);
    }

    @CalledByNative
    private void handleTextSelectionChanged(int id2) {
        this.sendAccessibilityEvent(id2, 8192);
    }

    @CalledByNative
    private void handleEditableTextChanged(int id2) {
        this.sendAccessibilityEvent(id2, 16);
    }

    @CalledByNative
    private void handleContentChanged(int id2) {
        this.sendAccessibilityEvent(id2, 2048);
    }

    @CalledByNative
    private void handleNavigate() {
        this.mAccessibilityFocusId = -1;
        this.mUserHasTouchExplored = false;
        this.mFrameInfoInitialized = false;
    }

    @CalledByNative
    private void handleScrolledToAnchor(int id2) {
        if (this.mAccessibilityFocusId == id2) {
            return;
        }
        this.mAccessibilityFocusId = id2;
        this.sendAccessibilityEvent(id2, 32768);
    }

    @CalledByNative
    private void announceLiveRegionText(String text) {
        this.mView.announceForAccessibility(text);
    }

    @CalledByNative
    private void setAccessibilityNodeInfoParent(AccessibilityNodeInfo node, int parentId) {
        node.setParent(this.mView, parentId);
    }

    @CalledByNative
    private void addAccessibilityNodeInfoChild(AccessibilityNodeInfo node, int child_id) {
        node.addChild(this.mView, child_id);
    }

    @CalledByNative
    private void setAccessibilityNodeInfoBooleanAttributes(AccessibilityNodeInfo node, int virtualViewId, boolean checkable, boolean checked, boolean clickable, boolean enabled, boolean focusable, boolean focused, boolean password, boolean scrollable, boolean selected, boolean visibleToUser) {
        node.setCheckable(checkable);
        node.setChecked(checked);
        node.setClickable(clickable);
        node.setEnabled(enabled);
        node.setFocusable(focusable);
        node.setFocused(focused);
        node.setPassword(password);
        node.setScrollable(scrollable);
        node.setSelected(selected);
        node.setVisibleToUser(visibleToUser);
        if (focusable) {
            if (focused) {
                node.addAction(2);
            } else {
                node.addAction(1);
            }
        }
        if (this.mAccessibilityFocusId == virtualViewId) {
            node.setAccessibilityFocused(true);
            node.addAction(128);
        } else {
            node.setAccessibilityFocused(false);
            node.addAction(64);
        }
        if (clickable) {
            node.addAction(16);
        }
    }

    @CalledByNative
    private void setAccessibilityNodeInfoStringAttributes(AccessibilityNodeInfo node, String className, String contentDescription) {
        node.setClassName(className);
        node.setContentDescription(contentDescription);
    }

    @CalledByNative
    private void setAccessibilityNodeInfoLocation(AccessibilityNodeInfo node, int absoluteLeft, int absoluteTop, int parentRelativeLeft, int parentRelativeTop, int width, int height, boolean isRootNode) {
        Rect boundsInParent = new Rect(parentRelativeLeft, parentRelativeTop, parentRelativeLeft + width, parentRelativeTop + height);
        if (isRootNode) {
            boundsInParent.offset(0, (int)this.mRenderCoordinates.getContentOffsetYPix());
        }
        node.setBoundsInParent(boundsInParent);
        Rect rect = new Rect(absoluteLeft, absoluteTop, absoluteLeft + width, absoluteTop + height);
        rect.offset(-((int)this.mRenderCoordinates.getScrollX()), -((int)this.mRenderCoordinates.getScrollY()));
        rect.left = (int)this.mRenderCoordinates.fromLocalCssToPix(rect.left);
        rect.top = (int)this.mRenderCoordinates.fromLocalCssToPix(rect.top);
        rect.bottom = (int)this.mRenderCoordinates.fromLocalCssToPix(rect.bottom);
        rect.right = (int)this.mRenderCoordinates.fromLocalCssToPix(rect.right);
        rect.offset(0, (int)this.mRenderCoordinates.getContentOffsetYPix());
        int[] viewLocation = new int[2];
        this.mView.getLocationOnScreen(viewLocation);
        rect.offset(viewLocation[0], viewLocation[1]);
        node.setBoundsInScreen(rect);
    }

    @CalledByNative
    private void setAccessibilityEventBooleanAttributes(AccessibilityEvent event, boolean checked, boolean enabled, boolean password, boolean scrollable) {
        event.setChecked(checked);
        event.setEnabled(enabled);
        event.setPassword(password);
        event.setScrollable(scrollable);
    }

    @CalledByNative
    private void setAccessibilityEventClassName(AccessibilityEvent event, String className) {
        event.setClassName(className);
    }

    @CalledByNative
    private void setAccessibilityEventListAttributes(AccessibilityEvent event, int currentItemIndex, int itemCount) {
        event.setCurrentItemIndex(currentItemIndex);
        event.setItemCount(itemCount);
    }

    @CalledByNative
    private void setAccessibilityEventScrollAttributes(AccessibilityEvent event, int scrollX, int scrollY, int maxScrollX, int maxScrollY) {
        event.setScrollX(scrollX);
        event.setScrollY(scrollY);
        event.setMaxScrollX(maxScrollX);
        event.setMaxScrollY(maxScrollY);
    }

    @CalledByNative
    private void setAccessibilityEventTextChangedAttrs(AccessibilityEvent event, int fromIndex, int addedCount, int removedCount, String beforeText, String text) {
        event.setFromIndex(fromIndex);
        event.setAddedCount(addedCount);
        event.setRemovedCount(removedCount);
        event.setBeforeText(beforeText);
        event.getText().add(text);
    }

    @CalledByNative
    private void setAccessibilityEventSelectionAttrs(AccessibilityEvent event, int fromIndex, int addedCount, int itemCount, String text) {
        event.setFromIndex(fromIndex);
        event.setAddedCount(addedCount);
        event.setItemCount(itemCount);
        event.getText().add(text);
    }

    private native int nativeGetRootId(int var1);

    private native int nativeHitTest(int var1, int var2, int var3);

    private native boolean nativePopulateAccessibilityNodeInfo(int var1, AccessibilityNodeInfo var2, int var3);

    private native boolean nativePopulateAccessibilityEvent(int var1, AccessibilityEvent var2, int var3, int var4);

    private native void nativeClick(int var1, int var2);

    private native void nativeFocus(int var1, int var2);

    private native void nativeBlur(int var1);
}

