/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.input;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.text.format.Time;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.DatePicker;
import android.widget.TimePicker;
import org.chromium.content.R;
import org.chromium.content.browser.input.DateDialogNormalizer;

class DateTimePickerDialog
extends AlertDialog
implements DialogInterface.OnClickListener,
DatePicker.OnDateChangedListener,
TimePicker.OnTimeChangedListener {
    private static final String YEAR = "year";
    private static final String MONTH = "month";
    private static final String DAY = "day";
    private static final String HOUR = "hour";
    private static final String MINUTE = "minute";
    private static final String IS_24_HOUR = "is24hour";
    private final DatePicker mDatePicker;
    private final TimePicker mTimePicker;
    private final OnDateTimeSetListener mCallBack;
    private final long mMinTimeMillis;
    private final long mMaxTimeMillis;

    public DateTimePickerDialog(Context context, OnDateTimeSetListener callBack, int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minute, boolean is24HourView, long min, long max) {
        super(context, 0);
        this.mMinTimeMillis = min;
        this.mMaxTimeMillis = max;
        this.mCallBack = callBack;
        this.setButton(-1, context.getText(R.string.date_picker_dialog_set), this);
        this.setButton(-2, context.getText(0x1040000), (DialogInterface.OnClickListener)null);
        this.setIcon(0);
        this.setTitle(context.getText(R.string.date_time_picker_dialog_title));
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        View view = inflater.inflate(R.layout.date_time_picker_dialog, null);
        this.setView(view);
        this.mDatePicker = (DatePicker)view.findViewById(R.id.date_picker);
        DateDialogNormalizer.normalize(this.mDatePicker, this, year, monthOfYear, dayOfMonth, hourOfDay, minute, min, max);
        this.mTimePicker = (TimePicker)view.findViewById(R.id.time_picker);
        this.mTimePicker.setIs24HourView(is24HourView);
        this.mTimePicker.setCurrentHour(hourOfDay);
        this.mTimePicker.setCurrentMinute(minute);
        this.mTimePicker.setOnTimeChangedListener(this);
        this.onTimeChanged(this.mTimePicker, this.mTimePicker.getCurrentHour(), this.mTimePicker.getCurrentMinute());
    }

    public void onClick(DialogInterface dialog, int which) {
        this.tryNotifyDateTimeSet();
    }

    private void tryNotifyDateTimeSet() {
        if (this.mCallBack != null) {
            this.mDatePicker.clearFocus();
            this.mCallBack.onDateTimeSet(this.mDatePicker, this.mTimePicker, this.mDatePicker.getYear(), this.mDatePicker.getMonth(), this.mDatePicker.getDayOfMonth(), this.mTimePicker.getCurrentHour(), this.mTimePicker.getCurrentMinute());
        }
    }

    protected void onStop() {
        if (Build.VERSION.SDK_INT >= 16) {
            this.tryNotifyDateTimeSet();
        }
        super.onStop();
    }

    public void onDateChanged(DatePicker view, int year, int month, int day) {
        if (this.mTimePicker != null) {
            this.onTimeChanged(this.mTimePicker, this.mTimePicker.getCurrentHour(), this.mTimePicker.getCurrentMinute());
        }
    }

    public void onTimeChanged(TimePicker view, int hourOfDay, int minute) {
        Time time = new Time();
        time.set(0, this.mTimePicker.getCurrentMinute(), this.mTimePicker.getCurrentHour(), this.mDatePicker.getDayOfMonth(), this.mDatePicker.getMonth(), this.mDatePicker.getYear());
        if (time.toMillis(true) < this.mMinTimeMillis) {
            time.set(this.mMinTimeMillis);
        } else if (time.toMillis(true) > this.mMaxTimeMillis) {
            time.set(this.mMaxTimeMillis);
        }
        this.mTimePicker.setCurrentHour(time.hour);
        this.mTimePicker.setCurrentMinute(time.minute);
    }

    public void updateDateTime(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minutOfHour) {
        this.mDatePicker.updateDate(year, monthOfYear, dayOfMonth);
        this.mTimePicker.setCurrentHour(hourOfDay);
        this.mTimePicker.setCurrentMinute(minutOfHour);
    }

    public static interface OnDateTimeSetListener {
        public void onDateTimeSet(DatePicker var1, TimePicker var2, int var3, int var4, int var5, int var6, int var7);
    }
}

