/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.input;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import org.chromium.content.R;
import org.chromium.content.browser.input.TwoFieldDatePicker;

public abstract class TwoFieldDatePickerDialog
extends AlertDialog
implements DialogInterface.OnClickListener,
TwoFieldDatePicker.OnMonthOrWeekChangedListener {
    private static final String YEAR = "year";
    private static final String POSITION_IN_YEAR = "position_in_year";
    protected final TwoFieldDatePicker mPicker;
    protected final OnValueSetListener mCallBack;

    public TwoFieldDatePickerDialog(Context context, OnValueSetListener callBack, int year, int positionInYear, long minValue, long maxValue) {
        this(context, 0, callBack, year, positionInYear, minValue, maxValue);
    }

    public TwoFieldDatePickerDialog(Context context, int theme, OnValueSetListener callBack, int year, int positionInYear, long minValue, long maxValue) {
        super(context, theme);
        this.mCallBack = callBack;
        this.setButton(-1, context.getText(R.string.date_picker_dialog_set), this);
        this.setButton(-2, context.getText(0x1040000), (DialogInterface.OnClickListener)null);
        this.setIcon(0);
        this.mPicker = this.createPicker(context, minValue, maxValue);
        this.setView(this.mPicker);
        this.mPicker.init(year, positionInYear, this);
    }

    protected TwoFieldDatePicker createPicker(Context context, long minValue, long maxValue) {
        return null;
    }

    public void onClick(DialogInterface dialog, int which) {
        this.tryNotifyDateSet();
    }

    protected abstract void tryNotifyDateSet();

    protected void onStop() {
        if (Build.VERSION.SDK_INT >= 16) {
            this.tryNotifyDateSet();
        }
        super.onStop();
    }

    public void onMonthOrWeekChanged(TwoFieldDatePicker view, int year, int positionInYear) {
        this.mPicker.init(year, positionInYear, null);
    }

    public void updateDate(int year, int weekOfYear) {
        this.mPicker.updateDate(year, weekOfYear);
    }

    public static interface OnValueSetListener {
        public void onValueSet(int var1, int var2);
    }
}

