/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.media;

import android.media.AudioTrack;
import android.media.MediaCodec;
import android.media.MediaCrypto;
import android.media.MediaFormat;
import android.util.Log;
import android.view.Surface;
import java.nio.ByteBuffer;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;

@JNINamespace(value="media")
class MediaCodecBridge {
    private static final String TAG = "MediaCodecBridge";
    private static final int MEDIA_CODEC_OK = 0;
    private static final int MEDIA_CODEC_ERROR = -1000;
    private static final long MAX_PRESENTATION_TIMESTAMP_SHIFT_US = 100000L;
    private ByteBuffer[] mInputBuffers;
    private ByteBuffer[] mOutputBuffers;
    private MediaCodec mMediaCodec;
    private AudioTrack mAudioTrack;
    private boolean mFlushed;
    private long mLastPresentationTimeUs;

    private MediaCodecBridge(String mime) {
        this.mMediaCodec = MediaCodec.createDecoderByType(mime);
        this.mLastPresentationTimeUs = 0L;
        this.mFlushed = true;
    }

    @CalledByNative
    private static MediaCodecBridge create(String mime) {
        return new MediaCodecBridge(mime);
    }

    @CalledByNative
    private void release() {
        this.mMediaCodec.release();
        if (this.mAudioTrack != null) {
            this.mAudioTrack.release();
        }
    }

    @CalledByNative
    private void start() {
        this.mMediaCodec.start();
        this.mInputBuffers = this.mMediaCodec.getInputBuffers();
    }

    @CalledByNative
    private int dequeueInputBuffer(long timeoutUs) {
        try {
            return this.mMediaCodec.dequeueInputBuffer(timeoutUs);
        }
        catch (Exception e) {
            Log.e(TAG, "Cannot dequeue Input buffer " + e.toString());
            return -1000;
        }
    }

    @CalledByNative
    private int flush() {
        try {
            this.mFlushed = true;
            if (this.mAudioTrack != null) {
                this.mAudioTrack.flush();
            }
            this.mMediaCodec.flush();
        }
        catch (IllegalStateException e) {
            Log.e(TAG, "Failed to flush MediaCodec " + e.toString());
            return -1000;
        }
        return 0;
    }

    @CalledByNative
    private void stop() {
        this.mMediaCodec.stop();
        if (this.mAudioTrack != null) {
            this.mAudioTrack.pause();
        }
    }

    @CalledByNative
    private int getOutputHeight() {
        return this.mMediaCodec.getOutputFormat().getInteger("height");
    }

    @CalledByNative
    private int getOutputWidth() {
        return this.mMediaCodec.getOutputFormat().getInteger("width");
    }

    @CalledByNative
    private ByteBuffer getInputBuffer(int index) {
        return this.mInputBuffers[index];
    }

    @CalledByNative
    private ByteBuffer getOutputBuffer(int index) {
        return this.mOutputBuffers[index];
    }

    @CalledByNative
    private void queueInputBuffer(int index, int offset, int size, long presentationTimeUs, int flags) {
        this.resetLastPresentationTimeIfNeeded(presentationTimeUs);
        try {
            this.mMediaCodec.queueInputBuffer(index, offset, size, presentationTimeUs, flags);
        }
        catch (IllegalStateException e) {
            Log.e(TAG, "Failed to queue input buffer " + e.toString());
        }
    }

    @CalledByNative
    private void queueSecureInputBuffer(int index, int offset, byte[] iv, byte[] keyId, int[] numBytesOfClearData, int[] numBytesOfEncryptedData, int numSubSamples, long presentationTimeUs) {
        this.resetLastPresentationTimeIfNeeded(presentationTimeUs);
        try {
            MediaCodec.CryptoInfo cryptoInfo = new MediaCodec.CryptoInfo();
            cryptoInfo.set(numSubSamples, numBytesOfClearData, numBytesOfEncryptedData, keyId, iv, 1);
            this.mMediaCodec.queueSecureInputBuffer(index, offset, cryptoInfo, presentationTimeUs, 0);
        }
        catch (IllegalStateException e) {
            Log.e(TAG, "Failed to queue secure input buffer " + e.toString());
        }
    }

    @CalledByNative
    private void releaseOutputBuffer(int index, boolean render) {
        this.mMediaCodec.releaseOutputBuffer(index, render);
    }

    @CalledByNative
    private void getOutputBuffers() {
        this.mOutputBuffers = this.mMediaCodec.getOutputBuffers();
    }

    @CalledByNative
    private DequeueOutputResult dequeueOutputBuffer(long timeoutUs) {
        MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
        int index = -1000;
        try {
            index = this.mMediaCodec.dequeueOutputBuffer(info, timeoutUs);
            if (info.presentationTimeUs < this.mLastPresentationTimeUs) {
                info.presentationTimeUs = this.mLastPresentationTimeUs;
            }
            this.mLastPresentationTimeUs = info.presentationTimeUs;
        }
        catch (IllegalStateException e) {
            Log.e(TAG, "Cannot dequeue output buffer " + e.toString());
        }
        return new DequeueOutputResult(index, info.flags, info.offset, info.presentationTimeUs, info.size);
    }

    @CalledByNative
    private boolean configureVideo(MediaFormat format, Surface surface, MediaCrypto crypto, int flags) {
        try {
            this.mMediaCodec.configure(format, surface, crypto, flags);
            return true;
        }
        catch (IllegalStateException e) {
            Log.e(TAG, "Cannot configure the video codec " + e.toString());
            return false;
        }
    }

    @CalledByNative
    private static MediaFormat createAudioFormat(String mime, int SampleRate, int ChannelCount) {
        return MediaFormat.createAudioFormat(mime, SampleRate, ChannelCount);
    }

    @CalledByNative
    private static MediaFormat createVideoFormat(String mime, int width, int height) {
        return MediaFormat.createVideoFormat(mime, width, height);
    }

    @CalledByNative
    private static void setCodecSpecificData(MediaFormat format, int index, byte[] bytes) {
        String name = null;
        if (index == 0) {
            name = "csd-0";
        } else if (index == 1) {
            name = "csd-1";
        }
        if (name != null) {
            format.setByteBuffer(name, ByteBuffer.wrap(bytes));
        }
    }

    @CalledByNative
    private static void setFrameHasADTSHeader(MediaFormat format) {
        format.setInteger("is-adts", 1);
    }

    @CalledByNative
    private boolean configureAudio(MediaFormat format, MediaCrypto crypto, int flags, boolean playAudio) {
        try {
            this.mMediaCodec.configure(format, null, crypto, flags);
            if (playAudio) {
                int sampleRate = format.getInteger("sample-rate");
                int channelCount = format.getInteger("channel-count");
                int channelConfig = channelCount == 1 ? 4 : 12;
                int minBufferSize = AudioTrack.getMinBufferSize(sampleRate, channelConfig, 2);
                this.mAudioTrack = new AudioTrack(3, sampleRate, channelConfig, 2, minBufferSize, 1);
            }
            return true;
        }
        catch (IllegalStateException e) {
            Log.e(TAG, "Cannot configure the audio codec " + e.toString());
            return false;
        }
    }

    @CalledByNative
    private void playOutputBuffer(byte[] buf) {
        if (this.mAudioTrack != null) {
            int size;
            if (3 != this.mAudioTrack.getPlayState()) {
                this.mAudioTrack.play();
            }
            if (buf.length != (size = this.mAudioTrack.write(buf, 0, buf.length))) {
                Log.i(TAG, "Failed to send all data to audio output, expected size: " + buf.length + ", actual size: " + size);
            }
        }
    }

    @CalledByNative
    private void setVolume(double volume) {
        if (this.mAudioTrack != null) {
            this.mAudioTrack.setStereoVolume((float)volume, (float)volume);
        }
    }

    private void resetLastPresentationTimeIfNeeded(long presentationTimeUs) {
        if (this.mFlushed) {
            this.mLastPresentationTimeUs = Math.max(presentationTimeUs - 100000L, 0L);
            this.mFlushed = false;
        }
    }

    private static class DequeueOutputResult {
        private final int mIndex;
        private final int mFlags;
        private final int mOffset;
        private final long mPresentationTimeMicroseconds;
        private final int mNumBytes;

        private DequeueOutputResult(int index, int flags, int offset, long presentationTimeMicroseconds, int numBytes) {
            this.mIndex = index;
            this.mFlags = flags;
            this.mOffset = offset;
            this.mPresentationTimeMicroseconds = presentationTimeMicroseconds;
            this.mNumBytes = numBytes;
        }

        @CalledByNative(value="DequeueOutputResult")
        private int index() {
            return this.mIndex;
        }

        @CalledByNative(value="DequeueOutputResult")
        private int flags() {
            return this.mFlags;
        }

        @CalledByNative(value="DequeueOutputResult")
        private int offset() {
            return this.mOffset;
        }

        @CalledByNative(value="DequeueOutputResult")
        private long presentationTimeMicroseconds() {
            return this.mPresentationTimeMicroseconds;
        }

        @CalledByNative(value="DequeueOutputResult")
        private int numBytes() {
            return this.mNumBytes;
        }
    }
}

