/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net;

import android.util.Log;
import java.lang.reflect.Method;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.interfaces.DSAKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.ECKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.ECParameterSpec;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;

@JNINamespace(value="net::android")
public class AndroidKeyStore {
    private static final String TAG = "AndroidKeyStore";

    @CalledByNative
    public static byte[] getRSAKeyModulus(PrivateKey key) {
        if (key instanceof RSAKey) {
            return ((RSAKey)((Object)key)).getModulus().toByteArray();
        }
        Log.w(TAG, "Not a RSAKey instance!");
        return null;
    }

    @CalledByNative
    public static byte[] getDSAKeyParamQ(PrivateKey key) {
        if (key instanceof DSAKey) {
            DSAParams params = ((DSAKey)((Object)key)).getParams();
            return params.getQ().toByteArray();
        }
        Log.w(TAG, "Not a DSAKey instance!");
        return null;
    }

    @CalledByNative
    public static byte[] getECKeyOrder(PrivateKey key) {
        if (key instanceof ECKey) {
            ECParameterSpec params = ((ECKey)((Object)key)).getParams();
            return params.getOrder().toByteArray();
        }
        Log.w(TAG, "Not an ECKey instance!");
        return null;
    }

    @CalledByNative
    public static byte[] getPrivateKeyEncodedBytes(PrivateKey key) {
        return key.getEncoded();
    }

    @CalledByNative
    public static byte[] rawSignDigestWithPrivateKey(PrivateKey privateKey, byte[] message) {
        Signature signature = null;
        try {
            if (privateKey instanceof RSAPrivateKey) {
                signature = Signature.getInstance("NONEwithRSA");
            } else if (privateKey instanceof DSAPrivateKey) {
                signature = Signature.getInstance("NONEwithDSA");
            } else if (privateKey instanceof ECPrivateKey) {
                signature = Signature.getInstance("NONEwithECDSA");
            }
        }
        catch (NoSuchAlgorithmException e) {
            // empty catch block
        }
        if (signature == null) {
            Log.e(TAG, "Unsupported private key algorithm: " + privateKey.getAlgorithm());
            return null;
        }
        try {
            signature.initSign(privateKey);
            signature.update(message);
            return signature.sign();
        }
        catch (Exception e) {
            Log.e(TAG, "Exception while signing message with " + privateKey.getAlgorithm() + " private key: " + e);
            return null;
        }
    }

    @CalledByNative
    public static int getPrivateKeyType(PrivateKey privateKey) {
        if (privateKey instanceof RSAPrivateKey) {
            return 0;
        }
        if (privateKey instanceof DSAPrivateKey) {
            return 1;
        }
        if (privateKey instanceof ECPrivateKey) {
            return 2;
        }
        return 255;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public static int getOpenSSLHandleForPrivateKey(PrivateKey privateKey) {
        Class<?> superClass;
        if (privateKey == null) {
            Log.e(TAG, "privateKey == null");
            return 0;
        }
        if (!(privateKey instanceof RSAPrivateKey)) {
            Log.e(TAG, "does not implement RSAPrivateKey");
            return 0;
        }
        try {
            superClass = Class.forName("org.apache.harmony.xnet.provider.jsse.OpenSSLRSAPrivateKey");
        }
        catch (Exception e) {
            Log.e(TAG, "Cannot find system OpenSSLRSAPrivateKey class: " + e);
            return 0;
        }
        if (!superClass.isInstance(privateKey)) {
            Log.e(TAG, "Private key is not an OpenSSLRSAPrivateKey instance, its class name is:" + privateKey.getClass().getCanonicalName());
            return 0;
        }
        try {
            Method getPkeyContext;
            Method getKey = superClass.getDeclaredMethod("getOpenSSLKey", new Class[0]);
            getKey.setAccessible(true);
            Object opensslKey = null;
            try {
                opensslKey = getKey.invoke(privateKey, new Object[0]);
            }
            finally {
                getKey.setAccessible(false);
            }
            if (opensslKey == null) {
                Log.e(TAG, "getOpenSSLKey() returned null");
                return 0;
            }
            try {
                getPkeyContext = opensslKey.getClass().getDeclaredMethod("getPkeyContext", new Class[0]);
            }
            catch (Exception e) {
                Log.e(TAG, "No getPkeyContext() method on OpenSSLKey member:" + e);
                return 0;
            }
            getPkeyContext.setAccessible(true);
            int evp_pkey = 0;
            try {
                evp_pkey = (Integer)getPkeyContext.invoke(opensslKey, new Object[0]);
            }
            finally {
                getPkeyContext.setAccessible(false);
            }
            if (evp_pkey == 0) {
                Log.e(TAG, "getPkeyContext() returned null");
            }
            return evp_pkey;
        }
        catch (Exception e) {
            Log.e(TAG, "Exception while trying to retrieve system EVP_PKEY handle: " + e);
            return 0;
        }
    }
}

