/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.util.Log;
import org.chromium.base.ActivityStatus;

public class NetworkChangeNotifierAutoDetect
extends BroadcastReceiver
implements ActivityStatus.StateListener {
    private static final String TAG = "NetworkChangeNotifierAutoDetect";
    private final NetworkConnectivityIntentFilter mIntentFilter = new NetworkConnectivityIntentFilter();
    private final Observer mObserver;
    private final Context mContext;
    private ConnectivityManagerDelegate mConnectivityManagerDelegate;
    private boolean mRegistered;
    private int mConnectionType;

    public NetworkChangeNotifierAutoDetect(Observer observer, Context context) {
        this.mObserver = observer;
        this.mContext = context.getApplicationContext();
        this.mConnectivityManagerDelegate = new ConnectivityManagerDelegate(context);
        this.mConnectionType = this.getCurrentConnectionType();
        ActivityStatus.registerStateListener(this);
    }

    void setConnectivityManagerDelegateForTests(ConnectivityManagerDelegate delegate) {
        this.mConnectivityManagerDelegate = delegate;
    }

    public void destroy() {
        this.unregisterReceiver();
    }

    private void registerReceiver() {
        if (!this.mRegistered) {
            this.mRegistered = true;
            this.mContext.registerReceiver(this, this.mIntentFilter);
        }
    }

    private void unregisterReceiver() {
        if (this.mRegistered) {
            this.mRegistered = false;
            this.mContext.unregisterReceiver(this);
        }
    }

    public int getCurrentConnectionType() {
        if (!this.mConnectivityManagerDelegate.activeNetworkExists() || !this.mConnectivityManagerDelegate.isConnected()) {
            return 6;
        }
        switch (this.mConnectivityManagerDelegate.getNetworkType()) {
            case 9: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 6: {
                return 5;
            }
            case 0: {
                switch (this.mConnectivityManagerDelegate.getNetworkSubtype()) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: {
                        return 3;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: {
                        return 4;
                    }
                    case 13: {
                        return 5;
                    }
                }
                return 0;
            }
        }
        return 0;
    }

    public void onReceive(Context context, Intent intent) {
        this.connectionTypeChanged();
    }

    public void onActivityStateChange(int state) {
        if (state == 3) {
            this.connectionTypeChanged();
            this.registerReceiver();
        } else if (state == 4) {
            this.unregisterReceiver();
        }
    }

    private void connectionTypeChanged() {
        int newConnectionType = this.getCurrentConnectionType();
        if (newConnectionType == this.mConnectionType) {
            return;
        }
        this.mConnectionType = newConnectionType;
        Log.d(TAG, "Network connectivity changed, type is: " + this.mConnectionType);
        this.mObserver.onConnectionTypeChanged(newConnectionType);
    }

    private static class NetworkConnectivityIntentFilter
    extends IntentFilter {
        NetworkConnectivityIntentFilter() {
            this.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        }
    }

    public static interface Observer {
        public void onConnectionTypeChanged(int var1);
    }

    static class ConnectivityManagerDelegate {
        private final ConnectivityManager mConnectivityManager;

        ConnectivityManagerDelegate(Context context) {
            this.mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        }

        ConnectivityManagerDelegate() {
            this.mConnectivityManager = null;
        }

        boolean activeNetworkExists() {
            return this.mConnectivityManager.getActiveNetworkInfo() != null;
        }

        boolean isConnected() {
            return this.mConnectivityManager.getActiveNetworkInfo().isConnected();
        }

        int getNetworkType() {
            return this.mConnectivityManager.getActiveNetworkInfo().getType();
        }

        int getNetworkSubtype() {
            return this.mConnectivityManager.getActiveNetworkInfo().getSubtype();
        }
    }
}

