/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import org.chromium.ui.WindowAndroid;

public class ActivityWindowAndroid
extends WindowAndroid {
    private static final int REQUEST_CODE_PREFIX = 1000;
    private static final int REQUEST_CODE_RANGE_SIZE = 100;
    private static final String TAG = "ActivityWindowAndroid";
    private Activity mActivity;
    private int mNextRequestCode = 0;

    public ActivityWindowAndroid(Activity activity) {
        super(activity.getApplicationContext());
        this.mActivity = activity;
    }

    public boolean showIntent(Intent intent, WindowAndroid.IntentCallback callback, int errorId) {
        int requestCode = 1000 + this.mNextRequestCode;
        this.mNextRequestCode = (this.mNextRequestCode + 1) % 100;
        try {
            this.mActivity.startActivityForResult(intent, requestCode);
        }
        catch (ActivityNotFoundException e) {
            return false;
        }
        this.mOutstandingIntents.put(requestCode, callback);
        this.mIntentErrors.put(requestCode, this.mApplicationContext.getString(errorId));
        return true;
    }

    public boolean onActivityResult(int requestCode, int resultCode, Intent data) {
        WindowAndroid.IntentCallback callback = (WindowAndroid.IntentCallback)this.mOutstandingIntents.get(requestCode);
        this.mOutstandingIntents.delete(requestCode);
        String errorMessage = (String)this.mIntentErrors.remove(requestCode);
        if (callback != null) {
            callback.onIntentCompleted(this, resultCode, this.mApplicationContext.getContentResolver(), data);
            return true;
        }
        if (errorMessage != null) {
            this.showCallbackNonExistentError(errorMessage);
            return true;
        }
        return false;
    }

    @Deprecated
    public Context getContext() {
        return this.mActivity;
    }
}

