/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import org.chromium.ui.OnColorChangedListener;
import org.chromium.ui.R;

public class ColorPickerSimple
extends View {
    private static final int ROW_COUNT = 2;
    private static final int COLUMN_COUNT = 4;
    private static final int GRID_CELL_COUNT = 8;
    private static final int[] COLORS = new int[]{-65536, -16711681, -16776961, -16711936, -65281, -256, -16777216, -1};
    private Paint mBorderPaint;
    private Rect[] mBounds;
    private Paint[] mPaints;
    private OnColorChangedListener mOnColorTouchedListener;
    private int mLastTouchedXPosition;
    private int mLastTouchedYPosition;

    public ColorPickerSimple(Context context) {
        super(context);
    }

    public ColorPickerSimple(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ColorPickerSimple(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void init(OnColorChangedListener onColorChangedListener) {
        this.mOnColorTouchedListener = onColorChangedListener;
        this.mBounds = null;
        this.mPaints = new Paint[8];
        for (int i = 0; i < 8; ++i) {
            Paint newPaint = new Paint();
            newPaint.setColor(COLORS[i]);
            this.mPaints[i] = newPaint;
        }
        this.mBorderPaint = new Paint();
        int borderColor = this.getContext().getResources().getColor(R.color.color_picker_border_color);
        this.mBorderPaint.setColor(borderColor);
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ColorPickerSimple.this.mOnColorTouchedListener != null && ColorPickerSimple.this.getWidth() > 0 && ColorPickerSimple.this.getHeight() > 0) {
                    int column = ColorPickerSimple.this.mLastTouchedXPosition * 4 / ColorPickerSimple.this.getWidth();
                    int row = ColorPickerSimple.this.mLastTouchedYPosition * 2 / ColorPickerSimple.this.getHeight();
                    int colorIndex = row * 4 + column;
                    if (colorIndex >= 0 && colorIndex < COLORS.length) {
                        ColorPickerSimple.this.mOnColorTouchedListener.onColorChanged(COLORS[colorIndex]);
                    }
                }
            }
        });
    }

    public void onDraw(Canvas canvas) {
        int i;
        if (this.mBounds == null || this.mPaints == null) {
            return;
        }
        canvas.drawColor(-1);
        for (i = 0; i < 8; ++i) {
            canvas.drawRect(this.mBounds[i], this.mPaints[i]);
        }
        for (i = 0; i < 1; ++i) {
            canvas.drawLine(0.0f, this.mBounds[i * 4].bottom + 1, this.getWidth(), this.mBounds[i * 4].bottom + 1, this.mBorderPaint);
        }
        for (int j = 0; j < 3; ++j) {
            canvas.drawLine(this.mBounds[j].right + 1, 0.0f, this.mBounds[j].right + 1, this.getHeight(), this.mBorderPaint);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (event.getAction() == 0) {
            this.mLastTouchedXPosition = (int)event.getX();
            this.mLastTouchedYPosition = (int)event.getY();
        }
        return super.onTouchEvent(event);
    }

    protected void onSizeChanged(int width, int height, int oldw, int oldh) {
        this.calculateGrid(width, height);
    }

    private void calculateGrid(int width, int height) {
        this.mBounds = new Rect[8];
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 4; ++j) {
                Rect rect;
                int left = j * (width + 1) / 4 + 1;
                int right = (j + 1) * (width + 1) / 4 - 2;
                int top = i * (height + 1) / 2 + 1;
                int bottom = (i + 1) * (height + 1) / 2 - 2;
                this.mBounds[i * 4 + j] = rect = new Rect(left, top, right, bottom);
            }
        }
    }
}

