/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui;

import android.os.Build;
import android.text.TextUtils;
import java.util.Locale;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;

@JNINamespace(value="l10n_util")
public class LocalizationUtils {
    public static final int UNKNOWN_DIRECTION = 0;
    public static final int RIGHT_TO_LEFT = 1;
    public static final int LEFT_TO_RIGHT = 2;

    private LocalizationUtils() {
    }

    @CalledByNative
    public static String getDefaultLocale() {
        Locale locale = Locale.getDefault();
        String language = locale.getLanguage();
        String country = locale.getCountry();
        if ("iw".equals(language)) {
            language = "he";
        } else if ("in".equals(language)) {
            language = "id";
        } else if ("tl".equals(language)) {
            language = "fil";
        }
        return country.isEmpty() ? language : language + "-" + country;
    }

    @CalledByNative
    private static Locale getJavaLocale(String language, String country, String variant) {
        return new Locale(language, country, variant);
    }

    @CalledByNative
    private static String getDisplayNameForLocale(Locale locale, Locale displayLocale) {
        return locale.getDisplayName(displayLocale);
    }

    public static boolean isSystemLayoutDirectionRtl() {
        if (Build.VERSION.SDK_INT >= 17) {
            return TextUtils.getLayoutDirectionFromLocale(Locale.getDefault()) == 1;
        }
        return false;
    }

    public static boolean isRtl() {
        return LocalizationUtils.nativeIsRTL();
    }

    public static int getFirstStrongCharacterDirection(String string2) {
        return LocalizationUtils.nativeGetFirstStrongCharacterDirection(string2);
    }

    private static native boolean nativeIsRTL();

    private static native int nativeGetFirstStrongCharacterDirection(String var0);
}

