/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.util.SparseArray;
import android.widget.Toast;
import java.io.Serializable;
import java.util.HashMap;
import org.chromium.base.JNINamespace;

@JNINamespace(value="ui")
public class WindowAndroid {
    private static final String TAG = "WindowAndroid";
    private int mNativeWindowAndroid = 0;
    static final String WINDOW_CALLBACK_ERRORS = "window_callback_errors";
    protected Context mApplicationContext;
    protected SparseArray<IntentCallback> mOutstandingIntents;
    protected HashMap<Integer, String> mIntentErrors;

    public WindowAndroid(Context context) {
        assert (context == context.getApplicationContext());
        this.mApplicationContext = context;
        this.mOutstandingIntents = new SparseArray();
        this.mIntentErrors = new HashMap();
    }

    public boolean showIntent(Intent intent, IntentCallback callback, int errorId) {
        Log.d(TAG, "Can't show intent as context is not an Activity: " + intent);
        return false;
    }

    public void showError(String error) {
        if (error != null) {
            Toast.makeText(this.mApplicationContext, error, 0).show();
        }
    }

    public void showError(int resId) {
        this.showError(this.mApplicationContext.getString(resId));
    }

    protected void showCallbackNonExistentError(String error) {
        this.showError(error);
    }

    public void sendBroadcast(Intent intent) {
        this.mApplicationContext.sendBroadcast(intent);
    }

    @Deprecated
    public Context getContext() {
        return null;
    }

    public Context getApplicationContext() {
        return this.mApplicationContext;
    }

    public void saveInstanceState(Bundle bundle) {
        bundle.putSerializable(WINDOW_CALLBACK_ERRORS, this.mIntentErrors);
    }

    public void restoreInstanceState(Bundle bundle) {
        if (bundle == null) {
            return;
        }
        Serializable errors = bundle.getSerializable(WINDOW_CALLBACK_ERRORS);
        if (errors instanceof HashMap) {
            HashMap intentErrors;
            this.mIntentErrors = intentErrors = (HashMap)errors;
        }
    }

    public boolean onActivityResult(int requestCode, int resultCode, Intent data) {
        return false;
    }

    public void destroy() {
        if (this.mNativeWindowAndroid != 0) {
            this.nativeDestroy(this.mNativeWindowAndroid);
            this.mNativeWindowAndroid = 0;
        }
    }

    public int getNativePointer() {
        if (this.mNativeWindowAndroid == 0) {
            this.mNativeWindowAndroid = this.nativeInit();
        }
        return this.mNativeWindowAndroid;
    }

    private native int nativeInit();

    private native void nativeDestroy(int var1);

    public static interface IntentCallback {
        public void onIntentCompleted(WindowAndroid var1, int var2, ContentResolver var3, Intent var4);
    }
}

