/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.crypto.Cipher;
import org.conscrypt.NativeCrypto;

public class CipherSuite {
    boolean supported = true;
    final int keyExchange;
    final String authType;
    final String cipherName;
    final int keyMaterial;
    final int expandedKeyMaterial;
    final int effectiveKeyBytes;
    final int ivSize;
    private final int blockSize;
    private final byte[] cipherSuiteCode;
    private final String name;
    private final boolean isExportable;
    private final String hashName;
    private final String hmacName;
    private final int hashSize;
    private final boolean needInitialRecordSplit;
    static final int KEY_EXCHANGE_RSA = 1;
    static final int KEY_EXCHANGE_RSA_EXPORT = 2;
    static final int KEY_EXCHANGE_DHE_DSS = 3;
    static final int KEY_EXCHANGE_DHE_DSS_EXPORT = 4;
    static final int KEY_EXCHANGE_DHE_RSA = 5;
    static final int KEY_EXCHANGE_DHE_RSA_EXPORT = 6;
    static final int KEY_EXCHANGE_DH_anon = 9;
    static final int KEY_EXCHANGE_DH_anon_EXPORT = 10;
    static final int KEY_EXCHANGE_ECDH_ECDSA = 13;
    static final int KEY_EXCHANGE_ECDHE_ECDSA = 14;
    static final int KEY_EXCHANGE_ECDH_RSA = 15;
    static final int KEY_EXCHANGE_ECDHE_RSA = 16;
    static final int KEY_EXCHANGE_ECDH_anon = 17;
    static final byte[] CODE_SSL_NULL_WITH_NULL_NULL = new byte[]{0, 0};
    static final byte[] CODE_SSL_RSA_WITH_NULL_MD5 = new byte[]{0, 1};
    static final byte[] CODE_SSL_RSA_WITH_NULL_SHA = new byte[]{0, 2};
    static final byte[] CODE_SSL_RSA_EXPORT_WITH_RC4_40_MD5 = new byte[]{0, 3};
    static final byte[] CODE_SSL_RSA_WITH_RC4_128_MD5 = new byte[]{0, 4};
    static final byte[] CODE_SSL_RSA_WITH_RC4_128_SHA = new byte[]{0, 5};
    static final byte[] CODE_SSL_RSA_EXPORT_WITH_RC2_CBC_40_MD5 = new byte[]{0, 6};
    static final byte[] CODE_SSL_RSA_EXPORT_WITH_DES40_CBC_SHA = new byte[]{0, 8};
    static final byte[] CODE_SSL_RSA_WITH_DES_CBC_SHA = new byte[]{0, 9};
    static final byte[] CODE_SSL_RSA_WITH_3DES_EDE_CBC_SHA = new byte[]{0, 10};
    static final byte[] CODE_SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA = new byte[]{0, 17};
    static final byte[] CODE_SSL_DHE_DSS_WITH_DES_CBC_SHA = new byte[]{0, 18};
    static final byte[] CODE_SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA = new byte[]{0, 19};
    static final byte[] CODE_SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA = new byte[]{0, 20};
    static final byte[] CODE_SSL_DHE_RSA_WITH_DES_CBC_SHA = new byte[]{0, 21};
    static final byte[] CODE_SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA = new byte[]{0, 22};
    static final byte[] CODE_SSL_DH_anon_EXPORT_WITH_RC4_40_MD5 = new byte[]{0, 23};
    static final byte[] CODE_SSL_DH_anon_WITH_RC4_128_MD5 = new byte[]{0, 24};
    static final byte[] CODE_SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA = new byte[]{0, 25};
    static final byte[] CODE_SSL_DH_anon_WITH_DES_CBC_SHA = new byte[]{0, 26};
    static final byte[] CODE_SSL_DH_anon_WITH_3DES_EDE_CBC_SHA = new byte[]{0, 27};
    static final byte[] CODE_TLS_RSA_WITH_AES_128_CBC_SHA = new byte[]{0, 47};
    static final byte[] CODE_TLS_DHE_DSS_WITH_AES_128_CBC_SHA = new byte[]{0, 50};
    static final byte[] CODE_TLS_DHE_RSA_WITH_AES_128_CBC_SHA = new byte[]{0, 51};
    static final byte[] CODE_TLS_DH_anon_WITH_AES_128_CBC_SHA = new byte[]{0, 52};
    static final byte[] CODE_TLS_RSA_WITH_AES_256_CBC_SHA = new byte[]{0, 53};
    static final byte[] CODE_TLS_DHE_DSS_WITH_AES_256_CBC_SHA = new byte[]{0, 56};
    static final byte[] CODE_TLS_DHE_RSA_WITH_AES_256_CBC_SHA = new byte[]{0, 57};
    static final byte[] CODE_TLS_DH_anon_WITH_AES_256_CBC_SHA = new byte[]{0, 58};
    static final byte[] CODE_TLS_ECDH_ECDSA_WITH_NULL_SHA = new byte[]{-64, 1};
    static final byte[] CODE_TLS_ECDH_ECDSA_WITH_RC4_128_SHA = new byte[]{-64, 2};
    static final byte[] CODE_TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA = new byte[]{-64, 3};
    static final byte[] CODE_TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA = new byte[]{-64, 4};
    static final byte[] CODE_TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA = new byte[]{-64, 5};
    static final byte[] CODE_TLS_ECDHE_ECDSA_WITH_NULL_SHA = new byte[]{-64, 6};
    static final byte[] CODE_TLS_ECDHE_ECDSA_WITH_RC4_128_SHA = new byte[]{-64, 7};
    static final byte[] CODE_TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA = new byte[]{-64, 8};
    static final byte[] CODE_TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA = new byte[]{-64, 9};
    static final byte[] CODE_TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA = new byte[]{-64, 10};
    static final byte[] CODE_TLS_ECDH_RSA_WITH_NULL_SHA = new byte[]{-64, 11};
    static final byte[] CODE_TLS_ECDH_RSA_WITH_RC4_128_SHA = new byte[]{-64, 12};
    static final byte[] CODE_TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA = new byte[]{-64, 13};
    static final byte[] CODE_TLS_ECDH_RSA_WITH_AES_128_CBC_SHA = new byte[]{-64, 14};
    static final byte[] CODE_TLS_ECDH_RSA_WITH_AES_256_CBC_SHA = new byte[]{-64, 15};
    static final byte[] CODE_TLS_ECDHE_RSA_WITH_NULL_SHA = new byte[]{-64, 16};
    static final byte[] CODE_TLS_ECDHE_RSA_WITH_RC4_128_SHA = new byte[]{-64, 17};
    static final byte[] CODE_TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA = new byte[]{-64, 18};
    static final byte[] CODE_TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA = new byte[]{-64, 19};
    static final byte[] CODE_TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA = new byte[]{-64, 20};
    static final byte[] CODE_TLS_ECDH_anon_WITH_NULL_SHA = new byte[]{-64, 21};
    static final byte[] CODE_TLS_ECDH_anon_WITH_RC4_128_SHA = new byte[]{-64, 22};
    static final byte[] CODE_TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA = new byte[]{-64, 23};
    static final byte[] CODE_TLS_ECDH_anon_WITH_AES_128_CBC_SHA = new byte[]{-64, 24};
    static final byte[] CODE_TLS_ECDH_anon_WITH_AES_256_CBC_SHA = new byte[]{-64, 25};
    static final CipherSuite SSL_NULL_WITH_NULL_NULL = new CipherSuite("SSL_NULL_WITH_NULL_NULL", true, 0, null, null, null, CODE_SSL_NULL_WITH_NULL_NULL);
    static final CipherSuite SSL_RSA_WITH_NULL_MD5 = new CipherSuite("SSL_RSA_WITH_NULL_MD5", true, 1, "RSA", null, "MD5", CODE_SSL_RSA_WITH_NULL_MD5);
    static final CipherSuite SSL_RSA_WITH_NULL_SHA = new CipherSuite("SSL_RSA_WITH_NULL_SHA", true, 1, "RSA", null, "SHA", CODE_SSL_RSA_WITH_NULL_SHA);
    static final CipherSuite SSL_RSA_EXPORT_WITH_RC4_40_MD5 = new CipherSuite("SSL_RSA_EXPORT_WITH_RC4_40_MD5", true, 2, "RSA", "RC4_40", "MD5", CODE_SSL_RSA_EXPORT_WITH_RC4_40_MD5);
    static final CipherSuite SSL_RSA_WITH_RC4_128_MD5 = new CipherSuite("SSL_RSA_WITH_RC4_128_MD5", false, 1, "RSA", "RC4_128", "MD5", CODE_SSL_RSA_WITH_RC4_128_MD5);
    static final CipherSuite SSL_RSA_WITH_RC4_128_SHA = new CipherSuite("SSL_RSA_WITH_RC4_128_SHA", false, 1, "RSA", "RC4_128", "SHA", CODE_SSL_RSA_WITH_RC4_128_SHA);
    static final CipherSuite SSL_RSA_EXPORT_WITH_RC2_CBC_40_MD5 = new CipherSuite("SSL_RSA_EXPORT_WITH_RC2_CBC_40_MD5", true, 2, "RSA", "RC2_CBC_40", "MD5", CODE_SSL_RSA_EXPORT_WITH_RC2_CBC_40_MD5);
    static final CipherSuite SSL_RSA_EXPORT_WITH_DES40_CBC_SHA = new CipherSuite("SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", true, 2, "RSA", "DES40_CBC", "SHA", CODE_SSL_RSA_EXPORT_WITH_DES40_CBC_SHA);
    static final CipherSuite SSL_RSA_WITH_DES_CBC_SHA = new CipherSuite("SSL_RSA_WITH_DES_CBC_SHA", false, 1, "RSA", "DES_CBC", "SHA", CODE_SSL_RSA_WITH_DES_CBC_SHA);
    static final CipherSuite SSL_RSA_WITH_3DES_EDE_CBC_SHA = new CipherSuite("SSL_RSA_WITH_3DES_EDE_CBC_SHA", false, 1, "RSA", "3DES_EDE_CBC", "SHA", CODE_SSL_RSA_WITH_3DES_EDE_CBC_SHA);
    static final CipherSuite SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA = new CipherSuite("SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA", true, 4, "DSA", "DES40_CBC", "SHA", CODE_SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA);
    static final CipherSuite SSL_DHE_DSS_WITH_DES_CBC_SHA = new CipherSuite("SSL_DHE_DSS_WITH_DES_CBC_SHA", false, 3, "DSA", "DES_CBC", "SHA", CODE_SSL_DHE_DSS_WITH_DES_CBC_SHA);
    static final CipherSuite SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA = new CipherSuite("SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA", false, 3, "DSA", "3DES_EDE_CBC", "SHA", CODE_SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA);
    static final CipherSuite SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA = new CipherSuite("SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", true, 6, "RSA", "DES40_CBC", "SHA", CODE_SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA);
    static final CipherSuite SSL_DHE_RSA_WITH_DES_CBC_SHA = new CipherSuite("SSL_DHE_RSA_WITH_DES_CBC_SHA", false, 5, "RSA", "DES_CBC", "SHA", CODE_SSL_DHE_RSA_WITH_DES_CBC_SHA);
    static final CipherSuite SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA = new CipherSuite("SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", false, 5, "RSA", "3DES_EDE_CBC", "SHA", CODE_SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA);
    static final CipherSuite SSL_DH_anon_EXPORT_WITH_RC4_40_MD5 = new CipherSuite("SSL_DH_anon_EXPORT_WITH_RC4_40_MD5", true, 10, "DH", "RC4_40", "MD5", CODE_SSL_DH_anon_EXPORT_WITH_RC4_40_MD5);
    static final CipherSuite SSL_DH_anon_WITH_RC4_128_MD5 = new CipherSuite("SSL_DH_anon_WITH_RC4_128_MD5", false, 9, "DH", "RC4_128", "MD5", CODE_SSL_DH_anon_WITH_RC4_128_MD5);
    static final CipherSuite SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA = new CipherSuite("SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA", true, 10, "DH", "DES40_CBC", "SHA", CODE_SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA);
    static final CipherSuite SSL_DH_anon_WITH_DES_CBC_SHA = new CipherSuite("SSL_DH_anon_WITH_DES_CBC_SHA", false, 9, "DH", "DES_CBC", "SHA", CODE_SSL_DH_anon_WITH_DES_CBC_SHA);
    static final CipherSuite SSL_DH_anon_WITH_3DES_EDE_CBC_SHA = new CipherSuite("SSL_DH_anon_WITH_3DES_EDE_CBC_SHA", false, 9, "DH", "3DES_EDE_CBC", "SHA", CODE_SSL_DH_anon_WITH_3DES_EDE_CBC_SHA);
    static final CipherSuite TLS_RSA_WITH_AES_128_CBC_SHA = new CipherSuite("TLS_RSA_WITH_AES_128_CBC_SHA", false, 1, "RSA", "AES_128_CBC", "SHA", CODE_TLS_RSA_WITH_AES_128_CBC_SHA);
    static final CipherSuite TLS_DHE_DSS_WITH_AES_128_CBC_SHA = new CipherSuite("TLS_DHE_DSS_WITH_AES_128_CBC_SHA", false, 3, "DSA", "AES_128_CBC", "SHA", CODE_TLS_DHE_DSS_WITH_AES_128_CBC_SHA);
    static final CipherSuite TLS_DHE_RSA_WITH_AES_128_CBC_SHA = new CipherSuite("TLS_DHE_RSA_WITH_AES_128_CBC_SHA", false, 5, "RSA", "AES_128_CBC", "SHA", CODE_TLS_DHE_RSA_WITH_AES_128_CBC_SHA);
    static final CipherSuite TLS_DH_anon_WITH_AES_128_CBC_SHA = new CipherSuite("TLS_DH_anon_WITH_AES_128_CBC_SHA", false, 9, "DH", "AES_128_CBC", "SHA", CODE_TLS_DH_anon_WITH_AES_128_CBC_SHA);
    static final CipherSuite TLS_RSA_WITH_AES_256_CBC_SHA = new CipherSuite("TLS_RSA_WITH_AES_256_CBC_SHA", false, 1, "RSA", "AES_256_CBC", "SHA", CODE_TLS_RSA_WITH_AES_256_CBC_SHA);
    static final CipherSuite TLS_DHE_DSS_WITH_AES_256_CBC_SHA = new CipherSuite("TLS_DHE_DSS_WITH_AES_256_CBC_SHA", false, 3, "DSA", "AES_256_CBC", "SHA", CODE_TLS_DHE_DSS_WITH_AES_256_CBC_SHA);
    static final CipherSuite TLS_DHE_RSA_WITH_AES_256_CBC_SHA = new CipherSuite("TLS_DHE_RSA_WITH_AES_256_CBC_SHA", false, 5, "RSA", "AES_256_CBC", "SHA", CODE_TLS_DHE_RSA_WITH_AES_256_CBC_SHA);
    static final CipherSuite TLS_DH_anon_WITH_AES_256_CBC_SHA = new CipherSuite("TLS_DH_anon_WITH_AES_256_CBC_SHA", false, 9, "DH", "AES_256_CBC", "SHA", CODE_TLS_DH_anon_WITH_AES_256_CBC_SHA);
    static final CipherSuite TLS_ECDH_ECDSA_WITH_NULL_SHA = new CipherSuite("TLS_ECDH_ECDSA_WITH_NULL_SHA", false, 13, "EC", null, "SHA", CODE_TLS_ECDH_ECDSA_WITH_NULL_SHA);
    static final CipherSuite TLS_ECDH_ECDSA_WITH_RC4_128_SHA = new CipherSuite("TLS_ECDH_ECDSA_WITH_RC4_128_SHA", false, 13, "EC", "RC4_128", "SHA", CODE_TLS_ECDH_ECDSA_WITH_RC4_128_SHA);
    static final CipherSuite TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA = new CipherSuite("TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA", false, 13, "EC", "3DES_EDE_CBC", "SHA", CODE_TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA);
    static final CipherSuite TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA = new CipherSuite("TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA", false, 13, "EC", "AES_128_CBC", "SHA", CODE_TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA);
    static final CipherSuite TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA = new CipherSuite("TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA", false, 13, "EC", "AES_256_CBC", "SHA", CODE_TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA);
    static final CipherSuite TLS_ECDHE_ECDSA_WITH_NULL_SHA = new CipherSuite("TLS_ECDHE_ECDSA_WITH_NULL_SHA", false, 14, "EC", null, "SHA", CODE_TLS_ECDHE_ECDSA_WITH_NULL_SHA);
    static final CipherSuite TLS_ECDHE_ECDSA_WITH_RC4_128_SHA = new CipherSuite("TLS_ECDHE_ECDSA_WITH_RC4_128_SHA", false, 14, "EC", "RC4_128", "SHA", CODE_TLS_ECDHE_ECDSA_WITH_RC4_128_SHA);
    static final CipherSuite TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA = new CipherSuite("TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA", false, 14, "EC", "3DES_EDE_CBC", "SHA", CODE_TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA);
    static final CipherSuite TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA = new CipherSuite("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", false, 14, "EC", "AES_128_CBC", "SHA", CODE_TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA);
    static final CipherSuite TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA = new CipherSuite("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", false, 14, "EC", "AES_256_CBC", "SHA", CODE_TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA);
    static final CipherSuite TLS_ECDH_RSA_WITH_NULL_SHA = new CipherSuite("TLS_ECDH_RSA_WITH_NULL_SHA", false, 15, "EC", null, "SHA", CODE_TLS_ECDH_RSA_WITH_NULL_SHA);
    static final CipherSuite TLS_ECDH_RSA_WITH_RC4_128_SHA = new CipherSuite("TLS_ECDH_RSA_WITH_RC4_128_SHA", false, 15, "EC", "RC4_128", "SHA", CODE_TLS_ECDH_RSA_WITH_RC4_128_SHA);
    static final CipherSuite TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA = new CipherSuite("TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA", false, 15, "EC", "3DES_EDE_CBC", "SHA", CODE_TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA);
    static final CipherSuite TLS_ECDH_RSA_WITH_AES_128_CBC_SHA = new CipherSuite("TLS_ECDH_RSA_WITH_AES_128_CBC_SHA", false, 15, "EC", "AES_128_CBC", "SHA", CODE_TLS_ECDH_RSA_WITH_AES_128_CBC_SHA);
    static final CipherSuite TLS_ECDH_RSA_WITH_AES_256_CBC_SHA = new CipherSuite("TLS_ECDH_RSA_WITH_AES_256_CBC_SHA", false, 15, "EC", "AES_256_CBC", "SHA", CODE_TLS_ECDH_RSA_WITH_AES_256_CBC_SHA);
    static final CipherSuite TLS_ECDHE_RSA_WITH_NULL_SHA = new CipherSuite("TLS_ECDHE_RSA_WITH_NULL_SHA", false, 16, "EC", null, "SHA", CODE_TLS_ECDHE_RSA_WITH_NULL_SHA);
    static final CipherSuite TLS_ECDHE_RSA_WITH_RC4_128_SHA = new CipherSuite("TLS_ECDHE_RSA_WITH_RC4_128_SHA", false, 16, "EC", "RC4_128", "SHA", CODE_TLS_ECDHE_RSA_WITH_RC4_128_SHA);
    static final CipherSuite TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA = new CipherSuite("TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA", false, 16, "EC", "3DES_EDE_CBC", "SHA", CODE_TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA);
    static final CipherSuite TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA = new CipherSuite("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", false, 16, "EC", "AES_128_CBC", "SHA", CODE_TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA);
    static final CipherSuite TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA = new CipherSuite("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", false, 16, "EC", "AES_256_CBC", "SHA", CODE_TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA);
    static final CipherSuite TLS_ECDH_anon_WITH_NULL_SHA = new CipherSuite("TLS_ECDH_anon_WITH_NULL_SHA", false, 17, "EC", null, "SHA", CODE_TLS_ECDH_anon_WITH_NULL_SHA);
    static final CipherSuite TLS_ECDH_anon_WITH_RC4_128_SHA = new CipherSuite("TLS_ECDH_anon_WITH_RC4_128_SHA", false, 17, "EC", "RC4_128", "SHA", CODE_TLS_ECDH_anon_WITH_RC4_128_SHA);
    static final CipherSuite TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA = new CipherSuite("TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA", false, 17, "EC", "3DES_EDE_CBC", "SHA", CODE_TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA);
    static final CipherSuite TLS_ECDH_anon_WITH_AES_128_CBC_SHA = new CipherSuite("TLS_ECDH_anon_WITH_AES_128_CBC_SHA", false, 17, "EC", "AES_128_CBC", "SHA", CODE_TLS_ECDH_anon_WITH_AES_128_CBC_SHA);
    static final CipherSuite TLS_ECDH_anon_WITH_AES_256_CBC_SHA = new CipherSuite("TLS_ECDH_anon_WITH_AES_256_CBC_SHA", false, 17, "EC", "AES_256_CBC", "SHA", CODE_TLS_ECDH_anon_WITH_AES_256_CBC_SHA);
    private static final CipherSuite[] SUITES_BY_CODE_0x00 = new CipherSuite[]{SSL_NULL_WITH_NULL_NULL, SSL_RSA_WITH_NULL_MD5, SSL_RSA_WITH_NULL_SHA, SSL_RSA_EXPORT_WITH_RC4_40_MD5, SSL_RSA_WITH_RC4_128_MD5, SSL_RSA_WITH_RC4_128_SHA, null, null, SSL_RSA_EXPORT_WITH_DES40_CBC_SHA, SSL_RSA_WITH_DES_CBC_SHA, SSL_RSA_WITH_3DES_EDE_CBC_SHA, null, null, null, null, null, null, SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA, SSL_DHE_DSS_WITH_DES_CBC_SHA, SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA, SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA, SSL_DHE_RSA_WITH_DES_CBC_SHA, SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA, SSL_DH_anon_EXPORT_WITH_RC4_40_MD5, SSL_DH_anon_WITH_RC4_128_MD5, SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA, SSL_DH_anon_WITH_DES_CBC_SHA, SSL_DH_anon_WITH_3DES_EDE_CBC_SHA, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, TLS_RSA_WITH_AES_128_CBC_SHA, null, null, TLS_DHE_DSS_WITH_AES_128_CBC_SHA, TLS_DHE_RSA_WITH_AES_128_CBC_SHA, TLS_DH_anon_WITH_AES_128_CBC_SHA, TLS_RSA_WITH_AES_256_CBC_SHA, null, null, TLS_DHE_DSS_WITH_AES_256_CBC_SHA, TLS_DHE_RSA_WITH_AES_256_CBC_SHA, TLS_DH_anon_WITH_AES_256_CBC_SHA};
    private static final CipherSuite[] SUITES_BY_CODE_0xc0 = new CipherSuite[]{null, TLS_ECDH_ECDSA_WITH_NULL_SHA, TLS_ECDH_ECDSA_WITH_RC4_128_SHA, TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA, TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA, TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_ECDSA_WITH_NULL_SHA, TLS_ECDHE_ECDSA_WITH_RC4_128_SHA, TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA, TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA, TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA, TLS_ECDH_RSA_WITH_NULL_SHA, TLS_ECDH_RSA_WITH_RC4_128_SHA, TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA, TLS_ECDH_RSA_WITH_AES_128_CBC_SHA, TLS_ECDH_RSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_RSA_WITH_NULL_SHA, TLS_ECDHE_RSA_WITH_RC4_128_SHA, TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA, TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA, TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA, TLS_ECDH_anon_WITH_NULL_SHA, TLS_ECDH_anon_WITH_RC4_128_SHA, TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA, TLS_ECDH_anon_WITH_AES_128_CBC_SHA, TLS_ECDH_anon_WITH_AES_256_CBC_SHA};
    private static final Hashtable<String, CipherSuite> SUITES_BY_NAME = new Hashtable();
    static final CipherSuite[] SUPPORTED_CIPHER_SUITES;
    static final String[] SUPPORTED_CIPHER_SUITE_NAMES;
    static final CipherSuite[] DEFAULT_CIPHER_SUITES;
    static final String KEY_TYPE_RSA = "RSA";
    static final String KEY_TYPE_DSA = "DSA";
    static final String KEY_TYPE_DH_RSA = "DH_RSA";
    static final String KEY_TYPE_DH_DSA = "DH_DSA";
    static final String KEY_TYPE_EC = "EC";
    static final String KEY_TYPE_EC_EC = "EC_EC";
    static final String KEY_TYPE_EC_RSA = "EC_RSA";
    static final byte TLS_CT_RSA_SIGN = 1;
    static final byte TLS_CT_DSS_SIGN = 2;
    static final byte TLS_CT_RSA_FIXED_DH = 3;
    static final byte TLS_CT_DSS_FIXED_DH = 4;
    static final byte TLS_CT_ECDSA_SIGN = 64;
    static final byte TLS_CT_RSA_FIXED_ECDH = 65;
    static final byte TLS_CT_ECDSA_FIXED_ECDH = 66;
    private static final String AUTH_TYPE_RSA = "RSA";
    private static final String AUTH_TYPE_RSA_EXPORT = "RSA_EXPORT";
    private static final String AUTH_TYPE_DHE_DSS = "DHE_DSS";
    private static final String AUTH_TYPE_DHE_RSA = "DHE_RSA";
    private static final String AUTH_TYPE_DH_DSS = "DH_DSS";
    private static final String AUTH_TYPE_DH_RSA = "DH_RSA";
    private static final String AUTH_TYPE_ECDH_ECDSA = "ECDH_ECDSA";
    private static final String AUTH_TYPE_ECDH_RSA = "ECDH_RSA";
    private static final String AUTH_TYPE_ECDHE_ECDSA = "ECDHE_ECDSA";
    private static final String AUTH_TYPE_ECDHE_RSA = "ECDHE_RSA";

    private static int registerCipherSuitesByCode(CipherSuite[] cipherSuites) {
        int count = 0;
        for (int i = 0; i < cipherSuites.length; ++i) {
            if (cipherSuites[i] == SSL_NULL_WITH_NULL_NULL || cipherSuites[i] == null) continue;
            SUITES_BY_NAME.put(cipherSuites[i].getName(), cipherSuites[i]);
            if (!cipherSuites[i].supported) continue;
            ++count;
        }
        return count;
    }

    private static void registerSupportedCipherSuites(int offset, CipherSuite[] cipherSuites) {
        int count = offset;
        for (int i = 0; i < cipherSuites.length; ++i) {
            if (cipherSuites[i] == SSL_NULL_WITH_NULL_NULL || cipherSuites[i] == null || !cipherSuites[i].supported) continue;
            CipherSuite.SUPPORTED_CIPHER_SUITES[count] = cipherSuites[i];
            CipherSuite.SUPPORTED_CIPHER_SUITE_NAMES[count] = SUPPORTED_CIPHER_SUITES[count].getName();
            ++count;
        }
    }

    public static CipherSuite getByName(String name) {
        return SUITES_BY_NAME.get(name);
    }

    public static CipherSuite getByCode(byte b1, byte b2) {
        int i1 = b1 & 0xFF;
        int i2 = b2 & 0xFF;
        CipherSuite cs = CipherSuite.getCipherSuiteByCode(0, i1, i2);
        if (cs != null) {
            return cs;
        }
        return new CipherSuite("UNKNOWN_" + i1 + "_" + i2, false, 0, null, null, null, new byte[]{b1, b2});
    }

    public static CipherSuite getByCode(byte b1, byte b2, byte b3) {
        int i1 = b1 & 0xFF;
        int i2 = b2 & 0xFF;
        int i3 = b3 & 0xFF;
        CipherSuite cs = CipherSuite.getCipherSuiteByCode(i1, i2, i3);
        if (cs != null) {
            return cs;
        }
        return new CipherSuite("UNKNOWN_" + i1 + "_" + i2 + "_" + i3, false, 0, null, null, null, new byte[]{b1, b2, b3});
    }

    private static CipherSuite getCipherSuiteByCode(int i1, int i2, int i3) {
        CipherSuite[] cipherSuites;
        if (i1 == 0 && i2 == 0) {
            cipherSuites = SUITES_BY_CODE_0x00;
        } else if (i1 == 0 && i2 == 192) {
            cipherSuites = SUITES_BY_CODE_0xc0;
        } else {
            return null;
        }
        if (i3 >= cipherSuites.length) {
            return null;
        }
        return cipherSuites[i3];
    }

    private CipherSuite(String name, boolean isExportable, int keyExchange, String authType, String cipherName, String hash, byte[] code) {
        this.name = name;
        this.keyExchange = keyExchange;
        this.authType = authType;
        this.isExportable = isExportable;
        if (cipherName == null) {
            this.cipherName = null;
            this.keyMaterial = 0;
            this.expandedKeyMaterial = 0;
            this.effectiveKeyBytes = 0;
            this.ivSize = 0;
            this.blockSize = 0;
            this.needInitialRecordSplit = false;
        } else if ("RC4_40".equals(cipherName)) {
            this.cipherName = "RC4";
            this.keyMaterial = 5;
            this.expandedKeyMaterial = 16;
            this.effectiveKeyBytes = 5;
            this.ivSize = 0;
            this.blockSize = 0;
            this.needInitialRecordSplit = false;
        } else if ("RC4_128".equals(cipherName)) {
            this.cipherName = "RC4";
            this.keyMaterial = 16;
            this.expandedKeyMaterial = 16;
            this.effectiveKeyBytes = 16;
            this.ivSize = 0;
            this.blockSize = 0;
            this.needInitialRecordSplit = false;
        } else if ("DES40_CBC".equals(cipherName)) {
            this.cipherName = "DES/CBC/NoPadding";
            this.keyMaterial = 5;
            this.expandedKeyMaterial = 8;
            this.effectiveKeyBytes = 5;
            this.ivSize = 8;
            this.blockSize = 8;
            this.needInitialRecordSplit = true;
        } else if ("DES_CBC".equals(cipherName)) {
            this.cipherName = "DES/CBC/NoPadding";
            this.keyMaterial = 8;
            this.expandedKeyMaterial = 8;
            this.effectiveKeyBytes = 7;
            this.ivSize = 8;
            this.blockSize = 8;
            this.needInitialRecordSplit = true;
        } else if ("3DES_EDE_CBC".equals(cipherName)) {
            this.cipherName = "DESede/CBC/NoPadding";
            this.keyMaterial = 24;
            this.expandedKeyMaterial = 24;
            this.effectiveKeyBytes = 24;
            this.ivSize = 8;
            this.blockSize = 8;
            this.needInitialRecordSplit = true;
        } else if ("AES_128_CBC".equals(cipherName)) {
            this.cipherName = "AES/CBC/NoPadding";
            this.keyMaterial = 16;
            this.expandedKeyMaterial = 16;
            this.effectiveKeyBytes = 16;
            this.ivSize = 16;
            this.blockSize = 16;
            this.needInitialRecordSplit = true;
        } else if ("AES_256_CBC".equals(cipherName)) {
            this.cipherName = "AES/CBC/NoPadding";
            this.keyMaterial = 32;
            this.expandedKeyMaterial = 32;
            this.effectiveKeyBytes = 32;
            this.ivSize = 16;
            this.blockSize = 16;
            this.needInitialRecordSplit = true;
        } else {
            this.cipherName = cipherName;
            this.keyMaterial = 0;
            this.expandedKeyMaterial = 0;
            this.effectiveKeyBytes = 0;
            this.ivSize = 0;
            this.blockSize = 0;
            this.needInitialRecordSplit = false;
        }
        if ("MD5".equals(hash)) {
            this.hmacName = "HmacMD5";
            this.hashName = "MD5";
            this.hashSize = 16;
        } else if ("SHA".equals(hash)) {
            this.hmacName = "HmacSHA1";
            this.hashName = "SHA-1";
            this.hashSize = 20;
        } else {
            this.hmacName = null;
            this.hashName = null;
            this.hashSize = 0;
        }
        this.cipherSuiteCode = code;
        if (this.cipherName != null) {
            try {
                Cipher.getInstance(this.cipherName);
            }
            catch (GeneralSecurityException e) {
                this.supported = false;
            }
        }
        if (this.name.startsWith("TLS_EC")) {
            this.supported = false;
        }
    }

    public boolean isAnonymous() {
        return this.keyExchange == 9 || this.keyExchange == 10 || this.keyExchange == 17;
    }

    public static CipherSuite[] getSupported() {
        return SUPPORTED_CIPHER_SUITES;
    }

    public static String[] getSupportedCipherSuiteNames() {
        return (String[])SUPPORTED_CIPHER_SUITE_NAMES.clone();
    }

    public String getName() {
        return this.name;
    }

    public byte[] toBytes() {
        return this.cipherSuiteCode;
    }

    public String toString() {
        return this.name + ": " + this.cipherSuiteCode[0] + " " + this.cipherSuiteCode[1];
    }

    public String getBulkEncryptionAlgorithm() {
        return this.cipherName;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public String getHmacName() {
        return this.hmacName;
    }

    public String getHashName() {
        return this.hashName;
    }

    public int getMACLength() {
        return this.hashSize;
    }

    public boolean isExportable() {
        return this.isExportable;
    }

    public boolean isInitialRecordSplit() {
        return this.needInitialRecordSplit;
    }

    public String getServerKeyType() {
        switch (this.keyExchange) {
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 16: {
                return "RSA";
            }
            case 3: 
            case 4: {
                return KEY_TYPE_DSA;
            }
            case 13: 
            case 14: {
                return KEY_TYPE_EC_EC;
            }
            case 15: {
                return KEY_TYPE_EC_RSA;
            }
            case 9: 
            case 10: 
            case 17: {
                return null;
            }
        }
        throw new IllegalStateException("Unknown key type for key exchange " + this.keyExchange);
    }

    public static String getClientKeyType(byte keyType) {
        switch (keyType) {
            case 1: {
                return "RSA";
            }
            case 2: {
                return KEY_TYPE_DSA;
            }
            case 3: {
                return "DH_RSA";
            }
            case 4: {
                return KEY_TYPE_DH_DSA;
            }
            case 64: {
                return KEY_TYPE_EC;
            }
            case 65: {
                return KEY_TYPE_EC_RSA;
            }
            case 66: {
                return KEY_TYPE_EC_EC;
            }
        }
        return null;
    }

    public String getAuthType(boolean emphemeral) {
        switch (this.keyExchange) {
            case 1: {
                return "RSA";
            }
            case 2: {
                return emphemeral ? AUTH_TYPE_RSA_EXPORT : "RSA";
            }
            case 3: 
            case 4: {
                return AUTH_TYPE_DHE_DSS;
            }
            case 5: 
            case 6: {
                return AUTH_TYPE_DHE_RSA;
            }
            case 13: {
                return AUTH_TYPE_ECDH_ECDSA;
            }
            case 14: {
                return AUTH_TYPE_ECDHE_ECDSA;
            }
            case 15: {
                return AUTH_TYPE_ECDH_RSA;
            }
            case 16: {
                return AUTH_TYPE_ECDHE_RSA;
            }
            case 9: 
            case 10: 
            case 17: {
                return null;
            }
        }
        throw new IllegalStateException("Unknown auth type for key exchange " + this.keyExchange);
    }

    static {
        int count_0x00 = CipherSuite.registerCipherSuitesByCode(SUITES_BY_CODE_0x00);
        int count_0xc0 = CipherSuite.registerCipherSuitesByCode(SUITES_BY_CODE_0xc0);
        int count = count_0x00 + count_0xc0;
        SUPPORTED_CIPHER_SUITES = new CipherSuite[count];
        SUPPORTED_CIPHER_SUITE_NAMES = new String[count];
        CipherSuite.registerSupportedCipherSuites(0, SUITES_BY_CODE_0x00);
        CipherSuite.registerSupportedCipherSuites(count_0x00, SUITES_BY_CODE_0xc0);
        ArrayList<CipherSuite> defaultCipherSuitesList = new ArrayList<CipherSuite>();
        for (String cipherSuiteName : NativeCrypto.getDefaultCipherSuites()) {
            CipherSuite cipherSuite = CipherSuite.getByName(cipherSuiteName);
            if (cipherSuite == null || !cipherSuite.supported) continue;
            defaultCipherSuitesList.add(cipherSuite);
        }
        DEFAULT_CIPHER_SUITES = defaultCipherSuitesList.toArray(new CipherSuite[defaultCipherSuitesList.size()]);
    }
}

