/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.SecretKey;
import org.conscrypt.NativeCrypto;
import org.conscrypt.OpenSSLDSAPrivateKey;
import org.conscrypt.OpenSSLDSAPublicKey;
import org.conscrypt.OpenSSLECPrivateKey;
import org.conscrypt.OpenSSLECPublicKey;
import org.conscrypt.OpenSSLEngine;
import org.conscrypt.OpenSSLKeyHolder;
import org.conscrypt.OpenSSLRSAPrivateKey;
import org.conscrypt.OpenSSLRSAPublicKey;
import org.conscrypt.OpenSSLSecretKey;

public class OpenSSLKey {
    private final long ctx;
    private final OpenSSLEngine engine;
    private final String alias;

    public OpenSSLKey(long ctx) {
        this.ctx = ctx;
        this.engine = null;
        this.alias = null;
    }

    public OpenSSLKey(long ctx, OpenSSLEngine engine, String alias) {
        this.ctx = ctx;
        this.engine = engine;
        this.alias = alias;
    }

    public long getPkeyContext() {
        return this.ctx;
    }

    OpenSSLEngine getEngine() {
        return this.engine;
    }

    boolean isEngineBased() {
        return this.engine != null;
    }

    public String getAlias() {
        return this.alias;
    }

    public static OpenSSLKey fromPrivateKey(PrivateKey key) throws InvalidKeyException {
        if (key instanceof OpenSSLKeyHolder) {
            return ((OpenSSLKeyHolder)((Object)key)).getOpenSSLKey();
        }
        if (!"PKCS#8".equals(key.getFormat())) {
            throw new InvalidKeyException("Unknown key format " + key.getFormat());
        }
        byte[] encoded = key.getEncoded();
        if (encoded == null) {
            throw new InvalidKeyException("Key encoding is null");
        }
        return new OpenSSLKey(NativeCrypto.d2i_PKCS8_PRIV_KEY_INFO(key.getEncoded()));
    }

    public PublicKey getPublicKey() throws NoSuchAlgorithmException {
        switch (NativeCrypto.EVP_PKEY_type(this.ctx)) {
            case 6: {
                return new OpenSSLRSAPublicKey(this);
            }
            case 116: {
                return new OpenSSLDSAPublicKey(this);
            }
            case 408: {
                return new OpenSSLECPublicKey(this);
            }
        }
        throw new NoSuchAlgorithmException("unknown PKEY type");
    }

    static PublicKey getPublicKey(X509EncodedKeySpec keySpec, int type) throws InvalidKeySpecException {
        OpenSSLKey key;
        X509EncodedKeySpec x509KeySpec = keySpec;
        try {
            key = new OpenSSLKey(NativeCrypto.d2i_PUBKEY(x509KeySpec.getEncoded()));
        }
        catch (Exception e) {
            throw new InvalidKeySpecException(e);
        }
        if (NativeCrypto.EVP_PKEY_type(key.getPkeyContext()) != type) {
            throw new InvalidKeySpecException("Unexpected key type");
        }
        try {
            return key.getPublicKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidKeySpecException(e);
        }
    }

    public PrivateKey getPrivateKey() throws NoSuchAlgorithmException {
        switch (NativeCrypto.EVP_PKEY_type(this.ctx)) {
            case 6: {
                return new OpenSSLRSAPrivateKey(this);
            }
            case 116: {
                return new OpenSSLDSAPrivateKey(this);
            }
            case 408: {
                return new OpenSSLECPrivateKey(this);
            }
        }
        throw new NoSuchAlgorithmException("unknown PKEY type");
    }

    static PrivateKey getPrivateKey(PKCS8EncodedKeySpec keySpec, int type) throws InvalidKeySpecException {
        OpenSSLKey key;
        PKCS8EncodedKeySpec pkcs8KeySpec = keySpec;
        try {
            key = new OpenSSLKey(NativeCrypto.d2i_PKCS8_PRIV_KEY_INFO(pkcs8KeySpec.getEncoded()));
        }
        catch (Exception e) {
            throw new InvalidKeySpecException(e);
        }
        if (NativeCrypto.EVP_PKEY_type(key.getPkeyContext()) != type) {
            throw new InvalidKeySpecException("Unexpected key type");
        }
        try {
            return key.getPrivateKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidKeySpecException(e);
        }
    }

    public SecretKey getSecretKey(String algorithm) throws NoSuchAlgorithmException {
        switch (NativeCrypto.EVP_PKEY_type(this.ctx)) {
            case 855: 
            case 894: {
                return new OpenSSLSecretKey(algorithm, this);
            }
        }
        throw new NoSuchAlgorithmException("unknown PKEY type");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.ctx != 0L) {
                NativeCrypto.EVP_PKEY_free(this.ctx);
            }
        }
        finally {
            super.finalize();
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenSSLKey)) {
            return false;
        }
        OpenSSLKey other = (OpenSSLKey)o;
        if (this.ctx == other.getPkeyContext()) {
            return true;
        }
        if (this.engine == null) {
            if (other.getEngine() != null) {
                return false;
            }
        } else {
            if (!this.engine.equals(other.getEngine())) {
                return false;
            }
            if (this.alias != null) {
                return this.alias.equals(other.getAlias());
            }
            if (other.getAlias() != null) {
                return false;
            }
        }
        return NativeCrypto.EVP_PKEY_cmp(this.ctx, other.getPkeyContext()) == 1;
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 17 + (int)this.ctx;
        hash = hash * 31 + (int)(this.engine == null ? 0L : this.engine.getEngineContext());
        return hash;
    }
}

