/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;
import org.conscrypt.DigitalSignature;
import org.conscrypt.HandshakeIODataStream;
import org.conscrypt.Message;

public class ServerKeyExchange
extends Message {
    final BigInteger par1;
    final byte[] bytes1;
    final BigInteger par2;
    final byte[] bytes2;
    final BigInteger par3;
    final byte[] bytes3;
    final byte[] hash;
    private RSAPublicKey key;

    public ServerKeyExchange(BigInteger par1, BigInteger par2, BigInteger par3, byte[] hash) {
        this.par1 = par1;
        this.par2 = par2;
        this.par3 = par3;
        this.hash = hash;
        this.bytes1 = ServerKeyExchange.toUnsignedByteArray(this.par1);
        this.bytes2 = ServerKeyExchange.toUnsignedByteArray(this.par2);
        this.length = 4 + this.bytes1.length + this.bytes2.length;
        if (hash != null) {
            this.length += 2 + hash.length;
        }
        if (par3 == null) {
            this.bytes3 = null;
            return;
        }
        this.bytes3 = ServerKeyExchange.toUnsignedByteArray(this.par3);
        this.length += 2 + this.bytes3.length;
    }

    public static byte[] toUnsignedByteArray(BigInteger bi) {
        if (bi == null) {
            return null;
        }
        byte[] bb = bi.toByteArray();
        if (bb[0] == 0) {
            byte[] noZero = new byte[bb.length - 1];
            System.arraycopy(bb, 1, noZero, 0, noZero.length);
            return noZero;
        }
        return bb;
    }

    public static void updateSignatureRsa(DigitalSignature ds, BigInteger modulus, BigInteger publicExponent) {
        byte[] tmpLength = new byte[2];
        byte[] tmp = ServerKeyExchange.toUnsignedByteArray(modulus);
        tmpLength[0] = (byte)((tmp.length & 0xFF00) >>> 8);
        tmpLength[1] = (byte)(tmp.length & 0xFF);
        ds.update(tmpLength);
        ds.update(tmp);
        tmp = ServerKeyExchange.toUnsignedByteArray(publicExponent);
        tmpLength[0] = (byte)((tmp.length & 0xFF00) >>> 8);
        tmpLength[1] = (byte)(tmp.length & 0xFF);
        ds.update(tmpLength);
        ds.update(tmp);
    }

    public static void updateSignatureDh(DigitalSignature ds, BigInteger p, BigInteger g, BigInteger y) {
        byte[] tmpLength = new byte[2];
        byte[] tmp = ServerKeyExchange.toUnsignedByteArray(p);
        tmpLength[0] = (byte)((tmp.length & 0xFF00) >>> 8);
        tmpLength[1] = (byte)(tmp.length & 0xFF);
        ds.update(tmpLength);
        ds.update(tmp);
        tmp = ServerKeyExchange.toUnsignedByteArray(g);
        tmpLength[0] = (byte)((tmp.length & 0xFF00) >>> 8);
        tmpLength[1] = (byte)(tmp.length & 0xFF);
        ds.update(tmpLength);
        ds.update(tmp);
        tmp = ServerKeyExchange.toUnsignedByteArray(y);
        tmpLength[0] = (byte)((tmp.length & 0xFF00) >>> 8);
        tmpLength[1] = (byte)(tmp.length & 0xFF);
        ds.update(tmpLength);
        ds.update(tmp);
    }

    public boolean verifySignature(DigitalSignature ds) {
        if (this.par3 != null) {
            ServerKeyExchange.updateSignatureDh(ds, this.par1, this.par2, this.par3);
        } else {
            ServerKeyExchange.updateSignatureRsa(ds, this.par1, this.par2);
        }
        return ds.verifySignature(this.hash);
    }

    public boolean isAnonymous() {
        return this.hash == null;
    }

    public ServerKeyExchange(HandshakeIODataStream in, int length, int keyExchange) throws IOException {
        int size = in.readUint16();
        this.bytes1 = in.read(size);
        this.par1 = new BigInteger(1, this.bytes1);
        this.length = 2 + this.bytes1.length;
        size = in.readUint16();
        this.bytes2 = in.read(size);
        this.par2 = new BigInteger(1, this.bytes2);
        this.length += 2 + this.bytes2.length;
        if (keyExchange != 2) {
            size = in.readUint16();
            this.bytes3 = in.read(size);
            this.par3 = new BigInteger(1, this.bytes3);
            this.length += 2 + this.bytes3.length;
        } else {
            this.par3 = null;
            this.bytes3 = null;
        }
        if (keyExchange != 10 && keyExchange != 9) {
            size = in.readUint16();
            this.hash = in.read(size);
            this.length += 2 + this.hash.length;
        } else {
            this.hash = null;
        }
        if (this.length != length) {
            this.fatalAlert((byte)50, "DECODE ERROR: incorrect ServerKeyExchange");
        }
    }

    public void send(HandshakeIODataStream out) {
        out.writeUint16(this.bytes1.length);
        out.write(this.bytes1);
        out.writeUint16(this.bytes2.length);
        out.write(this.bytes2);
        if (this.bytes3 != null) {
            out.writeUint16(this.bytes3.length);
            out.write(this.bytes3);
        }
        if (this.hash != null) {
            out.writeUint16(this.hash.length);
            out.write(this.hash);
        }
    }

    public RSAPublicKey getRSAPublicKey() {
        if (this.key != null) {
            return this.key;
        }
        try {
            KeyFactory kf = KeyFactory.getInstance("RSA");
            this.key = (RSAPublicKey)kf.generatePublic(new RSAPublicKeySpec(this.par1, this.par2));
        }
        catch (Exception e) {
            return null;
        }
        return this.key;
    }

    public int getType() {
        return 12;
    }
}

