/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.guava.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.google.common.base.Optional;
import java.io.IOException;

public final class GuavaOptionalDeserializer
extends StdDeserializer<Optional<?>> {
    private final JavaType _referenceType;

    public GuavaOptionalDeserializer(JavaType valueType) {
        super(valueType);
        this._referenceType = valueType.containedType(0);
    }

    @Override
    public Optional<?> getNullValue() {
        return Optional.absent();
    }

    @Override
    public Optional<?> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Object reference = ctxt.findRootValueDeserializer(this._referenceType).deserialize(jp, ctxt);
        return Optional.of((Object)reference);
    }
}

