/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.guava.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public class MultimapDeserializer
extends JsonDeserializer<Multimap<?, ?>>
implements ContextualDeserializer {
    private static final List<String> METHOD_NAMES = ImmutableList.of((Object)"copyOf", (Object)"create");
    private final MapLikeType type;
    private final KeyDeserializer keyDeserializer;
    private final TypeDeserializer elementTypeDeserializer;
    private final JsonDeserializer<?> elementDeserializer;
    private final Method creatorMethod;

    public MultimapDeserializer(MapLikeType type, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) {
        this(type, keyDeserializer, elementTypeDeserializer, elementDeserializer, MultimapDeserializer.findTransformer(type.getRawClass()));
    }

    public MultimapDeserializer(MapLikeType type, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer, Method creatorMethod) {
        this.type = type;
        this.keyDeserializer = keyDeserializer;
        this.elementTypeDeserializer = elementTypeDeserializer;
        this.elementDeserializer = elementDeserializer;
        this.creatorMethod = creatorMethod;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        TypeDeserializer etd;
        JsonDeserializer<Object> ed;
        KeyDeserializer kd = this.keyDeserializer;
        if (kd == null) {
            kd = ctxt.findKeyDeserializer(this.type.getKeyType(), property);
        }
        if ((ed = this.elementDeserializer) == null) {
            ed = ctxt.findContextualValueDeserializer(this.type.getContentType(), property);
        }
        if ((etd = this.elementTypeDeserializer) != null && property != null) {
            etd = etd.forProperty(property);
        }
        return new MultimapDeserializer(this.type, kd, etd, ed, this.creatorMethod);
    }

    @Override
    public Multimap<?, ?> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        LinkedListMultimap builder = LinkedListMultimap.create();
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            Object key = this.keyDeserializer != null ? this.keyDeserializer.deserializeKey(jp.getCurrentName(), ctxt) : jp.getCurrentName();
            jp.nextToken();
            this.expect(jp, JsonToken.START_ARRAY);
            while (jp.nextToken() != JsonToken.END_ARRAY) {
                if (this.elementTypeDeserializer != null) {
                    builder.put(key, this.elementDeserializer.deserializeWithType(jp, ctxt, this.elementTypeDeserializer));
                    continue;
                }
                builder.put(key, this.elementDeserializer.deserialize(jp, ctxt));
            }
        }
        if (this.creatorMethod == null) {
            return builder;
        }
        try {
            return (Multimap)this.creatorMethod.invoke(null, builder);
        }
        catch (InvocationTargetException e) {
            throw new JsonMappingException("Could not map to " + this.type, this._peel(e));
        }
        catch (IllegalArgumentException e) {
            throw new JsonMappingException("Could not map to " + this.type, this._peel(e));
        }
        catch (IllegalAccessException e) {
            throw new JsonMappingException("Could not map to " + this.type, this._peel(e));
        }
    }

    private static Method findTransformer(Class<?> rawType) {
        Method m;
        if (rawType == LinkedListMultimap.class || rawType == ListMultimap.class || rawType == Multimap.class) {
            return null;
        }
        for (String methodName : METHOD_NAMES) {
            try {
                m = rawType.getMethod(methodName, Multimap.class);
                if (m == null) continue;
                return m;
            }
            catch (NoSuchMethodException e) {
            }
        }
        for (String methodName : METHOD_NAMES) {
            try {
                m = rawType.getMethod(methodName, Multimap.class);
                if (m == null) continue;
                return m;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        return null;
    }

    private void expect(JsonParser jp, JsonToken token) throws IOException {
        if (jp.getCurrentToken() != token) {
            throw new JsonMappingException("Expecting " + (Object)((Object)token) + ", found " + (Object)((Object)jp.getCurrentToken()), jp.getCurrentLocation());
        }
    }

    private Throwable _peel(Throwable t) {
        while (t.getCause() != null) {
            t = t.getCause();
        }
        return t;
    }
}

