/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.guava.ser;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;

public class MultimapSerializer
extends JsonSerializer<Multimap<?, ?>>
implements ContextualSerializer {
    private final MapLikeType type;
    private final BeanProperty property;
    private final JsonSerializer<Object> keySerializer;
    private final TypeSerializer valueTypeSerializer;
    private final JsonSerializer<Object> valueSerializer;

    public MultimapSerializer(SerializationConfig config, MapLikeType type, BeanDescription beanDesc, JsonSerializer<Object> keySerializer, TypeSerializer valueTypeSerializer, JsonSerializer<Object> valueSerializer) {
        this.type = type;
        this.property = null;
        this.keySerializer = keySerializer;
        this.valueTypeSerializer = valueTypeSerializer;
        this.valueSerializer = valueSerializer;
    }

    protected MultimapSerializer(MultimapSerializer src, BeanProperty property, JsonSerializer<?> keySerializer, TypeSerializer valueTypeSerializer, JsonSerializer<?> valueSerializer) {
        this.type = src.type;
        this.property = property;
        this.keySerializer = keySerializer;
        this.valueTypeSerializer = valueTypeSerializer;
        this.valueSerializer = valueSerializer;
    }

    protected MultimapSerializer withResolved(BeanProperty property, JsonSerializer<?> keySerializer, TypeSerializer valueTypeSerializer, JsonSerializer<?> valueSerializer) {
        return new MultimapSerializer(this, property, keySerializer, valueTypeSerializer, valueSerializer);
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
        JsonSerializer<Object> valueSer = this.valueSerializer;
        if (valueSer == null) {
            JavaType valueType = this.type.getContentType();
            if (valueType.isFinal()) {
                valueSer = provider.findValueSerializer(valueType, property);
            }
        } else if (valueSer instanceof ContextualSerializer) {
            valueSer = ((ContextualSerializer)((Object)valueSer)).createContextual(provider, property);
        }
        JsonSerializer<Object> keySer = this.keySerializer;
        if (keySer == null) {
            keySer = provider.findKeySerializer(this.type.getKeyType(), property);
        } else if (keySer instanceof ContextualSerializer) {
            keySer = ((ContextualSerializer)((Object)keySer)).createContextual(provider, property);
        }
        TypeSerializer typeSer = this.valueTypeSerializer;
        if (typeSer != null) {
            typeSer = typeSer.forProperty(property);
        }
        return this.withResolved(property, keySer, typeSer, valueSer);
    }

    @Override
    public void serialize(Multimap<?, ?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        jgen.writeStartObject();
        if (!value.isEmpty()) {
            this.serializeFields(value, jgen, provider);
        }
        jgen.writeEndObject();
    }

    @Override
    public void serializeWithType(Multimap<?, ?> value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonGenerationException {
        typeSer.writeTypePrefixForObject(value, jgen);
        this.serializeFields(value, jgen, provider);
        typeSer.writeTypeSuffixForObject(value, jgen);
    }

    private final void serializeFields(Multimap<?, ?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        for (Map.Entry e : value.asMap().entrySet()) {
            if (this.keySerializer != null) {
                this.keySerializer.serialize(e.getKey(), jgen, provider);
            } else {
                provider.findKeySerializer(provider.constructType((Type)((Object)String.class)), this.property).serialize(e.getKey(), jgen, provider);
            }
            if (this.valueSerializer != null) {
                jgen.writeStartArray();
                for (Object vv : (Collection)e.getValue()) {
                    this.valueSerializer.serialize(vv, jgen, provider);
                }
                jgen.writeEndArray();
                continue;
            }
            provider.defaultSerializeValue(Lists.newArrayList((Iterable)((Iterable)e.getValue())), jgen);
        }
    }
}

