/*
 * Copyright (c) 2014 - Facebook.
 * All rights reserved.
 */

#import <Foundation/Foundation.h>

@interface A : NSObject {
    int x;
}

@end

@implementation A

+ (int)dispatch_once_example
{   static A* a = nil;
    //dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0),^{
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        a = [[A alloc] init];
        a->x = 10;
    });
    return a->x;
}

+ (int)dispatch_async_example
{   static A* a = nil;
    dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0),^{
        a = [[A alloc] init];
        a->x = 10;
    });
    return a->x;
}

+ (int)dispatch_after_example
{   static A* a = nil;
    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(2 * NSEC_PER_SEC)),
                   dispatch_get_main_queue(), ^{
        a = [[A alloc] init];
        a->x = 10;
    });
    return a->x;
}

+ (int)dispatch_group_example
{   static A* a = nil;
    dispatch_group_async(NULL, dispatch_get_main_queue(), ^{
                       a = [[A alloc] init];
                       a->x = 10;
                   });
    return a->x;
}

+ (int)dispatch_group_notify_example
{   static A* a = nil;
    dispatch_group_async(NULL, dispatch_get_main_queue(), ^{
        a = [[A alloc] init];
        a->x = 10;
    });
    return a->x;
}

+ (int)dispatch_barrier_example
{   static A* a = nil;
    dispatch_barrier_async(dispatch_get_main_queue(), ^{
        a = [[A alloc] init];
        a->x = 10;
    });
    return a->x;
}

@end
