﻿// Copyright (c) Microsoft.  All Rights Reserved.  Licensed under the Apache License, Version 2.0.  See License.txt in the project root for license information.

using Microsoft.CodeAnalysis.Text;

namespace Microsoft.CodeAnalysis.Formatting.Rules
{
    /// <summary>
    /// Options for AdjustSpacesOperation.
    /// </summary>
    internal enum AdjustSpacesOption
    {
        /// <summary>
        /// Preserve spaces as it is
        /// </summary>
        PreserveSpaces,

        /// <summary>
        /// DefaultSpacesIfOnSingleLine means a default space operation created by the formatting
        /// engine by itself. It has its own option kind to indicates that this is an operation
        /// generated by the engine itself. 
        /// </summary>
        DefaultSpacesIfOnSingleLine,

        /// <summary>
        /// ForceSpaceIfOnSingleLine means forcing the specified spaces between two tokens if two
        /// tokens are on a single line. 
        /// </summary>
        ForceSpacesIfOnSingleLine,

        /// <summary>
        /// ForceSpaces means forcing the specified spaces regardless of positions of two tokens.
        /// </summary>
        ForceSpaces,

        /// <summary>
        /// If two tokens are on a single line, second token will be placed at current indentation if possible
        /// </summary>
        DynamicSpaceToIndentationIfOnSingleLine
    }
}
