We are delighted to present version 1.19.0 of Contour, our layer 7 HTTP reverse proxy for Kubernetes clusters.

# Updates

## Use unix socket for Envoy admin webpage (#3934)

Moves the Envoy admin interface to use a unix socket by creating a new Envoy listener to expose read only information from Envoy admin page over port 9001 (by default).
This change helps to mitigate a [Contour CVE](https://github.com/projectcontour/contour/security/advisories/GHSA-5ph6-qq5x-7jwc) which could possibly allow for an `ExternalName` service to serve the Envoy Admin interface when not desired.

Also updates shutdown-manager to use new unix socket to begin Envoy draining procedure.

## Ingress header policies (#4018)

Enable setting headers on all routes on ingress objects by allowing headers to be configured in the Contour config and applied to PolicyConfig.`applyToIngress: true`.

Example:

```yaml
    policy:
      # Default headers to set on all requests
      request-headers:
        set:
          X-Envoy-Hostname: %HOSTNAME%
        applyToIngress: true
```

## Push images to GHCR and Docker Hub in parallel (#4006)

Starts pushing container images to GHCR in addition to Docker Hub.
Images will be pushed to both registries for a period of time, until the Docker Hub push is removed.

Going forward, the examples & quickstart will utilize the GHCR registry with images like: `ghcr.io/projectcontour/contour`.

## Run Envoy as non-root (#4084)

Envoy no longer need to run as `root` but runs as `nobody`.

## Make shutdown-ready file path configurable (#4084)

The shutdown-ready file path is now configurable, to allow user to optionally set a path that is writable by setting the `--ready-file` flag on the shutdown-manager.

## HTTPProxy Per-Route and Service Cookie Rewriting

Contour now enables users to customize attributes on HTTP `Set-Cookie` response headers.
Application specific cookies and cookies generated by Contour's ["cookie" load balancing strategy](https://projectcontour.io/docs/v1.19.0/config/request-routing/#session-affinity) can be rewritten either per HTTPProxy `Route` or `Service`.
Users can choose to rewrite the `Path`, `Domain`, `Secure`, and `SameSite` attributes of the `Set-Cookie` header currently.
These attributes may be things an application may not be able to accurately set, without prior knowledge of how the application is deployed.
For example, if Contour is in use to rewrite the path or hostname of a request before it reaches an application backend, the application may not be able to accurately set the `Path` and `Domain` attributes in a `Set-Cookie` response header.
This feature can be used to apply security settings to ensure browsers treat generated cookies appropriately.
The `SameSite` and `Secure` attributes are currently not set by Envoy when it generates the `X-Contour-Session-Affinity`, but with this feature, users can customize this cookie further.
Future iterations of this feature may provide cookie rewriting configuration directly as part of the cookie load balancing strategy configuration.

Some more documentation and example configuration can be found [here](https://projectcontour.io/docs/v1.19.0/config/cookie-rewriting/).
Also see Contour's CRD [API reference](https://projectcontour.io/docs/v1.19.0/config/api/) for more details.

## ContourConfiguration CRD in Alpha

Contour uses a set of flags on the `contour serve` command as well as a configuration file represented as in a Kubernetes Configmap for further configuration of Contour & Envoy.
It has been difficult to manage the contents of that file (e.g. yaml in a configmap) along with having no way of properly validating that configuration, so Contour has introduced
a new `ContourConfiguration` CRD which refactors the current config file along with any missing flags into a new object.
This new config is in an Alpha state while we verify the format of the configuration file along with its validation. 

Contour will continue to support the current configuration file for some time, but looking ahead to the roadmap, `ContourConfiguration` will be the new way to configure Contour. 

Additional details around the design of this change can be read in the design doc: https://github.com/projectcontour/contour/blob/main/design/configuration-crd.md

## New Changelog process

Contour now requires:

- All PRs be labelled with a release-note/<category> label, where category is one of major, minor, small, docs, infra, or not-required.
- A changelog file to be created in changelogs/unreleased for each PR, unless the category is not-required. The filename must be PR#-githubID-category, where githubID is that of the person opening the PR, and the category matches the label category.

## Gateway API

### Support TLSRoute weighted ForwardTos (#3938)

Add support for weighted ForwardTos in TLSRoute rules.
Per spec, weights default to 1 if unspecified, and weights of 0 mean no traffic is forwarded to the backend.

## Site

### Alt attribute to images (#3917)

Adds `alt` tags for better web accessibility.

Thanks @johnnycase for contributing this!

### Website notice feature (#3955)

Adds site formatting for projectcontour.io to have new "warning", "note", "info", and "tip" notices.

Thanks @gary-tai for contributing this!

## Misc

### Update security process docs post advisory (#3945)

Updates the security process should a new security advisory be discovered with Contour.

### Add threat model and security posture documentation (#4011)

Adds a Security document outlining Contour's threat model and how to report security issues.

### Updates for Kubernetes 1.22 (#3953)

Updates Go modules, KinD images, and kubectl version to support Kubernetes 1.22.

### Code of Conduct (#4032)

Updates the Code of Conduct to use the CNCF template.

Thanks @mzrithm for contributing this!

# Upgrading

Please consult the [upgrade documentation](https://projectcontour.io/resources/upgrading/).

## Compatible Kubernetes Versions

Contour v1.19.0 is tested against Kubernetes 1.20 through 1.22

# Community Thanks!

We’re immensely grateful for all the community contributions that help make Contour even better! For this release, special thanks go out to the following contributors:
- @gary-tai
- @senthilnathan
- @mzrithm
- @johnnycase

# Are you a Contour user? We would love to know!

If you're using Contour and want to add your organization to our adopters list, please visit this [page](https://github.com/projectcontour/contour/blob/master/ADOPTERS.md). If you prefer to keep your organization name anonymous but still give us feedback into your usage and scenarios for Contour, please post on this [GitHub thread](https://github.com/projectcontour/contour/issues/1269).
