#! /usr/bin/env bash

set -o errexit
set -o nounset
set -o pipefail

readonly REPO=$(cd "$(dirname "$0")/.." && pwd)
readonly PROGNAME=$(basename "$0")

readonly GO111MODULE=on
export   GO111MODULE

# Contour cluster role and role.
cat > "${REPO}/examples/contour/02-role-contour.yaml" <<EOF
# The following ClusterRole and Role are generated from kubebuilder RBAC tags by
# $PROGNAME. Do not edit this file directly but instead edit the source
# files and re-render.
EOF

echo "controller-gen version: "
go run sigs.k8s.io/controller-tools/cmd/controller-gen --version

go run sigs.k8s.io/controller-tools/cmd/controller-gen \
    rbac:roleName=contour \
    output:stdout \
    paths="./internal/k8s" \
>> "${REPO}/examples/contour/02-role-contour.yaml"


# Gateway provisioner cluster role and role.
cat > "${REPO}/examples/gateway-provisioner/01-roles.yaml" <<EOF
# The following ClusterRole and Role are generated from kubebuilder RBAC tags by
# $PROGNAME. Do not edit this file directly but instead edit the source
# files and re-render.
EOF

go run sigs.k8s.io/controller-tools/cmd/controller-gen \
    rbac:roleName=contour-gateway-provisioner \
    output:stdout \
    paths="./internal/provisioner/rbac;./internal/k8s" \
>> "${REPO}/examples/gateway-provisioner/01-roles.yaml"
