# Cookie Rewriting

Contour now enables users to customize attributes on HTTP `Set-Cookie` response headers.
Application specific cookies and cookies generated by Contour's ["cookie" load balancing strategy](https://projectcontour.io/docs/v1.19.0/config/request-routing/#session-affinity) can be rewritten either per HTTPProxy `Route` or `Service`.
Users can choose to rewrite the `Path`, `Domain`, `Secure`, and `SameSite` attributes of the `Set-Cookie` header currently.
These attributes may be things an application may not be able to accurately set, without prior knowledge of how the application is deployed.
For example, if Contour is in use to rewrite the path or hostname of a request before it reaches an application backend, the application may not be able to accurately set the `Path` and `Domain` attributes in a `Set-Cookie` response header.
This feature can be used to apply security settings to ensure browsers treat generated cookies appropriately.
The `SameSite` and `Secure` attributes are currently not set by Envoy when it generates the `X-Contour-Session-Affinity`, but with this feature, users can customize this cookie further.

## Per-Route Cookie Rewriting

In order to implement separate cookie rewriting policies per-route, we can configure an HTTPProxy as below:

```yaml
# cookie-rewrite-route.yaml
apiVersion: projectcontour.io/v1
kind: HTTPProxy
metadata:
  name: cookie-rewrite-route
spec:
  virtualhost:
    fqdn: cookie-rewrite-route.com
  routes:
    - conditions:
      - prefix: /admin
      services:
      - name: admin-app
        port: 80
      cookieRewritePolicies:
      - name: X-Admin-Session
        pathRewrite:
          value: /admin
    - conditions:
      - prefix: /payments
      services:
      - name: payment-app
        port: 80
      cookieRewritePolicies:
      - name: X-User-Session
        pathRewrite:
          value: /payments
        sameSite: Lax
      - name: X-User-Data
        sameSite: Lax
```

This HTTPProxy allows us to rewrite the `Path` attribute of the `X-Admin-Session` cookie on the `/admin` route.
In addition on the `/payments` route we rewrite the `Path` and `SameSite` attributes of the `X-User-Session` cookie and the `SameSite` attribute of the additional `X-User-Data` cookie.
If the backing services `payment-app` and `admin-app` return the specified cookies in `Set-Cookie` response headers, they will be rewritten with the values specified above.

## Per-Service Cookie Rewriting

Similar to the above, if we have more than one `Service` configured per `Route` but want to customize cookies separately between them we can:

```yaml
# cookie-rewrite-service.yaml
apiVersion: projectcontour.io/v1
kind: HTTPProxy
metadata:
  name: cookie-rewrite-service
spec:
  virtualhost:
    fqdn: cookie-rewrite-service.com
  routes:
    - conditions:
      - prefix: /
      services:
      - name: backend-1
        port: 80
        cookieRewritePolicies:
        - name: X-User-Data-1
          domainRewrite:
            value: cookie-rewrite-service.com
      - name: backend-2
        port: 80
        cookieRewritePolicies:
        - name: X-User-Data-2
          domainRewrite:
            value: cookie-rewrite-service.com
```

## Rewriting Contour Session Affinity Cookie

As mentioned above, users can use Contour's cookie load balancing strategy to enable session affinity.
Envoy generates a pretty bare-bones cookie but Contour's cookie rewriting feature can be used to customize this cookie to add security attributes:

```yaml
# cookie-rewrite-session-affinity.yaml
apiVersion: projectcontour.io/v1
kind: HTTPProxy
metadata:
  name: cookie-rewrite-session-affinity
spec:
  virtualhost:
    fqdn: cookie-rewrite-session-affinity.com
  routes:
    - conditions:
      - prefix: /
      services:
      - name: backend
        port: 80
      loadBalancerPolicy:
        strategy: Cookie
      cookieRewritePolicies:
      - name: X-Contour-Session-Affinity
        sameSite: Strict
        secure: true
```
