# Getting Started with Contributing

Thanks for your interest in contributing to Contour. Community contributions are always needed, welcome, and appreciated. This guide shows how you can contribute to Contour in the following areas:  

- Code
- Website
- Documentation  

Please familiarize yourself with the [Code of Conduct][1] and project [Philosophy][15] before contributing.  

# Getting Started with Code  

Everything is managed on the [Project Contour GitHub][2] organization. Create an issue for a new idea or look for issues labeled **good first issue** to get started.  

## How we work  

See [How We Work][3] for an overview:
- Issue management
- Code reviews
- Coding practice
- GitHub labels  

## Contribution workflow  

Review the [Contribution workflow][4] to understand how to work with the code.  

Below is a list of workflow areas:
- Building from source
- Contribution workflow
- Contour testing
- Developer Certificate of Origin (DCO) sign off  

# Getting Started with the Website  

Updates, corrections, or improvements are managed through [GitHub][16] issues.  

When you are ready to take on an issue, see [Website Contribution Guidelines][5] to understand how the Contour website contributions are managed. There is information on:
- Site structure
- Link formatting
- Testing
- Setting up your environment  

# Getting Started with Documentation

Documentation is critical to the success of any project. Open to all levels, Contour needs help to create and update its documentation. Join the [Contour Community Meetings][8] meeting and learn more about the Tech Docs Working Group.  

Review the [Contour Technical Documentation Contributing Guide][6] for instructions to set up your environment.  

Technical documentation will follow the [Website Contribution Guidelines][5].  

## New documentation suggestions  

If you have a document suggestion, create an issue in [GitHub][16]. The team will triage and prioritize the issue. Connect on Slack or in a meeting to discuss your issue or request.  

## Helping with identified document issues  

Take a look at the project issues list with the label **area/documentation**. If you are new to technical writing, add in the **good first issue** label: 
[area/documentation and good first issue][7]

Reach out on Slack or a Contour meeting for any assistance. Help is always appreciated.  

# Filing and Working on Issues  

Whether code, website, or documentation, Contour uses GitHub to create, track, and manage all issues.  

If there is a fix or a suggestion for improvement, create an issue in [GitHub][16].  

All issues are reviewed and evaluated by the Contour team.  

# Meet the Community and the Team  

To find out more about contributing to Contour, connect with us at a Contour Community Meeting, on Slack, or through the mailing list. We also have an Office Hours meeting to answer “How do I…” questions.  

## Contour Community meetings  

Discuss issues, features, or suggestions with the Contour team and other community members.  Ask anything and find out more about Contour. 

Ask questions:
- “How do I do this in Contour?”
- “Why does Contour do this thing this way?”
- “Where can I find…?”  

See the [Community][8] page for:
- Meeting schedule
- Meeting notes with zoom link
- Meeting recordings  

## Mailing list  

To get email updates to Contour, join the [mailing list][10]. Topics include:
- Release notifications
- Issues
- Feedback and suggestions
- Meeting notifications  

## Find us  
There are many ways to connect with the Contour team:

- Slack:	Kubernetes [#contour][11]
- Contour YouTube Channel:	[CNCF Contour][12]
- Twitter:	[@projectcontour][13]
- GitHub:	[projectcontour][14] 

# Want More Contributing Information?  

Slack or a meeting is a great way to introduce yourself. Let us know what you are interested in, your background, and what you want to accomplish.  

# Next steps  

Come out and join a [Community meeting][8] or an [Office Hours meeting][9]. Ask questions about how to get started or just sit back and get to know the team.



[1]: {{< param github_url >}}/blob/main/CODE_OF_CONDUCT.md
[2]: https://github.com/projectcontour
[3]: {{< relref "resources/how-we-work.md" >}}
[4]: {{< param github_url >}}/blob/main/CONTRIBUTING.md
[5]: {{< param github_url >}}/blob/main/SITE_CONTRIBUTION.md
[6]: {{< relref "resources/contributing-docs.md" >}}
[7]: {{< param github_url >}}/issues/?q=is%3Aopen+is%3Aissue+label%3Aarea%2Fdocumentation+label%3A%22good+first+issue%22
[8]: {{< relref "community.md" >}}
[9]: https://github.com/projectcontour/community/wiki/Office-Hours
[10]: https://lists.cncf.io/g/cncf-contour-users/
[11]: {{< param slack_url >}}
[12]: https://www.youtube.com/channel/UCCde7QSfcyYJ8AuXofD5bTA
[13]: https://twitter.com/projectcontour
[14]: https://github.com/projectcontour
[15]: {{< relref "resources/philosophy.md" >}}
[16]: {{< param github_url >}}/issues/
[17]: {{< param github_url >}}/