// Code generated by command: go run gen.go -out blake2b_amd64.s. DO NOT EDIT.

#include "textflag.h"

DATA shuffle_rot16<>+0(SB)/8, $0x0100070605040302
DATA shuffle_rot16<>+8(SB)/8, $0x09080f0e0d0c0b0a
DATA shuffle_rot16<>+16(SB)/8, $0x1110171615141312
DATA shuffle_rot16<>+24(SB)/8, $0x19181f1e1d1c1b1a
GLOBL shuffle_rot16<>(SB), RODATA|NOPTR, $32

DATA shuffle_rot24<>+0(SB)/8, $0x0201000706050403
DATA shuffle_rot24<>+8(SB)/8, $0x0a09080f0e0d0c0b
DATA shuffle_rot24<>+16(SB)/8, $0x1211101716151413
DATA shuffle_rot24<>+24(SB)/8, $0x1a19181f1e1d1c1b
GLOBL shuffle_rot24<>(SB), RODATA|NOPTR, $32

DATA shuffle_rot32<>+0(SB)/8, $0x0302010007060504
DATA shuffle_rot32<>+8(SB)/8, $0x0b0a09080f0e0d0c
DATA shuffle_rot32<>+16(SB)/8, $0x1312111017161514
DATA shuffle_rot32<>+24(SB)/8, $0x1b1a19181f1e1d1c
GLOBL shuffle_rot32<>(SB), RODATA|NOPTR, $32

DATA shuffle_first_vector<>+0(SB)/8, $0x06050403020100ff
DATA shuffle_first_vector<>+8(SB)/8, $0x0e0d0c0b0a0908ff
DATA shuffle_first_vector<>+16(SB)/8, $0x16151413121110ff
DATA shuffle_first_vector<>+24(SB)/8, $0x1e1d1c1b1a1918ff
GLOBL shuffle_first_vector<>(SB), RODATA|NOPTR, $32

DATA shuffle_last_vector<>+0(SB)/8, $0xffffffffffffff07
DATA shuffle_last_vector<>+8(SB)/8, $0xffffffffffffff0f
DATA shuffle_last_vector<>+16(SB)/8, $0xffffffffffffff17
DATA shuffle_last_vector<>+24(SB)/8, $0xffffffffffffff1f
GLOBL shuffle_last_vector<>(SB), RODATA|NOPTR, $32

DATA stride_64<>+0(SB)/8, $0x0000000000000000
DATA stride_64<>+8(SB)/8, $0x0000000000000040
DATA stride_64<>+16(SB)/8, $0x0000000000000080
DATA stride_64<>+24(SB)/8, $0x00000000000000c0
GLOBL stride_64<>(SB), RODATA|NOPTR, $32

DATA init_state<>+0(SB)/8, $0x6a09e667f2bdc928
DATA init_state<>+8(SB)/8, $0xbb67ae8584caa73b
DATA init_state<>+16(SB)/8, $0x3c6ef372fe94f82b
DATA init_state<>+24(SB)/8, $0xa54ff53a5f1d36f1
DATA init_state<>+32(SB)/8, $0x510e527fade682d1
DATA init_state<>+40(SB)/8, $0x9b05688c2b3e6c1f
DATA init_state<>+48(SB)/8, $0x1f83d9abfb41bd6b
DATA init_state<>+56(SB)/8, $0x5be0cd19137e2179
DATA init_state<>+64(SB)/8, $0x6a09e667f3bcc908
DATA init_state<>+72(SB)/8, $0xbb67ae8584caa73b
DATA init_state<>+80(SB)/8, $0x3c6ef372fe94f82b
DATA init_state<>+88(SB)/8, $0xa54ff53a5f1d36f1
DATA init_state<>+96(SB)/8, $0x510e527fade68290
DATA init_state<>+104(SB)/8, $0x9b05688c2b3e6c1f
DATA init_state<>+112(SB)/8, $0xe07c265404be4294
DATA init_state<>+120(SB)/8, $0x5be0cd19137e2179
GLOBL init_state<>(SB), RODATA|NOPTR, $128

// func hashBlocksAVX2(outs *[4][32]byte, msgs *[4][64]byte, prefix uint64)
// Requires: AVX, AVX2
TEXT ·hashBlocksAVX2(SB), NOSPLIT, $320-24
	MOVQ msgs+8(FP), AX
	MOVQ outs+0(FP), CX

	// Transpose message vectors into the stack
	VMOVDQU      stride_64<>+0(SB), Y15
	VPCMPEQD     Y14, Y14, Y14
	VPGATHERQQ   Y14, (AX)(Y15*1), Y0
	VPCMPEQD     Y14, Y14, Y14
	VPGATHERQQ   Y14, 7(AX)(Y15*1), Y1
	VPCMPEQD     Y14, Y14, Y14
	VPGATHERQQ   Y14, 15(AX)(Y15*1), Y2
	VPCMPEQD     Y14, Y14, Y14
	VPGATHERQQ   Y14, 23(AX)(Y15*1), Y3
	VPCMPEQD     Y14, Y14, Y14
	VPGATHERQQ   Y14, 31(AX)(Y15*1), Y4
	VPCMPEQD     Y14, Y14, Y14
	VPGATHERQQ   Y14, 39(AX)(Y15*1), Y5
	VPCMPEQD     Y14, Y14, Y14
	VPGATHERQQ   Y14, 47(AX)(Y15*1), Y6
	VPCMPEQD     Y14, Y14, Y14
	VPGATHERQQ   Y14, 55(AX)(Y15*1), Y7
	VPCMPEQD     Y14, Y14, Y14
	VPGATHERQQ   Y14, 56(AX)(Y15*1), Y8
	VPSHUFB      shuffle_first_vector<>+0(SB), Y0, Y0
	VPBROADCASTQ prefix+16(FP), Y15
	VPOR         Y0, Y15, Y0
	VPSHUFB      shuffle_last_vector<>+0(SB), Y8, Y8
	VMOVDQU      Y0, (SP)
	VMOVDQU      Y1, 32(SP)
	VMOVDQU      Y2, 64(SP)
	VMOVDQU      Y3, 96(SP)
	VMOVDQU      Y4, 128(SP)
	VMOVDQU      Y5, 160(SP)
	VMOVDQU      Y6, 192(SP)
	VMOVDQU      Y7, 224(SP)
	VMOVDQU      Y8, 256(SP)

	// Round setup
	VPBROADCASTQ init_state<>+0(SB), Y0
	VPBROADCASTQ init_state<>+8(SB), Y1
	VPBROADCASTQ init_state<>+16(SB), Y2
	VPBROADCASTQ init_state<>+24(SB), Y3
	VPBROADCASTQ init_state<>+32(SB), Y4
	VPBROADCASTQ init_state<>+40(SB), Y5
	VPBROADCASTQ init_state<>+48(SB), Y6
	VPBROADCASTQ init_state<>+56(SB), Y7
	VPBROADCASTQ init_state<>+64(SB), Y8
	VPBROADCASTQ init_state<>+72(SB), Y9
	VPBROADCASTQ init_state<>+80(SB), Y10
	VPBROADCASTQ init_state<>+88(SB), Y11
	VPBROADCASTQ init_state<>+96(SB), Y12
	VPBROADCASTQ init_state<>+104(SB), Y13
	VPBROADCASTQ init_state<>+112(SB), Y14
	VPBROADCASTQ init_state<>+120(SB), Y15
	VMOVDQU      Y8, 288(SP)

	// Round 1
	VPADDQ  Y0, Y4, Y0
	VPADDQ  (SP), Y0, Y0
	VPXOR   Y12, Y0, Y12
	VPSHUFB shuffle_rot32<>+0(SB), Y12, Y12
	VPADDQ  288(SP), Y12, Y8
	VPXOR   Y4, Y8, Y4
	VPSHUFB shuffle_rot24<>+0(SB), Y4, Y4
	VPADDQ  Y0, Y4, Y0
	VPADDQ  32(SP), Y0, Y0
	VPXOR   Y12, Y0, Y12
	VPSHUFB shuffle_rot16<>+0(SB), Y12, Y12
	VPADDQ  Y8, Y12, Y8
	VPXOR   Y4, Y8, Y4
	VMOVDQU Y8, 288(SP)
	VPSRLQ  $0x3f, Y4, Y8
	VPSLLQ  $0x01, Y4, Y4
	VPOR    Y4, Y8, Y4
	VPADDQ  Y1, Y5, Y1
	VPADDQ  64(SP), Y1, Y1
	VPXOR   Y13, Y1, Y13
	VPSHUFB shuffle_rot32<>+0(SB), Y13, Y13
	VPADDQ  Y9, Y13, Y9
	VPXOR   Y5, Y9, Y5
	VPSHUFB shuffle_rot24<>+0(SB), Y5, Y5
	VPADDQ  Y1, Y5, Y1
	VPADDQ  96(SP), Y1, Y1
	VPXOR   Y13, Y1, Y13
	VPSHUFB shuffle_rot16<>+0(SB), Y13, Y13
	VPADDQ  Y9, Y13, Y9
	VPXOR   Y5, Y9, Y5
	VPSRLQ  $0x3f, Y5, Y8
	VPSLLQ  $0x01, Y5, Y5
	VPOR    Y5, Y8, Y5
	VPADDQ  Y2, Y6, Y2
	VPADDQ  128(SP), Y2, Y2
	VPXOR   Y14, Y2, Y14
	VPSHUFB shuffle_rot32<>+0(SB), Y14, Y14
	VPADDQ  Y10, Y14, Y10
	VPXOR   Y6, Y10, Y6
	VPSHUFB shuffle_rot24<>+0(SB), Y6, Y6
	VPADDQ  Y2, Y6, Y2
	VPADDQ  160(SP), Y2, Y2
	VPXOR   Y14, Y2, Y14
	VPSHUFB shuffle_rot16<>+0(SB), Y14, Y14
	VPADDQ  Y10, Y14, Y10
	VPXOR   Y6, Y10, Y6
	VPSRLQ  $0x3f, Y6, Y8
	VPSLLQ  $0x01, Y6, Y6
	VPOR    Y6, Y8, Y6
	VPADDQ  Y3, Y7, Y3
	VPADDQ  192(SP), Y3, Y3
	VPXOR   Y15, Y3, Y15
	VPSHUFB shuffle_rot32<>+0(SB), Y15, Y15
	VPADDQ  Y11, Y15, Y11
	VPXOR   Y7, Y11, Y7
	VPSHUFB shuffle_rot24<>+0(SB), Y7, Y7
	VPADDQ  Y3, Y7, Y3
	VPADDQ  224(SP), Y3, Y3
	VPXOR   Y15, Y3, Y15
	VPSHUFB shuffle_rot16<>+0(SB), Y15, Y15
	VPADDQ  Y11, Y15, Y11
	VPXOR   Y7, Y11, Y7
	VPSRLQ  $0x3f, Y7, Y8
	VPSLLQ  $0x01, Y7, Y7
	VPOR    Y7, Y8, Y7
	VPADDQ  Y0, Y5, Y0
	VPADDQ  256(SP), Y0, Y0
	VPXOR   Y15, Y0, Y15
	VPSHUFB shuffle_rot32<>+0(SB), Y15, Y15
	VPADDQ  Y10, Y15, Y10
	VPXOR   Y5, Y10, Y5
	VPSHUFB shuffle_rot24<>+0(SB), Y5, Y5
	VPADDQ  Y0, Y5, Y0
	VPXOR   Y15, Y0, Y15
	VPSHUFB shuffle_rot16<>+0(SB), Y15, Y15
	VPADDQ  Y10, Y15, Y10
	VPXOR   Y5, Y10, Y5
	VPSRLQ  $0x3f, Y5, Y8
	VPSLLQ  $0x01, Y5, Y5
	VPOR    Y5, Y8, Y5
	VPADDQ  Y1, Y6, Y1
	VPXOR   Y12, Y1, Y12
	VPSHUFB shuffle_rot32<>+0(SB), Y12, Y12
	VPADDQ  Y11, Y12, Y11
	VPXOR   Y6, Y11, Y6
	VPSHUFB shuffle_rot24<>+0(SB), Y6, Y6
	VPADDQ  Y1, Y6, Y1
	VPXOR   Y12, Y1, Y12
	VPSHUFB shuffle_rot16<>+0(SB), Y12, Y12
	VPADDQ  Y11, Y12, Y11
	VPXOR   Y6, Y11, Y6
	VPSRLQ  $0x3f, Y6, Y8
	VPSLLQ  $0x01, Y6, Y6
	VPOR    Y6, Y8, Y6
	VPADDQ  Y2, Y7, Y2
	VPXOR   Y13, Y2, Y13
	VPSHUFB shuffle_rot32<>+0(SB), Y13, Y13
	VPADDQ  288(SP), Y13, Y8
	VPXOR   Y7, Y8, Y7
	VPSHUFB shuffle_rot24<>+0(SB), Y7, Y7
	VPADDQ  Y2, Y7, Y2
	VPXOR   Y13, Y2, Y13
	VPSHUFB shuffle_rot16<>+0(SB), Y13, Y13
	VPADDQ  Y8, Y13, Y8
	VPXOR   Y7, Y8, Y7
	VMOVDQU Y8, 288(SP)
	VPSRLQ  $0x3f, Y7, Y8
	VPSLLQ  $0x01, Y7, Y7
	VPOR    Y7, Y8, Y7
	VPADDQ  Y3, Y4, Y3
	VPXOR   Y14, Y3, Y14
	VPSHUFB shuffle_rot32<>+0(SB), Y14, Y14
	VPADDQ  Y9, Y14, Y9
	VPXOR   Y4, Y9, Y4
	VPSHUFB shuffle_rot24<>+0(SB), Y4, Y4
	VPADDQ  Y3, Y4, Y3
	VPXOR   Y14, Y3, Y14
	VPSHUFB shuffle_rot16<>+0(SB), Y14, Y14
	VPADDQ  Y9, Y14, Y9
	VPXOR   Y4, Y9, Y4
	VPSRLQ  $0x3f, Y4, Y8
	VPSLLQ  $0x01, Y4, Y4
	VPOR    Y4, Y8, Y4

	// Round 2
	VPADDQ  Y0, Y4, Y0
	VPXOR   Y12, Y0, Y12
	VPSHUFB shuffle_rot32<>+0(SB), Y12, Y12
	VPADDQ  288(SP), Y12, Y8
	VPXOR   Y4, Y8, Y4
	VPSHUFB shuffle_rot24<>+0(SB), Y4, Y4
	VPADDQ  Y0, Y4, Y0
	VPXOR   Y12, Y0, Y12
	VPSHUFB shuffle_rot16<>+0(SB), Y12, Y12
	VPADDQ  Y8, Y12, Y8
	VPXOR   Y4, Y8, Y4
	VMOVDQU Y8, 288(SP)
	VPSRLQ  $0x3f, Y4, Y8
	VPSLLQ  $0x01, Y4, Y4
	VPOR    Y4, Y8, Y4
	VPADDQ  Y1, Y5, Y1
	VPADDQ  128(SP), Y1, Y1
	VPXOR   Y13, Y1, Y13
	VPSHUFB shuffle_rot32<>+0(SB), Y13, Y13
	VPADDQ  Y9, Y13, Y9
	VPXOR   Y5, Y9, Y5
	VPSHUFB shuffle_rot24<>+0(SB), Y5, Y5
	VPADDQ  Y1, Y5, Y1
	VPADDQ  256(SP), Y1, Y1
	VPXOR   Y13, Y1, Y13
	VPSHUFB shuffle_rot16<>+0(SB), Y13, Y13
	VPADDQ  Y9, Y13, Y9
	VPXOR   Y5, Y9, Y5
	VPSRLQ  $0x3f, Y5, Y8
	VPSLLQ  $0x01, Y5, Y5
	VPOR    Y5, Y8, Y5
	VPADDQ  Y2, Y6, Y2
	VPXOR   Y14, Y2, Y14
	VPSHUFB shuffle_rot32<>+0(SB), Y14, Y14
	VPADDQ  Y10, Y14, Y10
	VPXOR   Y6, Y10, Y6
	VPSHUFB shuffle_rot24<>+0(SB), Y6, Y6
	VPADDQ  Y2, Y6, Y2
	VPXOR   Y14, Y2, Y14
	VPSHUFB shuffle_rot16<>+0(SB), Y14, Y14
	VPADDQ  Y10, Y14, Y10
	VPXOR   Y6, Y10, Y6
	VPSRLQ  $0x3f, Y6, Y8
	VPSLLQ  $0x01, Y6, Y6
	VPOR    Y6, Y8, Y6
	VPADDQ  Y3, Y7, Y3
	VPXOR   Y15, Y3, Y15
	VPSHUFB shuffle_rot32<>+0(SB), Y15, Y15
	VPADDQ  Y11, Y15, Y11
	VPXOR   Y7, Y11, Y7
	VPSHUFB shuffle_rot24<>+0(SB), Y7, Y7
	VPADDQ  Y3, Y7, Y3
	VPADDQ  192(SP), Y3, Y3
	VPXOR   Y15, Y3, Y15
	VPSHUFB shuffle_rot16<>+0(SB), Y15, Y15
	VPADDQ  Y11, Y15, Y11
	VPXOR   Y7, Y11, Y7
	VPSRLQ  $0x3f, Y7, Y8
	VPSLLQ  $0x01, Y7, Y7
	VPOR    Y7, Y8, Y7
	VPADDQ  Y0, Y5, Y0
	VPADDQ  32(SP), Y0, Y0
	VPXOR   Y15, Y0, Y15
	VPSHUFB shuffle_rot32<>+0(SB), Y15, Y15
	VPADDQ  Y10, Y15, Y10
	VPXOR   Y5, Y10, Y5
	VPSHUFB shuffle_rot24<>+0(SB), Y5, Y5
	VPADDQ  Y0, Y5, Y0
	VPXOR   Y15, Y0, Y15
	VPSHUFB shuffle_rot16<>+0(SB), Y15, Y15
	VPADDQ  Y10, Y15, Y10
	VPXOR   Y5, Y10, Y5
	VPSRLQ  $0x3f, Y5, Y8
	VPSLLQ  $0x01, Y5, Y5
	VPOR    Y5, Y8, Y5
	VPADDQ  Y1, Y6, Y1
	VPADDQ  (SP), Y1, Y1
	VPXOR   Y12, Y1, Y12
	VPSHUFB shuffle_rot32<>+0(SB), Y12, Y12
	VPADDQ  Y11, Y12, Y11
	VPXOR   Y6, Y11, Y6
	VPSHUFB shuffle_rot24<>+0(SB), Y6, Y6
	VPADDQ  Y1, Y6, Y1
	VPADDQ  64(SP), Y1, Y1
	VPXOR   Y12, Y1, Y12
	VPSHUFB shuffle_rot16<>+0(SB), Y12, Y12
	VPADDQ  Y11, Y12, Y11
	VPXOR   Y6, Y11, Y6
	VPSRLQ  $0x3f, Y6, Y8
	VPSLLQ  $0x01, Y6, Y6
	VPOR    Y6, Y8, Y6
	VPADDQ  Y2, Y7, Y2
	VPXOR   Y13, Y2, Y13
	VPSHUFB shuffle_rot32<>+0(SB), Y13, Y13
	VPADDQ  288(SP), Y13, Y8
	VPXOR   Y7, Y8, Y7
	VPSHUFB shuffle_rot24<>+0(SB), Y7, Y7
	VPADDQ  Y2, Y7, Y2
	VPADDQ  224(SP), Y2, Y2
	VPXOR   Y13, Y2, Y13
	VPSHUFB shuffle_rot16<>+0(SB), Y13, Y13
	VPADDQ  Y8, Y13, Y8
	VPXOR   Y7, Y8, Y7
	VMOVDQU Y8, 288(SP)
	VPSRLQ  $0x3f, Y7, Y8
	VPSLLQ  $0x01, Y7, Y7
	VPOR    Y7, Y8, Y7
	VPADDQ  Y3, Y4, Y3
	VPADDQ  160(SP), Y3, Y3
	VPXOR   Y14, Y3, Y14
	VPSHUFB shuffle_rot32<>+0(SB), Y14, Y14
	VPADDQ  Y9, Y14, Y9
	VPXOR   Y4, Y9, Y4
	VPSHUFB shuffle_rot24<>+0(SB), Y4, Y4
	VPADDQ  Y3, Y4, Y3
	VPADDQ  96(SP), Y3, Y3
	VPXOR   Y14, Y3, Y14
	VPSHUFB shuffle_rot16<>+0(SB), Y14, Y14
	VPADDQ  Y9, Y14, Y9
	VPXOR   Y4, Y9, Y4
	VPSRLQ  $0x3f, Y4, Y8
	VPSLLQ  $0x01, Y4, Y4
	VPOR    Y4, Y8, Y4

	// Round 3
	VPADDQ  Y0, Y4, Y0
	VPXOR   Y12, Y0, Y12
	VPSHUFB shuffle_rot32<>+0(SB), Y12, Y12
	VPADDQ  288(SP), Y12, Y8
	VPXOR   Y4, Y8, Y4
	VPSHUFB shuffle_rot24<>+0(SB), Y4, Y4
	VPADDQ  Y0, Y4, Y0
	VPADDQ  256(SP), Y0, Y0
	VPXOR   Y12, Y0, Y12
	VPSHUFB shuffle_rot16<>+0(SB), Y12, Y12
	VPADDQ  Y8, Y12, Y8
	VPXOR   Y4, Y8, Y4
	VMOVDQU Y8, 288(SP)
	VPSRLQ  $0x3f, Y4, Y8
	VPSLLQ  $0x01, Y4, Y4
	VPOR    Y4, Y8, Y4
	VPADDQ  Y1, Y5, Y1
	VPXOR   Y13, Y1, Y13
	VPSHUFB shuffle_rot32<>+0(SB), Y13, Y13
	VPADDQ  Y9, Y13, Y9
	VPXOR   Y5, Y9, Y5
	VPSHUFB shuffle_rot24<>+0(SB), Y5, Y5
	VPADDQ  Y1, Y5, Y1
	VPADDQ  (SP), Y1, Y1
	VPXOR   Y13, Y1, Y13
	VPSHUFB shuffle_rot16<>+0(SB), Y13, Y13
	VPADDQ  Y9, Y13, Y9
	VPXOR   Y5, Y9, Y5
	VPSRLQ  $0x3f, Y5, Y8
	VPSLLQ  $0x01, Y5, Y5
	VPOR    Y5, Y8, Y5
	VPADDQ  Y2, Y6, Y2
	VPADDQ  160(SP), Y2, Y2
	VPXOR   Y14, Y2, Y14
	VPSHUFB shuffle_rot32<>+0(SB), Y14, Y14
	VPADDQ  Y10, Y14, Y10
	VPXOR   Y6, Y10, Y6
	VPSHUFB shuffle_rot24<>+0(SB), Y6, Y6
	VPADDQ  Y2, Y6, Y2
	VPADDQ  64(SP), Y2, Y2
	VPXOR   Y14, Y2, Y14
	VPSHUFB shuffle_rot16<>+0(SB), Y14, Y14
	VPADDQ  Y10, Y14, Y10
	VPXOR   Y6, Y10, Y6
	VPSRLQ  $0x3f, Y6, Y8
	VPSLLQ  $0x01, Y6, Y6
	VPOR    Y6, Y8, Y6
	VPADDQ  Y3, Y7, Y3
	VPXOR   Y15, Y3, Y15
	VPSHUFB shuffle_rot32<>+0(SB), Y15, Y15
	VPADDQ  Y11, Y15, Y11
	VPXOR   Y7, Y11, Y7
	VPSHUFB shuffle_rot24<>+0(SB), Y7, Y7
	VPADDQ  Y3, Y7, Y3
	VPXOR   Y15, Y3, Y15
	VPSHUFB shuffle_rot16<>+0(SB), Y15, Y15
	VPADDQ  Y11, Y15, Y11
	VPXOR   Y7, Y11, Y7
	VPSRLQ  $0x3f, Y7, Y8
	VPSLLQ  $0x01, Y7, Y7
	VPOR    Y7, Y8, Y7
	VPADDQ  Y0, Y5, Y0
	VPXOR   Y15, Y0, Y15
	VPSHUFB shuffle_rot32<>+0(SB), Y15, Y15
	VPADDQ  Y10, Y15, Y10
	VPXOR   Y5, Y10, Y5
	VPSHUFB shuffle_rot24<>+0(SB), Y5, Y5
	VPADDQ  Y0, Y5, Y0
	VPXOR   Y15, Y0, Y15
	VPSHUFB shuffle_rot16<>+0(SB), Y15, Y15
	VPADDQ  Y10, Y15, Y10
	VPXOR   Y5, Y10, Y5
	VPSRLQ  $0x3f, Y5, Y8
	VPSLLQ  $0x01, Y5, Y5
	VPOR    Y5, Y8, Y5
	VPADDQ  Y1, Y6, Y1
	VPADDQ  96(SP), Y1, Y1
	VPXOR   Y12, Y1, Y12
	VPSHUFB shuffle_rot32<>+0(SB), Y12, Y12
	VPADDQ  Y11, Y12, Y11
	VPXOR   Y6, Y11, Y6
	VPSHUFB shuffle_rot24<>+0(SB), Y6, Y6
	VPADDQ  Y1, Y6, Y1
	VPADDQ  192(SP), Y1, Y1
	VPXOR   Y12, Y1, Y12
	VPSHUFB shuffle_rot16<>+0(SB), Y12, Y12
	VPADDQ  Y11, Y12, Y11
	VPXOR   Y6, Y11, Y6
	VPSRLQ  $0x3f, Y6, Y8
	VPSLLQ  $0x01, Y6, Y6
	VPOR    Y6, Y8, Y6
	VPADDQ  Y2, Y7, Y2
	VPADDQ  224(SP), Y2, Y2
	VPXOR   Y13, Y2, Y13
	VPSHUFB shuffle_rot32<>+0(SB), Y13, Y13
	VPADDQ  288(SP), Y13, Y8
	VPXOR   Y7, Y8, Y7
	VPSHUFB shuffle_rot24<>+0(SB), Y7, Y7
	VPADDQ  Y2, Y7, Y2
	VPADDQ  32(SP), Y2, Y2
	VPXOR   Y13, Y2, Y13
	VPSHUFB shuffle_rot16<>+0(SB), Y13, Y13
	VPADDQ  Y8, Y13, Y8
	VPXOR   Y7, Y8, Y7
	VMOVDQU Y8, 288(SP)
	VPSRLQ  $0x3f, Y7, Y8
	VPSLLQ  $0x01, Y7, Y7
	VPOR    Y7, Y8, Y7
	VPADDQ  Y3, Y4, Y3
	VPXOR   Y14, Y3, Y14
	VPSHUFB shuffle_rot32<>+0(SB), Y14, Y14
	VPADDQ  Y9, Y14, Y9
	VPXOR   Y4, Y9, Y4
	VPSHUFB shuffle_rot24<>+0(SB), Y4, Y4
	VPADDQ  Y3, Y4, Y3
	VPADDQ  128(SP), Y3, Y3
	VPXOR   Y14, Y3, Y14
	VPSHUFB shuffle_rot16<>+0(SB), Y14, Y14
	VPADDQ  Y9, Y14, Y9
	VPXOR   Y4, Y9, Y4
	VPSRLQ  $0x3f, Y4, Y8
	VPSLLQ  $0x01, Y4, Y4
	VPOR    Y4, Y8, Y4

	// Round 4
	VPADDQ  Y0, Y4, Y0
	VPADDQ  224(SP), Y0, Y0
	VPXOR   Y12, Y0, Y12
	VPSHUFB shuffle_rot32<>+0(SB), Y12, Y12
	VPADDQ  288(SP), Y12, Y8
	VPXOR   Y4, Y8, Y4
	VPSHUFB shuffle_rot24<>+0(SB), Y4, Y4
	VPADDQ  Y0, Y4, Y0
	VPXOR   Y12, Y0, Y12
	VPSHUFB shuffle_rot16<>+0(SB), Y12, Y12
	VPADDQ  Y8, Y12, Y8
	VPXOR   Y4, Y8, Y4
	VMOVDQU Y8, 288(SP)
	VPSRLQ  $0x3f, Y4, Y8
	VPSLLQ  $0x01, Y4, Y4
	VPOR    Y4, Y8, Y4
	VPADDQ  Y1, Y5, Y1
	VPADDQ  96(SP), Y1, Y1
	VPXOR   Y13, Y1, Y13
	VPSHUFB shuffle_rot32<>+0(SB), Y13, Y13
	VPADDQ  Y9, Y13, Y9
	VPXOR   Y5, Y9, Y5
	VPSHUFB shuffle_rot24<>+0(SB), Y5, Y5
	VPADDQ  Y1, Y5, Y1
	VPADDQ  32(SP), Y1, Y1
	VPXOR   Y13, Y1, Y13
	VPSHUFB shuffle_rot16<>+0(SB), Y13, Y13
	VPADDQ  Y9, Y13, Y9
	VPXOR   Y5, Y9, Y5
	VPSRLQ  $0x3f, Y5, Y8
	VPSLLQ  $0x01, Y5, Y5
	VPOR    Y5, Y8, Y5
	VPADDQ  Y2, Y6, Y2
	VPXOR   Y14, Y2, Y14
	VPSHUFB shuffle_rot32<>+0(SB), Y14, Y14
	VPADDQ  Y10, Y14, Y10
	VPXOR   Y6, Y10, Y6
	VPSHUFB shuffle_rot24<>+0(SB), Y6, Y6
	VPADDQ  Y2, Y6, Y2
	VPXOR   Y14, Y2, Y14
	VPSHUFB shuffle_rot16<>+0(SB), Y14, Y14
	VPADDQ  Y10, Y14, Y10
	VPXOR   Y6, Y10, Y6
	VPSRLQ  $0x3f, Y6, Y8
	VPSLLQ  $0x01, Y6, Y6
	VPOR    Y6, Y8, Y6
	VPADDQ  Y3, Y7, Y3
	VPXOR   Y15, Y3, Y15
	VPSHUFB shuffle_rot32<>+0(SB), Y15, Y15
	VPADDQ  Y11, Y15, Y11
	VPXOR   Y7, Y11, Y7
	VPSHUFB shuffle_rot24<>+0(SB), Y7, Y7
	VPADDQ  Y3, Y7, Y3
	VPXOR   Y15, Y3, Y15
	VPSHUFB shuffle_rot16<>+0(SB), Y15, Y15
	VPADDQ  Y11, Y15, Y11
	VPXOR   Y7, Y11, Y7
	VPSRLQ  $0x3f, Y7, Y8
	VPSLLQ  $0x01, Y7, Y7
	VPOR    Y7, Y8, Y7
	VPADDQ  Y0, Y5, Y0
	VPADDQ  64(SP), Y0, Y0
	VPXOR   Y15, Y0, Y15
	VPSHUFB shuffle_rot32<>+0(SB), Y15, Y15
	VPADDQ  Y10, Y15, Y10
	VPXOR   Y5, Y10, Y5
	VPSHUFB shuffle_rot24<>+0(SB), Y5, Y5
	VPADDQ  Y0, Y5, Y0
	VPADDQ  192(SP), Y0, Y0
	VPXOR   Y15, Y0, Y15
	VPSHUFB shuffle_rot16<>+0(SB), Y15, Y15
	VPADDQ  Y10, Y15, Y10
	VPXOR   Y5, Y10, Y5
	VPSRLQ  $0x3f, Y5, Y8
	VPSLLQ  $0x01, Y5, Y5
	VPOR    Y5, Y8, Y5
	VPADDQ  Y1, Y6, Y1
	VPADDQ  160(SP), Y1, Y1
	VPXOR   Y12, Y1, Y12
	VPSHUFB shuffle_rot32<>+0(SB), Y12, Y12
	VPADDQ  Y11, Y12, Y11
	VPXOR   Y6, Y11, Y6
	VPSHUFB shuffle_rot24<>+0(SB), Y6, Y6
	VPADDQ  Y1, Y6, Y1
	VPXOR   Y12, Y1, Y12
	VPSHUFB shuffle_rot16<>+0(SB), Y12, Y12
	VPADDQ  Y11, Y12, Y11
	VPXOR   Y6, Y11, Y6
	VPSRLQ  $0x3f, Y6, Y8
	VPSLLQ  $0x01, Y6, Y6
	VPOR    Y6, Y8, Y6
	VPADDQ  Y2, Y7, Y2
	VPADDQ  128(SP), Y2, Y2
	VPXOR   Y13, Y2, Y13
	VPSHUFB shuffle_rot32<>+0(SB), Y13, Y13
	VPADDQ  288(SP), Y13, Y8
	VPXOR   Y7, Y8, Y7
	VPSHUFB shuffle_rot24<>+0(SB), Y7, Y7
	VPADDQ  Y2, Y7, Y2
	VPADDQ  (SP), Y2, Y2
	VPXOR   Y13, Y2, Y13
	VPSHUFB shuffle_rot16<>+0(SB), Y13, Y13
	VPADDQ  Y8, Y13, Y8
	VPXOR   Y7, Y8, Y7
	VMOVDQU Y8, 288(SP)
	VPSRLQ  $0x3f, Y7, Y8
	VPSLLQ  $0x01, Y7, Y7
	VPOR    Y7, Y8, Y7
	VPADDQ  Y3, Y4, Y3
	VPXOR   Y14, Y3, Y14
	VPSHUFB shuffle_rot32<>+0(SB), Y14, Y14
	VPADDQ  Y9, Y14, Y9
	VPXOR   Y4, Y9, Y4
	VPSHUFB shuffle_rot24<>+0(SB), Y4, Y4
	VPADDQ  Y3, Y4, Y3
	VPADDQ  256(SP), Y3, Y3
	VPXOR   Y14, Y3, Y14
	VPSHUFB shuffle_rot16<>+0(SB), Y14, Y14
	VPADDQ  Y9, Y14, Y9
	VPXOR   Y4, Y9, Y4
	VPSRLQ  $0x3f, Y4, Y8
	VPSLLQ  $0x01, Y4, Y4
	VPOR    Y4, Y8, Y4

	// Round 5
	VPADDQ  Y0, Y4, Y0
	VPXOR   Y12, Y0, Y12
	VPSHUFB shuffle_rot32<>+0(SB), Y12, Y12
	VPADDQ  288(SP), Y12, Y8
	VPXOR   Y4, Y8, Y4
	VPSHUFB shuffle_rot24<>+0(SB), Y4, Y4
	VPADDQ  Y0, Y4, Y0
	VPADDQ  (SP), Y0, Y0
	VPXOR   Y12, Y0, Y12
	VPSHUFB shuffle_rot16<>+0(SB), Y12, Y12
	VPADDQ  Y8, Y12, Y8
	VPXOR   Y4, Y8, Y4
	VMOVDQU Y8, 288(SP)
	VPSRLQ  $0x3f, Y4, Y8
	VPSLLQ  $0x01, Y4, Y4
	VPOR    Y4, Y8, Y4
	VPADDQ  Y1, Y5, Y1
	VPADDQ  160(SP), Y1, Y1
	VPXOR   Y13, Y1, Y13
	VPSHUFB shuffle_rot32<>+0(SB), Y13, Y13
	VPADDQ  Y9, Y13, Y9
	VPXOR   Y5, Y9, Y5
	VPSHUFB shuffle_rot24<>+0(SB), Y5, Y5
	VPADDQ  Y1, Y5, Y1
	VPADDQ  224(SP), Y1, Y1
	VPXOR   Y13, Y1, Y13
	VPSHUFB shuffle_rot16<>+0(SB), Y13, Y13
	VPADDQ  Y9, Y13, Y9
	VPXOR   Y5, Y9, Y5
	VPSRLQ  $0x3f, Y5, Y8
	VPSLLQ  $0x01, Y5, Y5
	VPOR    Y5, Y8, Y5
	VPADDQ  Y2, Y6, Y2
	VPADDQ  64(SP), Y2, Y2
	VPXOR   Y14, Y2, Y14
	VPSHUFB shuffle_rot32<>+0(SB), Y14, Y14
	VPADDQ  Y10, Y14, Y10
	VPXOR   Y6, Y10, Y6
	VPSHUFB shuffle_rot24<>+0(SB), Y6, Y6
	VPADDQ  Y2, Y6, Y2
	VPADDQ  128(SP), Y2, Y2
	VPXOR   Y14, Y2, Y14
	VPSHUFB shuffle_rot16<>+0(SB), Y14, Y14
	VPADDQ  Y10, Y14, Y10
	VPXOR   Y6, Y10, Y6
	VPSRLQ  $0x3f, Y6, Y8
	VPSLLQ  $0x01, Y6, Y6
	VPOR    Y6, Y8, Y6
	VPADDQ  Y3, Y7, Y3
	VPXOR   Y15, Y3, Y15
	VPSHUFB shuffle_rot32<>+0(SB), Y15, Y15
	VPADDQ  Y11, Y15, Y11
	VPXOR   Y7, Y11, Y7
	VPSHUFB shuffle_rot24<>+0(SB), Y7, Y7
	VPADDQ  Y3, Y7, Y3
	VPXOR   Y15, Y3, Y15
	VPSHUFB shuffle_rot16<>+0(SB), Y15, Y15
	VPADDQ  Y11, Y15, Y11
	VPXOR   Y7, Y11, Y7
	VPSRLQ  $0x3f, Y7, Y8
	VPSLLQ  $0x01, Y7, Y7
	VPOR    Y7, Y8, Y7
	VPADDQ  Y0, Y5, Y0
	VPXOR   Y15, Y0, Y15
	VPSHUFB shuffle_rot32<>+0(SB), Y15, Y15
	VPADDQ  Y10, Y15, Y10
	VPXOR   Y5, Y10, Y5
	VPSHUFB shuffle_rot24<>+0(SB), Y5, Y5
	VPADDQ  Y0, Y5, Y0
	VPADDQ  32(SP), Y0, Y0
	VPXOR   Y15, Y0, Y15
	VPSHUFB shuffle_rot16<>+0(SB), Y15, Y15
	VPADDQ  Y10, Y15, Y10
	VPXOR   Y5, Y10, Y5
	VPSRLQ  $0x3f, Y5, Y8
	VPSLLQ  $0x01, Y5, Y5
	VPOR    Y5, Y8, Y5
	VPADDQ  Y1, Y6, Y1
	VPXOR   Y12, Y1, Y12
	VPSHUFB shuffle_rot32<>+0(SB), Y12, Y12
	VPADDQ  Y11, Y12, Y11
	VPXOR   Y6, Y11, Y6
	VPSHUFB shuffle_rot24<>+0(SB), Y6, Y6
	VPADDQ  Y1, Y6, Y1
	VPXOR   Y12, Y1, Y12
	VPSHUFB shuffle_rot16<>+0(SB), Y12, Y12
	VPADDQ  Y11, Y12, Y11
	VPXOR   Y6, Y11, Y6
	VPSRLQ  $0x3f, Y6, Y8
	VPSLLQ  $0x01, Y6, Y6
	VPOR    Y6, Y8, Y6
	VPADDQ  Y2, Y7, Y2
	VPADDQ  192(SP), Y2, Y2
	VPXOR   Y13, Y2, Y13
	VPSHUFB shuffle_rot32<>+0(SB), Y13, Y13
	VPADDQ  288(SP), Y13, Y8
	VPXOR   Y7, Y8, Y7
	VPSHUFB shuffle_rot24<>+0(SB), Y7, Y7
	VPADDQ  Y2, Y7, Y2
	VPADDQ  256(SP), Y2, Y2
	VPXOR   Y13, Y2, Y13
	VPSHUFB shuffle_rot16<>+0(SB), Y13, Y13
	VPADDQ  Y8, Y13, Y8
	VPXOR   Y7, Y8, Y7
	VMOVDQU Y8, 288(SP)
	VPSRLQ  $0x3f, Y7, Y8
	VPSLLQ  $0x01, Y7, Y7
	VPOR    Y7, Y8, Y7
	VPADDQ  Y3, Y4, Y3
	VPADDQ  96(SP), Y3, Y3
	VPXOR   Y14, Y3, Y14
	VPSHUFB shuffle_rot32<>+0(SB), Y14, Y14
	VPADDQ  Y9, Y14, Y9
	VPXOR   Y4, Y9, Y4
	VPSHUFB shuffle_rot24<>+0(SB), Y4, Y4
	VPADDQ  Y3, Y4, Y3
	VPXOR   Y14, Y3, Y14
	VPSHUFB shuffle_rot16<>+0(SB), Y14, Y14
	VPADDQ  Y9, Y14, Y9
	VPXOR   Y4, Y9, Y4
	VPSRLQ  $0x3f, Y4, Y8
	VPSLLQ  $0x01, Y4, Y4
	VPOR    Y4, Y8, Y4

	// Round 6
	VPADDQ  Y0, Y4, Y0
	VPADDQ  64(SP), Y0, Y0
	VPXOR   Y12, Y0, Y12
	VPSHUFB shuffle_rot32<>+0(SB), Y12, Y12
	VPADDQ  288(SP), Y12, Y8
	VPXOR   Y4, Y8, Y4
	VPSHUFB shuffle_rot24<>+0(SB), Y4, Y4
	VPADDQ  Y0, Y4, Y0
	VPXOR   Y12, Y0, Y12
	VPSHUFB shuffle_rot16<>+0(SB), Y12, Y12
	VPADDQ  Y8, Y12, Y8
	VPXOR   Y4, Y8, Y4
	VMOVDQU Y8, 288(SP)
	VPSRLQ  $0x3f, Y4, Y8
	VPSLLQ  $0x01, Y4, Y4
	VPOR    Y4, Y8, Y4
	VPADDQ  Y1, Y5, Y1
	VPADDQ  192(SP), Y1, Y1
	VPXOR   Y13, Y1, Y13
	VPSHUFB shuffle_rot32<>+0(SB), Y13, Y13
	VPADDQ  Y9, Y13, Y9
	VPXOR   Y5, Y9, Y5
	VPSHUFB shuffle_rot24<>+0(SB), Y5, Y5
	VPADDQ  Y1, Y5, Y1
	VPXOR   Y13, Y1, Y13
	VPSHUFB shuffle_rot16<>+0(SB), Y13, Y13
	VPADDQ  Y9, Y13, Y9
	VPXOR   Y5, Y9, Y5
	VPSRLQ  $0x3f, Y5, Y8
	VPSLLQ  $0x01, Y5, Y5
	VPOR    Y5, Y8, Y5
	VPADDQ  Y2, Y6, Y2
	VPADDQ  (SP), Y2, Y2
	VPXOR   Y14, Y2, Y14
	VPSHUFB shuffle_rot32<>+0(SB), Y14, Y14
	VPADDQ  Y10, Y14, Y10
	VPXOR   Y6, Y10, Y6
	VPSHUFB shuffle_rot24<>+0(SB), Y6, Y6
	VPADDQ  Y2, Y6, Y2
	VPXOR   Y14, Y2, Y14
	VPSHUFB shuffle_rot16<>+0(SB), Y14, Y14
	VPADDQ  Y10, Y14, Y10
	VPXOR   Y6, Y10, Y6
	VPSRLQ  $0x3f, Y6, Y8
	VPSLLQ  $0x01, Y6, Y6
	VPOR    Y6, Y8, Y6
	VPADDQ  Y3, Y7, Y3
	VPADDQ  256(SP), Y3, Y3
	VPXOR   Y15, Y3, Y15
	VPSHUFB shuffle_rot32<>+0(SB), Y15, Y15
	VPADDQ  Y11, Y15, Y11
	VPXOR   Y7, Y11, Y7
	VPSHUFB shuffle_rot24<>+0(SB), Y7, Y7
	VPADDQ  Y3, Y7, Y3
	VPADDQ  96(SP), Y3, Y3
	VPXOR   Y15, Y3, Y15
	VPSHUFB shuffle_rot16<>+0(SB), Y15, Y15
	VPADDQ  Y11, Y15, Y11
	VPXOR   Y7, Y11, Y7
	VPSRLQ  $0x3f, Y7, Y8
	VPSLLQ  $0x01, Y7, Y7
	VPOR    Y7, Y8, Y7
	VPADDQ  Y0, Y5, Y0
	VPADDQ  128(SP), Y0, Y0
	VPXOR   Y15, Y0, Y15
	VPSHUFB shuffle_rot32<>+0(SB), Y15, Y15
	VPADDQ  Y10, Y15, Y10
	VPXOR   Y5, Y10, Y5
	VPSHUFB shuffle_rot24<>+0(SB), Y5, Y5
	VPADDQ  Y0, Y5, Y0
	VPXOR   Y15, Y0, Y15
	VPSHUFB shuffle_rot16<>+0(SB), Y15, Y15
	VPADDQ  Y10, Y15, Y10
	VPXOR   Y5, Y10, Y5
	VPSRLQ  $0x3f, Y5, Y8
	VPSLLQ  $0x01, Y5, Y5
	VPOR    Y5, Y8, Y5
	VPADDQ  Y1, Y6, Y1
	VPADDQ  224(SP), Y1, Y1
	VPXOR   Y12, Y1, Y12
	VPSHUFB shuffle_rot32<>+0(SB), Y12, Y12
	VPADDQ  Y11, Y12, Y11
	VPXOR   Y6, Y11, Y6
	VPSHUFB shuffle_rot24<>+0(SB), Y6, Y6
	VPADDQ  Y1, Y6, Y1
	VPADDQ  160(SP), Y1, Y1
	VPXOR   Y12, Y1, Y12
	VPSHUFB shuffle_rot16<>+0(SB), Y12, Y12
	VPADDQ  Y11, Y12, Y11
	VPXOR   Y6, Y11, Y6
	VPSRLQ  $0x3f, Y6, Y8
	VPSLLQ  $0x01, Y6, Y6
	VPOR    Y6, Y8, Y6
	VPADDQ  Y2, Y7, Y2
	VPXOR   Y13, Y2, Y13
	VPSHUFB shuffle_rot32<>+0(SB), Y13, Y13
	VPADDQ  288(SP), Y13, Y8
	VPXOR   Y7, Y8, Y7
	VPSHUFB shuffle_rot24<>+0(SB), Y7, Y7
	VPADDQ  Y2, Y7, Y2
	VPXOR   Y13, Y2, Y13
	VPSHUFB shuffle_rot16<>+0(SB), Y13, Y13
	VPADDQ  Y8, Y13, Y8
	VPXOR   Y7, Y8, Y7
	VMOVDQU Y8, 288(SP)
	VPSRLQ  $0x3f, Y7, Y8
	VPSLLQ  $0x01, Y7, Y7
	VPOR    Y7, Y8, Y7
	VPADDQ  Y3, Y4, Y3
	VPADDQ  32(SP), Y3, Y3
	VPXOR   Y14, Y3, Y14
	VPSHUFB shuffle_rot32<>+0(SB), Y14, Y14
	VPADDQ  Y9, Y14, Y9
	VPXOR   Y4, Y9, Y4
	VPSHUFB shuffle_rot24<>+0(SB), Y4, Y4
	VPADDQ  Y3, Y4, Y3
	VPXOR   Y14, Y3, Y14
	VPSHUFB shuffle_rot16<>+0(SB), Y14, Y14
	VPADDQ  Y9, Y14, Y9
	VPXOR   Y4, Y9, Y4
	VPSRLQ  $0x3f, Y4, Y8
	VPSLLQ  $0x01, Y4, Y4
	VPOR    Y4, Y8, Y4

	// Round 7
	VPADDQ  Y0, Y4, Y0
	VPXOR   Y12, Y0, Y12
	VPSHUFB shuffle_rot32<>+0(SB), Y12, Y12
	VPADDQ  288(SP), Y12, Y8
	VPXOR   Y4, Y8, Y4
	VPSHUFB shuffle_rot24<>+0(SB), Y4, Y4
	VPADDQ  Y0, Y4, Y0
	VPADDQ  160(SP), Y0, Y0
	VPXOR   Y12, Y0, Y12
	VPSHUFB shuffle_rot16<>+0(SB), Y12, Y12
	VPADDQ  Y8, Y12, Y8
	VPXOR   Y4, Y8, Y4
	VMOVDQU Y8, 288(SP)
	VPSRLQ  $0x3f, Y4, Y8
	VPSLLQ  $0x01, Y4, Y4
	VPOR    Y4, Y8, Y4
	VPADDQ  Y1, Y5, Y1
	VPADDQ  32(SP), Y1, Y1
	VPXOR   Y13, Y1, Y13
	VPSHUFB shuffle_rot32<>+0(SB), Y13, Y13
	VPADDQ  Y9, Y13, Y9
	VPXOR   Y5, Y9, Y5
	VPSHUFB shuffle_rot24<>+0(SB), Y5, Y5
	VPADDQ  Y1, Y5, Y1
	VPXOR   Y13, Y1, Y13
	VPSHUFB shuffle_rot16<>+0(SB), Y13, Y13
	VPADDQ  Y9, Y13, Y9
	VPXOR   Y5, Y9, Y5
	VPSRLQ  $0x3f, Y5, Y8
	VPSLLQ  $0x01, Y5, Y5
	VPOR    Y5, Y8, Y5
	VPADDQ  Y2, Y6, Y2
	VPXOR   Y14, Y2, Y14
	VPSHUFB shuffle_rot32<>+0(SB), Y14, Y14
	VPADDQ  Y10, Y14, Y10
	VPXOR   Y6, Y10, Y6
	VPSHUFB shuffle_rot24<>+0(SB), Y6, Y6
	VPADDQ  Y2, Y6, Y2
	VPXOR   Y14, Y2, Y14
	VPSHUFB shuffle_rot16<>+0(SB), Y14, Y14
	VPADDQ  Y10, Y14, Y10
	VPXOR   Y6, Y10, Y6
	VPSRLQ  $0x3f, Y6, Y8
	VPSLLQ  $0x01, Y6, Y6
	VPOR    Y6, Y8, Y6
	VPADDQ  Y3, Y7, Y3
	VPADDQ  128(SP), Y3, Y3
	VPXOR   Y15, Y3, Y15
	VPSHUFB shuffle_rot32<>+0(SB), Y15, Y15
	VPADDQ  Y11, Y15, Y11
	VPXOR   Y7, Y11, Y7
	VPSHUFB shuffle_rot24<>+0(SB), Y7, Y7
	VPADDQ  Y3, Y7, Y3
	VPXOR   Y15, Y3, Y15
	VPSHUFB shuffle_rot16<>+0(SB), Y15, Y15
	VPADDQ  Y11, Y15, Y11
	VPXOR   Y7, Y11, Y7
	VPSRLQ  $0x3f, Y7, Y8
	VPSLLQ  $0x01, Y7, Y7
	VPOR    Y7, Y8, Y7
	VPADDQ  Y0, Y5, Y0
	VPADDQ  (SP), Y0, Y0
	VPXOR   Y15, Y0, Y15
	VPSHUFB shuffle_rot32<>+0(SB), Y15, Y15
	VPADDQ  Y10, Y15, Y10
	VPXOR   Y5, Y10, Y5
	VPSHUFB shuffle_rot24<>+0(SB), Y5, Y5
	VPADDQ  Y0, Y5, Y0
	VPADDQ  224(SP), Y0, Y0
	VPXOR   Y15, Y0, Y15
	VPSHUFB shuffle_rot16<>+0(SB), Y15, Y15
	VPADDQ  Y10, Y15, Y10
	VPXOR   Y5, Y10, Y5
	VPSRLQ  $0x3f, Y5, Y8
	VPSLLQ  $0x01, Y5, Y5
	VPOR    Y5, Y8, Y5
	VPADDQ  Y1, Y6, Y1
	VPADDQ  192(SP), Y1, Y1
	VPXOR   Y12, Y1, Y12
	VPSHUFB shuffle_rot32<>+0(SB), Y12, Y12
	VPADDQ  Y11, Y12, Y11
	VPXOR   Y6, Y11, Y6
	VPSHUFB shuffle_rot24<>+0(SB), Y6, Y6
	VPADDQ  Y1, Y6, Y1
	VPADDQ  96(SP), Y1, Y1
	VPXOR   Y12, Y1, Y12
	VPSHUFB shuffle_rot16<>+0(SB), Y12, Y12
	VPADDQ  Y11, Y12, Y11
	VPXOR   Y6, Y11, Y6
	VPSRLQ  $0x3f, Y6, Y8
	VPSLLQ  $0x01, Y6, Y6
	VPOR    Y6, Y8, Y6
	VPADDQ  Y2, Y7, Y2
	VPXOR   Y13, Y2, Y13
	VPSHUFB shuffle_rot32<>+0(SB), Y13, Y13
	VPADDQ  288(SP), Y13, Y8
	VPXOR   Y7, Y8, Y7
	VPSHUFB shuffle_rot24<>+0(SB), Y7, Y7
	VPADDQ  Y2, Y7, Y2
	VPADDQ  64(SP), Y2, Y2
	VPXOR   Y13, Y2, Y13
	VPSHUFB shuffle_rot16<>+0(SB), Y13, Y13
	VPADDQ  Y8, Y13, Y8
	VPXOR   Y7, Y8, Y7
	VMOVDQU Y8, 288(SP)
	VPSRLQ  $0x3f, Y7, Y8
	VPSLLQ  $0x01, Y7, Y7
	VPOR    Y7, Y8, Y7
	VPADDQ  Y3, Y4, Y3
	VPADDQ  256(SP), Y3, Y3
	VPXOR   Y14, Y3, Y14
	VPSHUFB shuffle_rot32<>+0(SB), Y14, Y14
	VPADDQ  Y9, Y14, Y9
	VPXOR   Y4, Y9, Y4
	VPSHUFB shuffle_rot24<>+0(SB), Y4, Y4
	VPADDQ  Y3, Y4, Y3
	VPXOR   Y14, Y3, Y14
	VPSHUFB shuffle_rot16<>+0(SB), Y14, Y14
	VPADDQ  Y9, Y14, Y9
	VPXOR   Y4, Y9, Y4
	VPSRLQ  $0x3f, Y4, Y8
	VPSLLQ  $0x01, Y4, Y4
	VPOR    Y4, Y8, Y4

	// Round 8
	VPADDQ  Y0, Y4, Y0
	VPXOR   Y12, Y0, Y12
	VPSHUFB shuffle_rot32<>+0(SB), Y12, Y12
	VPADDQ  288(SP), Y12, Y8
	VPXOR   Y4, Y8, Y4
	VPSHUFB shuffle_rot24<>+0(SB), Y4, Y4
	VPADDQ  Y0, Y4, Y0
	VPXOR   Y12, Y0, Y12
	VPSHUFB shuffle_rot16<>+0(SB), Y12, Y12
	VPADDQ  Y8, Y12, Y8
	VPXOR   Y4, Y8, Y4
	VMOVDQU Y8, 288(SP)
	VPSRLQ  $0x3f, Y4, Y8
	VPSLLQ  $0x01, Y4, Y4
	VPOR    Y4, Y8, Y4
	VPADDQ  Y1, Y5, Y1
	VPADDQ  224(SP), Y1, Y1
	VPXOR   Y13, Y1, Y13
	VPSHUFB shuffle_rot32<>+0(SB), Y13, Y13
	VPADDQ  Y9, Y13, Y9
	VPXOR   Y5, Y9, Y5
	VPSHUFB shuffle_rot24<>+0(SB), Y5, Y5
	VPADDQ  Y1, Y5, Y1
	VPXOR   Y13, Y1, Y13
	VPSHUFB shuffle_rot16<>+0(SB), Y13, Y13
	VPADDQ  Y9, Y13, Y9
	VPXOR   Y5, Y9, Y5
	VPSRLQ  $0x3f, Y5, Y8
	VPSLLQ  $0x01, Y5, Y5
	VPOR    Y5, Y8, Y5
	VPADDQ  Y2, Y6, Y2
	VPXOR   Y14, Y2, Y14
	VPSHUFB shuffle_rot32<>+0(SB), Y14, Y14
	VPADDQ  Y10, Y14, Y10
	VPXOR   Y6, Y10, Y6
	VPSHUFB shuffle_rot24<>+0(SB), Y6, Y6
	VPADDQ  Y2, Y6, Y2
	VPADDQ  32(SP), Y2, Y2
	VPXOR   Y14, Y2, Y14
	VPSHUFB shuffle_rot16<>+0(SB), Y14, Y14
	VPADDQ  Y10, Y14, Y10
	VPXOR   Y6, Y10, Y6
	VPSRLQ  $0x3f, Y6, Y8
	VPSLLQ  $0x01, Y6, Y6
	VPOR    Y6, Y8, Y6
	VPADDQ  Y3, Y7, Y3
	VPADDQ  96(SP), Y3, Y3
	VPXOR   Y15, Y3, Y15
	VPSHUFB shuffle_rot32<>+0(SB), Y15, Y15
	VPADDQ  Y11, Y15, Y11
	VPXOR   Y7, Y11, Y7
	VPSHUFB shuffle_rot24<>+0(SB), Y7, Y7
	VPADDQ  Y3, Y7, Y3
	VPXOR   Y15, Y3, Y15
	VPSHUFB shuffle_rot16<>+0(SB), Y15, Y15
	VPADDQ  Y11, Y15, Y11
	VPXOR   Y7, Y11, Y7
	VPSRLQ  $0x3f, Y7, Y8
	VPSLLQ  $0x01, Y7, Y7
	VPOR    Y7, Y8, Y7
	VPADDQ  Y0, Y5, Y0
	VPADDQ  160(SP), Y0, Y0
	VPXOR   Y15, Y0, Y15
	VPSHUFB shuffle_rot32<>+0(SB), Y15, Y15
	VPADDQ  Y10, Y15, Y10
	VPXOR   Y5, Y10, Y5
	VPSHUFB shuffle_rot24<>+0(SB), Y5, Y5
	VPADDQ  Y0, Y5, Y0
	VPADDQ  (SP), Y0, Y0
	VPXOR   Y15, Y0, Y15
	VPSHUFB shuffle_rot16<>+0(SB), Y15, Y15
	VPADDQ  Y10, Y15, Y10
	VPXOR   Y5, Y10, Y5
	VPSRLQ  $0x3f, Y5, Y8
	VPSLLQ  $0x01, Y5, Y5
	VPOR    Y5, Y8, Y5
	VPADDQ  Y1, Y6, Y1
	VPXOR   Y12, Y1, Y12
	VPSHUFB shuffle_rot32<>+0(SB), Y12, Y12
	VPADDQ  Y11, Y12, Y11
	VPXOR   Y6, Y11, Y6
	VPSHUFB shuffle_rot24<>+0(SB), Y6, Y6
	VPADDQ  Y1, Y6, Y1
	VPADDQ  128(SP), Y1, Y1
	VPXOR   Y12, Y1, Y12
	VPSHUFB shuffle_rot16<>+0(SB), Y12, Y12
	VPADDQ  Y11, Y12, Y11
	VPXOR   Y6, Y11, Y6
	VPSRLQ  $0x3f, Y6, Y8
	VPSLLQ  $0x01, Y6, Y6
	VPOR    Y6, Y8, Y6
	VPADDQ  Y2, Y7, Y2
	VPADDQ  256(SP), Y2, Y2
	VPXOR   Y13, Y2, Y13
	VPSHUFB shuffle_rot32<>+0(SB), Y13, Y13
	VPADDQ  288(SP), Y13, Y8
	VPXOR   Y7, Y8, Y7
	VPSHUFB shuffle_rot24<>+0(SB), Y7, Y7
	VPADDQ  Y2, Y7, Y2
	VPADDQ  192(SP), Y2, Y2
	VPXOR   Y13, Y2, Y13
	VPSHUFB shuffle_rot16<>+0(SB), Y13, Y13
	VPADDQ  Y8, Y13, Y8
	VPXOR   Y7, Y8, Y7
	VMOVDQU Y8, 288(SP)
	VPSRLQ  $0x3f, Y7, Y8
	VPSLLQ  $0x01, Y7, Y7
	VPOR    Y7, Y8, Y7
	VPADDQ  Y3, Y4, Y3
	VPADDQ  64(SP), Y3, Y3
	VPXOR   Y14, Y3, Y14
	VPSHUFB shuffle_rot32<>+0(SB), Y14, Y14
	VPADDQ  Y9, Y14, Y9
	VPXOR   Y4, Y9, Y4
	VPSHUFB shuffle_rot24<>+0(SB), Y4, Y4
	VPADDQ  Y3, Y4, Y3
	VPXOR   Y14, Y3, Y14
	VPSHUFB shuffle_rot16<>+0(SB), Y14, Y14
	VPADDQ  Y9, Y14, Y9
	VPXOR   Y4, Y9, Y4
	VPSRLQ  $0x3f, Y4, Y8
	VPSLLQ  $0x01, Y4, Y4
	VPOR    Y4, Y8, Y4

	// Round 9
	VPADDQ  Y0, Y4, Y0
	VPADDQ  192(SP), Y0, Y0
	VPXOR   Y12, Y0, Y12
	VPSHUFB shuffle_rot32<>+0(SB), Y12, Y12
	VPADDQ  288(SP), Y12, Y8
	VPXOR   Y4, Y8, Y4
	VPSHUFB shuffle_rot24<>+0(SB), Y4, Y4
	VPADDQ  Y0, Y4, Y0
	VPXOR   Y12, Y0, Y12
	VPSHUFB shuffle_rot16<>+0(SB), Y12, Y12
	VPADDQ  Y8, Y12, Y8
	VPXOR   Y4, Y8, Y4
	VMOVDQU Y8, 288(SP)
	VPSRLQ  $0x3f, Y4, Y8
	VPSLLQ  $0x01, Y4, Y4
	VPOR    Y4, Y8, Y4
	VPADDQ  Y1, Y5, Y1
	VPXOR   Y13, Y1, Y13
	VPSHUFB shuffle_rot32<>+0(SB), Y13, Y13
	VPADDQ  Y9, Y13, Y9
	VPXOR   Y5, Y9, Y5
	VPSHUFB shuffle_rot24<>+0(SB), Y5, Y5
	VPADDQ  Y1, Y5, Y1
	VPXOR   Y13, Y1, Y13
	VPSHUFB shuffle_rot16<>+0(SB), Y13, Y13
	VPADDQ  Y9, Y13, Y9
	VPXOR   Y5, Y9, Y5
	VPSRLQ  $0x3f, Y5, Y8
	VPSLLQ  $0x01, Y5, Y5
	VPOR    Y5, Y8, Y5
	VPADDQ  Y2, Y6, Y2
	VPXOR   Y14, Y2, Y14
	VPSHUFB shuffle_rot32<>+0(SB), Y14, Y14
	VPADDQ  Y10, Y14, Y10
	VPXOR   Y6, Y10, Y6
	VPSHUFB shuffle_rot24<>+0(SB), Y6, Y6
	VPADDQ  Y2, Y6, Y2
	VPADDQ  96(SP), Y2, Y2
	VPXOR   Y14, Y2, Y14
	VPSHUFB shuffle_rot16<>+0(SB), Y14, Y14
	VPADDQ  Y10, Y14, Y10
	VPXOR   Y6, Y10, Y6
	VPSRLQ  $0x3f, Y6, Y8
	VPSLLQ  $0x01, Y6, Y6
	VPOR    Y6, Y8, Y6
	VPADDQ  Y3, Y7, Y3
	VPADDQ  (SP), Y3, Y3
	VPXOR   Y15, Y3, Y15
	VPSHUFB shuffle_rot32<>+0(SB), Y15, Y15
	VPADDQ  Y11, Y15, Y11
	VPXOR   Y7, Y11, Y7
	VPSHUFB shuffle_rot24<>+0(SB), Y7, Y7
	VPADDQ  Y3, Y7, Y3
	VPADDQ  256(SP), Y3, Y3
	VPXOR   Y15, Y3, Y15
	VPSHUFB shuffle_rot16<>+0(SB), Y15, Y15
	VPADDQ  Y11, Y15, Y11
	VPXOR   Y7, Y11, Y7
	VPSRLQ  $0x3f, Y7, Y8
	VPSLLQ  $0x01, Y7, Y7
	VPOR    Y7, Y8, Y7
	VPADDQ  Y0, Y5, Y0
	VPXOR   Y15, Y0, Y15
	VPSHUFB shuffle_rot32<>+0(SB), Y15, Y15
	VPADDQ  Y10, Y15, Y10
	VPXOR   Y5, Y10, Y5
	VPSHUFB shuffle_rot24<>+0(SB), Y5, Y5
	VPADDQ  Y0, Y5, Y0
	VPADDQ  64(SP), Y0, Y0
	VPXOR   Y15, Y0, Y15
	VPSHUFB shuffle_rot16<>+0(SB), Y15, Y15
	VPADDQ  Y10, Y15, Y10
	VPXOR   Y5, Y10, Y5
	VPSRLQ  $0x3f, Y5, Y8
	VPSLLQ  $0x01, Y5, Y5
	VPOR    Y5, Y8, Y5
	VPADDQ  Y1, Y6, Y1
	VPXOR   Y12, Y1, Y12
	VPSHUFB shuffle_rot32<>+0(SB), Y12, Y12
	VPADDQ  Y11, Y12, Y11
	VPXOR   Y6, Y11, Y6
	VPSHUFB shuffle_rot24<>+0(SB), Y6, Y6
	VPADDQ  Y1, Y6, Y1
	VPADDQ  224(SP), Y1, Y1
	VPXOR   Y12, Y1, Y12
	VPSHUFB shuffle_rot16<>+0(SB), Y12, Y12
	VPADDQ  Y11, Y12, Y11
	VPXOR   Y6, Y11, Y6
	VPSRLQ  $0x3f, Y6, Y8
	VPSLLQ  $0x01, Y6, Y6
	VPOR    Y6, Y8, Y6
	VPADDQ  Y2, Y7, Y2
	VPADDQ  32(SP), Y2, Y2
	VPXOR   Y13, Y2, Y13
	VPSHUFB shuffle_rot32<>+0(SB), Y13, Y13
	VPADDQ  288(SP), Y13, Y8
	VPXOR   Y7, Y8, Y7
	VPSHUFB shuffle_rot24<>+0(SB), Y7, Y7
	VPADDQ  Y2, Y7, Y2
	VPADDQ  128(SP), Y2, Y2
	VPXOR   Y13, Y2, Y13
	VPSHUFB shuffle_rot16<>+0(SB), Y13, Y13
	VPADDQ  Y8, Y13, Y8
	VPXOR   Y7, Y8, Y7
	VMOVDQU Y8, 288(SP)
	VPSRLQ  $0x3f, Y7, Y8
	VPSLLQ  $0x01, Y7, Y7
	VPOR    Y7, Y8, Y7
	VPADDQ  Y3, Y4, Y3
	VPXOR   Y14, Y3, Y14
	VPSHUFB shuffle_rot32<>+0(SB), Y14, Y14
	VPADDQ  Y9, Y14, Y9
	VPXOR   Y4, Y9, Y4
	VPSHUFB shuffle_rot24<>+0(SB), Y4, Y4
	VPADDQ  Y3, Y4, Y3
	VPADDQ  160(SP), Y3, Y3
	VPXOR   Y14, Y3, Y14
	VPSHUFB shuffle_rot16<>+0(SB), Y14, Y14
	VPADDQ  Y9, Y14, Y9
	VPXOR   Y4, Y9, Y4
	VPSRLQ  $0x3f, Y4, Y8
	VPSLLQ  $0x01, Y4, Y4
	VPOR    Y4, Y8, Y4

	// Round 10
	VPADDQ  Y0, Y4, Y0
	VPXOR   Y12, Y0, Y12
	VPSHUFB shuffle_rot32<>+0(SB), Y12, Y12
	VPADDQ  288(SP), Y12, Y8
	VPXOR   Y4, Y8, Y4
	VPSHUFB shuffle_rot24<>+0(SB), Y4, Y4
	VPADDQ  Y0, Y4, Y0
	VPADDQ  64(SP), Y0, Y0
	VPXOR   Y12, Y0, Y12
	VPSHUFB shuffle_rot16<>+0(SB), Y12, Y12
	VPADDQ  Y8, Y12, Y8
	VPXOR   Y4, Y8, Y4
	VMOVDQU Y8, 288(SP)
	VPSRLQ  $0x3f, Y4, Y8
	VPSLLQ  $0x01, Y4, Y4
	VPOR    Y4, Y8, Y4
	VPADDQ  Y1, Y5, Y1
	VPADDQ  256(SP), Y1, Y1
	VPXOR   Y13, Y1, Y13
	VPSHUFB shuffle_rot32<>+0(SB), Y13, Y13
	VPADDQ  Y9, Y13, Y9
	VPXOR   Y5, Y9, Y5
	VPSHUFB shuffle_rot24<>+0(SB), Y5, Y5
	VPADDQ  Y1, Y5, Y1
	VPADDQ  128(SP), Y1, Y1
	VPXOR   Y13, Y1, Y13
	VPSHUFB shuffle_rot16<>+0(SB), Y13, Y13
	VPADDQ  Y9, Y13, Y9
	VPXOR   Y5, Y9, Y5
	VPSRLQ  $0x3f, Y5, Y8
	VPSLLQ  $0x01, Y5, Y5
	VPOR    Y5, Y8, Y5
	VPADDQ  Y2, Y6, Y2
	VPADDQ  224(SP), Y2, Y2
	VPXOR   Y14, Y2, Y14
	VPSHUFB shuffle_rot32<>+0(SB), Y14, Y14
	VPADDQ  Y10, Y14, Y10
	VPXOR   Y6, Y10, Y6
	VPSHUFB shuffle_rot24<>+0(SB), Y6, Y6
	VPADDQ  Y2, Y6, Y2
	VPADDQ  192(SP), Y2, Y2
	VPXOR   Y14, Y2, Y14
	VPSHUFB shuffle_rot16<>+0(SB), Y14, Y14
	VPADDQ  Y10, Y14, Y10
	VPXOR   Y6, Y10, Y6
	VPSRLQ  $0x3f, Y6, Y8
	VPSLLQ  $0x01, Y6, Y6
	VPOR    Y6, Y8, Y6
	VPADDQ  Y3, Y7, Y3
	VPADDQ  32(SP), Y3, Y3
	VPXOR   Y15, Y3, Y15
	VPSHUFB shuffle_rot32<>+0(SB), Y15, Y15
	VPADDQ  Y11, Y15, Y11
	VPXOR   Y7, Y11, Y7
	VPSHUFB shuffle_rot24<>+0(SB), Y7, Y7
	VPADDQ  Y3, Y7, Y3
	VPADDQ  160(SP), Y3, Y3
	VPXOR   Y15, Y3, Y15
	VPSHUFB shuffle_rot16<>+0(SB), Y15, Y15
	VPADDQ  Y11, Y15, Y11
	VPXOR   Y7, Y11, Y7
	VPSRLQ  $0x3f, Y7, Y8
	VPSLLQ  $0x01, Y7, Y7
	VPOR    Y7, Y8, Y7
	VPADDQ  Y0, Y5, Y0
	VPXOR   Y15, Y0, Y15
	VPSHUFB shuffle_rot32<>+0(SB), Y15, Y15
	VPADDQ  Y10, Y15, Y10
	VPXOR   Y5, Y10, Y5
	VPSHUFB shuffle_rot24<>+0(SB), Y5, Y5
	VPADDQ  Y0, Y5, Y0
	VPXOR   Y15, Y0, Y15
	VPSHUFB shuffle_rot16<>+0(SB), Y15, Y15
	VPADDQ  Y10, Y15, Y10
	VPXOR   Y5, Y10, Y5
	VPSRLQ  $0x3f, Y5, Y8
	VPSLLQ  $0x01, Y5, Y5
	VPOR    Y5, Y8, Y5
	VPADDQ  Y1, Y6, Y1
	VPXOR   Y12, Y1, Y12
	VPSHUFB shuffle_rot32<>+0(SB), Y12, Y12
	VPADDQ  Y11, Y12, Y11
	VPXOR   Y6, Y11, Y6
	VPSHUFB shuffle_rot24<>+0(SB), Y6, Y6
	VPADDQ  Y1, Y6, Y1
	VPXOR   Y12, Y1, Y12
	VPSHUFB shuffle_rot16<>+0(SB), Y12, Y12
	VPADDQ  Y11, Y12, Y11
	VPXOR   Y6, Y11, Y6
	VPSRLQ  $0x3f, Y6, Y8
	VPSLLQ  $0x01, Y6, Y6
	VPOR    Y6, Y8, Y6
	VPADDQ  Y2, Y7, Y2
	VPADDQ  96(SP), Y2, Y2
	VPXOR   Y13, Y2, Y13
	VPSHUFB shuffle_rot32<>+0(SB), Y13, Y13
	VPADDQ  288(SP), Y13, Y8
	VPXOR   Y7, Y8, Y7
	VPSHUFB shuffle_rot24<>+0(SB), Y7, Y7
	VPADDQ  Y2, Y7, Y2
	VPXOR   Y13, Y2, Y13
	VPSHUFB shuffle_rot16<>+0(SB), Y13, Y13
	VPADDQ  Y8, Y13, Y8
	VPXOR   Y7, Y8, Y7
	VMOVDQU Y8, 288(SP)
	VPSRLQ  $0x3f, Y7, Y8
	VPSLLQ  $0x01, Y7, Y7
	VPOR    Y7, Y8, Y7
	VPADDQ  Y3, Y4, Y3
	VPXOR   Y14, Y3, Y14
	VPSHUFB shuffle_rot32<>+0(SB), Y14, Y14
	VPADDQ  Y9, Y14, Y9
	VPXOR   Y4, Y9, Y4
	VPSHUFB shuffle_rot24<>+0(SB), Y4, Y4
	VPADDQ  Y3, Y4, Y3
	VPADDQ  (SP), Y3, Y3
	VPXOR   Y14, Y3, Y14
	VPSHUFB shuffle_rot16<>+0(SB), Y14, Y14
	VPADDQ  Y9, Y14, Y9
	VPXOR   Y4, Y9, Y4
	VPSRLQ  $0x3f, Y4, Y8
	VPSLLQ  $0x01, Y4, Y4
	VPOR    Y4, Y8, Y4

	// Round 11
	VPADDQ  Y0, Y4, Y0
	VPADDQ  (SP), Y0, Y0
	VPXOR   Y12, Y0, Y12
	VPSHUFB shuffle_rot32<>+0(SB), Y12, Y12
	VPADDQ  288(SP), Y12, Y8
	VPXOR   Y4, Y8, Y4
	VPSHUFB shuffle_rot24<>+0(SB), Y4, Y4
	VPADDQ  Y0, Y4, Y0
	VPADDQ  32(SP), Y0, Y0
	VPXOR   Y12, Y0, Y12
	VPSHUFB shuffle_rot16<>+0(SB), Y12, Y12
	VPADDQ  Y8, Y12, Y8
	VPXOR   Y4, Y8, Y4
	VMOVDQU Y8, 288(SP)
	VPSRLQ  $0x3f, Y4, Y8
	VPSLLQ  $0x01, Y4, Y4
	VPOR    Y4, Y8, Y4
	VPADDQ  Y1, Y5, Y1
	VPADDQ  64(SP), Y1, Y1
	VPXOR   Y13, Y1, Y13
	VPSHUFB shuffle_rot32<>+0(SB), Y13, Y13
	VPADDQ  Y9, Y13, Y9
	VPXOR   Y5, Y9, Y5
	VPSHUFB shuffle_rot24<>+0(SB), Y5, Y5
	VPADDQ  Y1, Y5, Y1
	VPADDQ  96(SP), Y1, Y1
	VPXOR   Y13, Y1, Y13
	VPSHUFB shuffle_rot16<>+0(SB), Y13, Y13
	VPADDQ  Y9, Y13, Y9
	VPXOR   Y5, Y9, Y5
	VPSRLQ  $0x3f, Y5, Y8
	VPSLLQ  $0x01, Y5, Y5
	VPOR    Y5, Y8, Y5
	VPADDQ  Y2, Y6, Y2
	VPADDQ  128(SP), Y2, Y2
	VPXOR   Y14, Y2, Y14
	VPSHUFB shuffle_rot32<>+0(SB), Y14, Y14
	VPADDQ  Y10, Y14, Y10
	VPXOR   Y6, Y10, Y6
	VPSHUFB shuffle_rot24<>+0(SB), Y6, Y6
	VPADDQ  Y2, Y6, Y2
	VPADDQ  160(SP), Y2, Y2
	VPXOR   Y14, Y2, Y14
	VPSHUFB shuffle_rot16<>+0(SB), Y14, Y14
	VPADDQ  Y10, Y14, Y10
	VPXOR   Y6, Y10, Y6
	VPSRLQ  $0x3f, Y6, Y8
	VPSLLQ  $0x01, Y6, Y6
	VPOR    Y6, Y8, Y6
	VPADDQ  Y3, Y7, Y3
	VPADDQ  192(SP), Y3, Y3
	VPXOR   Y15, Y3, Y15
	VPSHUFB shuffle_rot32<>+0(SB), Y15, Y15
	VPADDQ  Y11, Y15, Y11
	VPXOR   Y7, Y11, Y7
	VPSHUFB shuffle_rot24<>+0(SB), Y7, Y7
	VPADDQ  Y3, Y7, Y3
	VPADDQ  224(SP), Y3, Y3
	VPXOR   Y15, Y3, Y15
	VPSHUFB shuffle_rot16<>+0(SB), Y15, Y15
	VPADDQ  Y11, Y15, Y11
	VPXOR   Y7, Y11, Y7
	VPSRLQ  $0x3f, Y7, Y8
	VPSLLQ  $0x01, Y7, Y7
	VPOR    Y7, Y8, Y7
	VPADDQ  Y0, Y5, Y0
	VPADDQ  256(SP), Y0, Y0
	VPXOR   Y15, Y0, Y15
	VPSHUFB shuffle_rot32<>+0(SB), Y15, Y15
	VPADDQ  Y10, Y15, Y10
	VPXOR   Y5, Y10, Y5
	VPSHUFB shuffle_rot24<>+0(SB), Y5, Y5
	VPADDQ  Y0, Y5, Y0
	VPXOR   Y15, Y0, Y15
	VPSHUFB shuffle_rot16<>+0(SB), Y15, Y15
	VPADDQ  Y10, Y15, Y10
	VPXOR   Y5, Y10, Y5
	VPSRLQ  $0x3f, Y5, Y8
	VPSLLQ  $0x01, Y5, Y5
	VPOR    Y5, Y8, Y5
	VPADDQ  Y1, Y6, Y1
	VPXOR   Y12, Y1, Y12
	VPSHUFB shuffle_rot32<>+0(SB), Y12, Y12
	VPADDQ  Y11, Y12, Y11
	VPXOR   Y6, Y11, Y6
	VPSHUFB shuffle_rot24<>+0(SB), Y6, Y6
	VPADDQ  Y1, Y6, Y1
	VPXOR   Y12, Y1, Y12
	VPSHUFB shuffle_rot16<>+0(SB), Y12, Y12
	VPADDQ  Y11, Y12, Y11
	VPXOR   Y6, Y11, Y6
	VPSRLQ  $0x3f, Y6, Y8
	VPSLLQ  $0x01, Y6, Y6
	VPOR    Y6, Y8, Y6
	VPADDQ  Y2, Y7, Y2
	VPXOR   Y13, Y2, Y13
	VPSHUFB shuffle_rot32<>+0(SB), Y13, Y13
	VPADDQ  288(SP), Y13, Y8
	VPXOR   Y7, Y8, Y7
	VPSHUFB shuffle_rot24<>+0(SB), Y7, Y7
	VPADDQ  Y2, Y7, Y2
	VPXOR   Y13, Y2, Y13
	VPSHUFB shuffle_rot16<>+0(SB), Y13, Y13
	VPADDQ  Y8, Y13, Y8
	VPXOR   Y7, Y8, Y7
	VMOVDQU Y8, 288(SP)
	VPSRLQ  $0x3f, Y7, Y8
	VPSLLQ  $0x01, Y7, Y7
	VPOR    Y7, Y8, Y7
	VPADDQ  Y3, Y4, Y3
	VPXOR   Y14, Y3, Y14
	VPSHUFB shuffle_rot32<>+0(SB), Y14, Y14
	VPADDQ  Y9, Y14, Y9
	VPXOR   Y4, Y9, Y4
	VPSHUFB shuffle_rot24<>+0(SB), Y4, Y4
	VPADDQ  Y3, Y4, Y3
	VPXOR   Y14, Y3, Y14
	VPSHUFB shuffle_rot16<>+0(SB), Y14, Y14
	VPADDQ  Y9, Y14, Y9
	VPXOR   Y4, Y9, Y4
	VPSRLQ  $0x3f, Y4, Y8
	VPSLLQ  $0x01, Y4, Y4
	VPOR    Y4, Y8, Y4

	// Round 12
	VPADDQ  Y0, Y4, Y0
	VPXOR   Y12, Y0, Y12
	VPSHUFB shuffle_rot32<>+0(SB), Y12, Y12
	VPADDQ  288(SP), Y12, Y8
	VPXOR   Y4, Y8, Y4
	VPSHUFB shuffle_rot24<>+0(SB), Y4, Y4
	VPADDQ  Y0, Y4, Y0
	VPXOR   Y12, Y0, Y12
	VPSHUFB shuffle_rot16<>+0(SB), Y12, Y12
	VPADDQ  Y8, Y12, Y8
	VPXOR   Y4, Y8, Y4
	VMOVDQU Y8, 288(SP)
	VPSRLQ  $0x3f, Y4, Y8
	VPSLLQ  $0x01, Y4, Y4
	VPOR    Y4, Y8, Y4
	VPADDQ  Y1, Y5, Y1
	VPADDQ  128(SP), Y1, Y1
	VPXOR   Y13, Y1, Y13
	VPSHUFB shuffle_rot32<>+0(SB), Y13, Y13
	VPADDQ  Y9, Y13, Y9
	VPXOR   Y5, Y9, Y5
	VPSHUFB shuffle_rot24<>+0(SB), Y5, Y5
	VPADDQ  Y1, Y5, Y1
	VPADDQ  256(SP), Y1, Y1
	VPXOR   Y13, Y1, Y13
	VPSHUFB shuffle_rot16<>+0(SB), Y13, Y13
	VPADDQ  Y9, Y13, Y9
	VPXOR   Y5, Y9, Y5
	VPSRLQ  $0x3f, Y5, Y8
	VPSLLQ  $0x01, Y5, Y5
	VPOR    Y5, Y8, Y5
	VPADDQ  Y2, Y6, Y2
	VPXOR   Y14, Y2, Y14
	VPSHUFB shuffle_rot32<>+0(SB), Y14, Y14
	VPADDQ  Y10, Y14, Y10
	VPXOR   Y6, Y10, Y6
	VPSHUFB shuffle_rot24<>+0(SB), Y6, Y6
	VPADDQ  Y2, Y6, Y2
	VPXOR   Y14, Y2, Y14
	VPSHUFB shuffle_rot16<>+0(SB), Y14, Y14
	VPADDQ  Y10, Y14, Y10
	VPXOR   Y6, Y10, Y6
	VPSRLQ  $0x3f, Y6, Y8
	VPSLLQ  $0x01, Y6, Y6
	VPOR    Y6, Y8, Y6
	VPADDQ  Y3, Y7, Y3
	VPXOR   Y15, Y3, Y15
	VPSHUFB shuffle_rot32<>+0(SB), Y15, Y15
	VPADDQ  Y11, Y15, Y11
	VPXOR   Y7, Y11, Y7
	VPSHUFB shuffle_rot24<>+0(SB), Y7, Y7
	VPADDQ  Y3, Y7, Y3
	VPADDQ  192(SP), Y3, Y3
	VPXOR   Y15, Y3, Y15
	VPSHUFB shuffle_rot16<>+0(SB), Y15, Y15
	VPADDQ  Y11, Y15, Y11
	VPXOR   Y7, Y11, Y7
	VPSRLQ  $0x3f, Y7, Y8
	VPSLLQ  $0x01, Y7, Y7
	VPOR    Y7, Y8, Y7
	VPADDQ  Y0, Y5, Y0
	VPADDQ  32(SP), Y0, Y0
	VPXOR   Y15, Y0, Y15
	VPSHUFB shuffle_rot32<>+0(SB), Y15, Y15
	VPADDQ  Y10, Y15, Y10
	VPXOR   Y5, Y10, Y5
	VPSHUFB shuffle_rot24<>+0(SB), Y5, Y5
	VPADDQ  Y0, Y5, Y0
	VPXOR   Y15, Y0, Y15
	VPSHUFB shuffle_rot16<>+0(SB), Y15, Y15
	VPADDQ  Y10, Y15, Y10
	VPXOR   Y5, Y10, Y5
	VPSRLQ  $0x3f, Y5, Y8
	VPSLLQ  $0x01, Y5, Y5
	VPOR    Y5, Y8, Y5
	VPADDQ  Y1, Y6, Y1
	VPADDQ  (SP), Y1, Y1
	VPXOR   Y12, Y1, Y12
	VPSHUFB shuffle_rot32<>+0(SB), Y12, Y12
	VPADDQ  Y11, Y12, Y11
	VPXOR   Y6, Y11, Y6
	VPSHUFB shuffle_rot24<>+0(SB), Y6, Y6
	VPADDQ  Y1, Y6, Y1
	VPADDQ  64(SP), Y1, Y1
	VPXOR   Y12, Y1, Y12
	VPSHUFB shuffle_rot16<>+0(SB), Y12, Y12
	VPADDQ  Y11, Y12, Y11
	VPXOR   Y6, Y11, Y6
	VPSRLQ  $0x3f, Y6, Y8
	VPSLLQ  $0x01, Y6, Y6
	VPOR    Y6, Y8, Y6
	VPADDQ  Y2, Y7, Y2
	VPXOR   Y13, Y2, Y13
	VPSHUFB shuffle_rot32<>+0(SB), Y13, Y13
	VPADDQ  288(SP), Y13, Y8
	VPXOR   Y7, Y8, Y7
	VPSHUFB shuffle_rot24<>+0(SB), Y7, Y7
	VPADDQ  Y2, Y7, Y2
	VPADDQ  224(SP), Y2, Y2
	VPXOR   Y13, Y2, Y13
	VPSHUFB shuffle_rot16<>+0(SB), Y13, Y13
	VPADDQ  Y8, Y13, Y8
	VPXOR   Y7, Y8, Y7
	VMOVDQU Y8, 288(SP)
	VPSRLQ  $0x3f, Y7, Y8
	VPSLLQ  $0x01, Y7, Y7
	VPOR    Y7, Y8, Y7
	VPADDQ  Y3, Y4, Y3
	VPADDQ  160(SP), Y3, Y3
	VPXOR   Y14, Y3, Y14
	VPSHUFB shuffle_rot32<>+0(SB), Y14, Y14
	VPADDQ  Y9, Y14, Y9
	VPXOR   Y4, Y9, Y4
	VPSHUFB shuffle_rot24<>+0(SB), Y4, Y4
	VPADDQ  Y3, Y4, Y3
	VPADDQ  96(SP), Y3, Y3
	VPXOR   Y14, Y3, Y14
	VPSHUFB shuffle_rot16<>+0(SB), Y14, Y14
	VPADDQ  Y9, Y14, Y9
	VPXOR   Y4, Y9, Y4
	VPSRLQ  $0x3f, Y4, Y8
	VPSLLQ  $0x01, Y4, Y4
	VPOR    Y4, Y8, Y4

	// Finalize
	VMOVDQU      288(SP), Y8
	VPXOR        Y0, Y8, Y0
	VPBROADCASTQ init_state<>+0(SB), Y8
	VPXOR        Y0, Y8, Y0
	VPXOR        Y1, Y9, Y1
	VPBROADCASTQ init_state<>+8(SB), Y9
	VPXOR        Y1, Y9, Y1
	VPXOR        Y2, Y10, Y2
	VPBROADCASTQ init_state<>+16(SB), Y10
	VPXOR        Y2, Y10, Y2
	VPXOR        Y3, Y11, Y3
	VPBROADCASTQ init_state<>+24(SB), Y11
	VPXOR        Y3, Y11, Y3

	// Transpose state vectors into outs
	VPUNPCKLQDQ Y1, Y0, Y4
	VPUNPCKHQDQ Y1, Y0, Y5
	VPUNPCKLQDQ Y3, Y2, Y6
	VPUNPCKHQDQ Y3, Y2, Y7
	VINSERTI128 $0x01, X6, Y4, Y0
	VINSERTI128 $0x01, X7, Y5, Y1
	VPERM2I128  $0x31, Y6, Y4, Y2
	VPERM2I128  $0x31, Y7, Y5, Y3
	VMOVDQU     Y0, (CX)
	VMOVDQU     Y1, 32(CX)
	VMOVDQU     Y2, 64(CX)
	VMOVDQU     Y3, 96(CX)
	// Clear the upper YMM registers to avoid performance penalties
	VZEROUPPER
	RET
