package main

import (
	"bytes"
	"strings"
	"testing"

	"go.sia.tech/core/types"
)

func TestWriteTemplate(t *testing.T) {
	buf := bytes.NewBuffer(nil)

	err := writeTemplate(buf, map[types.BlockID][]types.FileContractID{
		{1, 2, 3}: {
			types.FileContractID{4, 5, 6},
			types.FileContractID{7, 8, 9},
		},
	})
	if err != nil {
		t.Fatalf("writeTemplate failed: %v", err)
	}
	expected := `// Code generated by calcswaps; DO NOT EDIT.
package chain

import (
	"go.sia.tech/core/types"
)

var defaultExpiringFileContractOrder = map[types.BlockID][]types.FileContractID{types.BlockID{0x1, 0x2, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}:[]types.FileContractID{types.FileContractID{0x4, 0x5, 0x6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, types.FileContractID{0x7, 0x8, 0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}}}
`

	if strings.TrimSpace(buf.String()) != strings.TrimSpace(expected) {
		t.Errorf("writeTemplate output mismatch:\nexpected:\n%s\n\ngot:\n%s", expected, buf.String())
	}
}
