---
title: .NET Core API Reference 
description: .NET Core API Reference 
keywords: .NET, .NET Core, .NET Core API Reference, .NET Core class library, .NET class library
author: rpetrusha
ms.author: ronpet
ms.date: 06/20/2016
ms.topic: managed-reference
ms.prod: .net-core
ms.devlang: dotnet
ms.assetid: ab0b8c9f-925f-4c45-b337-b1deeb8aec4e
---

# .NET Core API Reference

## Namespaces in the .NET Core Class Library ##

The following is a list of namespaces in the .NET Core class library. Each namespace contains a set of functionally-related types.

<table class="table table-bordered table-striped table-condensed">
<thead>
   <tr>
      <th>Namespace</th>
      <th>Description</th>
   </tr>
</thead>
<tr>
   <td>@Microsoft.CSharp.RuntimeBinder </td>
   <td>Provides types that support interoperation between the Dynamic Language Runtime and C#.
    </td>
</tr>
<tr>
   <td>@Microsoft.SqlServer.Server </td>
   <td>Contains classes for integrating .NET Core with Microsoft SQL Server and the SQL Server database engine process execution environment.
    </td>
</tr>
<tr>
   <td>@Microsoft.VisualBasic </td>
   <td>
   Contains types that support the Visual Basic runtime.
    </td>
</tr>
<tr>
   <td>@Microsoft.VisualBasic.CompilerServices </td>
   <td>
   Contains internal-use only types that support the Visual Basic compiler.
    </td>
</tr>
<tr>
   <td>@Microsoft.Win32 </td>
   <td>
   Contains classes that manipulate the Windows system registry.
    </td>
</tr>
<tr>
   <td>@Microsoft.Win32.SafeHandles </td>
   <td>
   Contains classes that support safe access to Windows file and operating system handles.
    </td>
</tr>
<tr>
   <td>@System </td>
   <td>
   Contains fundamental classes and base classes that define commonly-used value and reference data types, events and event handlers, interfaces, attributes, and exceptions.
    </td>
</tr>
<tr>
   <td>@System.CodeDom.Compiler </td>
   <td>
   Contains a type used to identify code that is auto-generated by a tool. 
    </td>
</tr>
<tr>
   <td>@System.Collections </td>
   <td>
   Contains classes and interfaces that define various non-generic collections of objects, such as lists, queues, bit arrays, hash tables and dictionaries.
    </td>
</tr>
<tr>
   <td>@System.Collections.Concurrent </td>
   <td>
   Provides thread-safe collection classes that should be used instead of the corresponding types in the System.Collections and System.Collections.Generic namespaces whenever multiple threads are accessing the collection concurrently. However, members accessed through extension methods or through the interfaces that these collection classes implement are not guaranteed to be thread safe and may need to be synchronized by the caller.
    </td>
</tr>
<tr>
   <td>@System.Collections.Generic </td>
   <td>
   Contains types that define generic collections, which allow users to create strongly-typed collections that provide better type safety and performance than non-generic collections.
    </td>
</tr>
<tr>
   <td>@System.Collections.ObjectModel </td>
   <td>
   Contains classes that can be used as collections in the object model of a reusable library. Use these classes when properties or methods return collections.
    </td>
</tr>
<tr>
   <td>@System.Collections.Specialized </td>
   <td>
   Contains specialized and strongly-typed collections such as a linked list dictionary, a bit vector, and collections that contain only strings.
    </td>
</tr>
<tr>
   <td>@System.ComponentModel </td>
   <td>
   Contains classes that are used to implement the run-time and design-time behavior of components and controls. This namespace includes the base classes and interfaces for implementing attributes and type converters and binding to data sources.
    </td>
</tr>
<tr>
   <td>@System.ComponentModel.DataAnnotations </td>
   <td>
   Contains attribute classes that are used to define metadata for ASP.NET Core data controls. 
    </td>
</tr>
<tr>
   <td>@System.ComponentModel.DataAnnotations.Schema </td>
   <td>
   Provides support for attribute classes that are used to define metadata for ASP.NET Core data controls.
    </td>
</tr>
<tr>
   <td>@System.Data </td>
   <td>
   Provides access to classes that efficiently manage data from multiple data sources.
    </td>
</tr>
<tr>
   <td>@System.Data.Common </td>
   <td>
   Contains classes shared by the .NET Core data providers.
    </td>
</tr>
<tr>
   <td>@System.Data.SqlClient </td>
   <td>
   The data provider for Microsoft SQL Server.
    </td>
</tr>
<tr>
   <td>@System.Data.SqlTypes </td>
   <td>
   Contains classes for native data types in SQL Server. These classes provide a safer, faster alternative to the primitive data types provided in the System namespace. Using the classes in this namespace helps prevent type conversion errors caused by loss of precision. Because other data types are converted to and from SqlTypes behind the scenes, explicitly creating and using objects within this namespace also yields faster code.
    </td>
</tr>
<tr>
   <td>@System.Diagnostics </td>
   <td>
   Contains classes that allow you to interact with system processes, event logs, and performance counters.
    </td>
</tr>
<tr>
   <td>@System.Diagnostics.CodeAnalysis </td>
   <td>
   Contains a class to suppress reporting of a specific rule violation by a static analysis tool.
    </td>
</tr>
<tr>
   <td>@System.Diagnostics.Contracts </td>
   <td>
   Contains static classes for representing program contracts such as preconditions, postconditions, and invariants.
    </td>
</tr>
<tr>
   <td>@System.Diagnostics.Tracing </td>
   <td>
   Provides types and members that enable you to create strongly-typed events to be captured by Event Tracing for Windows (ETW). 
    </td>
</tr>
<tr>
   <td>@System.Drawing </td>
   <td>
   Provides access to basic graphics functionality. 
    </td>
</tr>
<tr>
   <td>@System.Dynamic </td>
   <td>
   Provides classes and interfaces that support the Dynamic Language Runtime.
    </td>
</tr>
<tr>
   <td>@System.Globalization </td>
   <td>
   Contains classes that define culture-related information, including language, country/region, calendars in use, format patterns for dates, currency, and numbers, and sort order for strings. These classes are useful for writing globalized (internationalized) applications. 
    </td>
</tr>
<tr>
   <td>@System.IO </td>
   <td>
   Contains types that allow reading and writing to files and data streams, and types that provide basic file and directory support.
    </td>
</tr>
<tr>
   <td>@System.IO.Compression </td>
   <td>
   Contains types that provide basic compression and decompression services for streams. 
    </td>
</tr>
<tr>
   <td>@System.IO.IsolatedStorage </td>
   <td>
   Contains types that allow the creation and use of isolated stores. Isolated stores let you read and write data that less trusted code cannot access, and prevent the exposure of sensitive information that can be saved elsewhere on the file system. Data is stored in compartments that are isolated by the current user and by the assembly in which the code exists. Roaming profiles can be used in conjunction with isolated storage so that isolated stores travel with the user's profile. 
    </td>
</tr>
<tr>
   <td>@System.IO.MemoryMappedFiles </td>
   <td>
   Contains classes for using a memory-mapped file, which maps the contents of a file to an application’s logical address space. 
    </td>
</tr>
<tr>
   <td>@System.IO.Packaging </td>
   <td>
   Contains types that support storage of multiple data objects in a single container.
    </td>
</tr>
<tr>
   <td>@System.IO.Pipes </td>
   <td>
   Contains types for interprocess communication through anonymous and/or named pipes.
    </td>
</tr>
<tr>
   <td>@System.Linq </td>
   <td>
   Contains types that support queries that use Language-Integrated Query (LINQ).
    </td>
</tr>
<tr>
   <td>@System.Linq.Expressions </td>
   <td>
   Contains types that enable language-level code expressions to be represented as objects in the form of expression trees.
    </td>
</tr>
<tr>
   <td>@System.Net </td>
   <td>
   Provides a simple programming interface for many of the protocols used on networks today.   
    </td>
</tr>
<tr>
   <td>@System.Net.Http </td>
   <td>
   Provides a programming interface for modern HTTP applications.
    </td>
</tr>
<tr>
   <td>@System.Net.Http.Headers </td>
   <td>
   Provides support for collections of HTTP headers used by the @System.Net.Http namespace.
    </td>
</tr>
<tr>
   <td>@System.Net.NetworkInformation </td>
   <td>
   Provides access to network traffic data, network address information, and notification of address changes for the local computer. The namespace also contains classes that implement the @System.Net.NetworkInformation.Ping utility. You can use Ping and related classes to check whether a computer is reachable across the network.
    </td>
</tr>
<tr>
   <td>@System.Net.Security </td>
   <td>
   Provides network streams for secure communications between hosts.
    </td>
</tr>
<tr>
   <td>@System.Net.Sockets </td>
   <td>
   Provides a managed sockets implementation for developers who need to tightly control access to the network.
    </td>
</tr>
<tr>
   <td>@System.Net.WebSockets </td>
   <td>
   Provides a managed implementation of the WebSocket interface for developers.
    </td>
</tr>
<tr>
   <td>@System.Numerics </td>
   <td>
   Contains numeric types that complement the numeric primitives (such as Byte, Double, and Int32) that are available in .NET Core.
    </td>
</tr>
<tr>
   <td>@System.Reflection </td>
   <td>
   Contains types that retrieve information at runtime about assemblies, modules, members, parameters, and other entities in managed code by examining their metadata. These types also can be used to manipulate instances of loaded types, for example to hook up events or to invoke methods. 
    </td>
</tr>
<tr>
   <td>@System.Reflection.Context </td>
   <td>
   Contains  single class that can be used to create a customized reflection context.
    </td>
</tr>
<tr>
   <td>@System.Reflection.Emit </td>
   <td>
   Contains classes that can emit metadata and Microsoft intermediate language (MSIL) and optionally generate a PE file on disk. The primary clients of these classes are script engines and compilers.
    </td>
</tr>
<tr>
   <td>@System.Reflection.Metadata </td>
   <td>
   Contains a class with single extension method that retrieves raw metadata from an assembly. 
    </td>
</tr>
<tr>
   <td>@System.Resources </td>
   <td>
   Contains classes that allow developers to create, store, and retrieve culture-specific string resources used in an application. One of its most important classes is the @System.Resources.ResourceManager class.
    </td>
</tr>
<tr>
   <td>@System.Runtime </td>
   <td>
   Contains types that control the operation of the runtime's garbage collector.   
    </td>
</tr>
<tr>
   <td>@System.Runtime.CompilerServices </td>
   <td>
   Provides functionality for compiler writers who use managed code to specify attributes in metadata that affect the run-time behavior of the runtime.
    </td>
</tr>
<tr>
   <td>@System.Runtime.ExceptionServices </td>
   <td>
   Contains a single class to represent an exception whose state is captured at a certain point in code. 
    </td>
</tr>
<tr>
   <td>@System.Runtime.InteropServices </td>
   <td>
   Provides a wide variety of members that support COM interop and platform invoke services. 
    </td>
</tr>
<tr>
   <td>@System.Runtime.InteropServices.ComTypes </td>
   <td>
   Contains types that represent COM interfaces and data used in COM function calls.
    </td>
</tr>
<tr>
   <td>@System.Runtime.InteropServices.WindowsRuntime </td>
   <td>
   Contains types that support interoperation between managed code and the Windows Runtime, and that enable the creation of Windows Runtime types with managed code. 
    </td>
</tr>
<tr>
   <td>@System.Runtime.Loader </td>
   <td>
   Contains a single class that represents an assembly's load context.
    </td>
</tr>
<tr>
   <td>@System.Runtime.Serialization </td>
   <td>
   Contains classes that can be used for serializing and deserializing objects. Serialization converts an object or a graph of objects into a linear sequence of bytes for either storage or transmission to another location. Deserialization recreates objects from this stored information.
    </td>
</tr>
<tr>
   <td>@System.Runtime.Serialization.Json </td>
   <td>
   Provides classes related to JSON serialization.
    </td>
</tr>
<tr>
   <td>@System.Runtime.Versioning </td>
   <td>
   Contains advanced types that support versioning in side-by-side implementations of the .NET Platform Standard.
    </td>
</tr>
<tr>
   <td>@System.Security </td>
   <td>
   Provides the underlying structure of the runtime's security system, including base classes for permissions.
    </td>
</tr>
<tr>
   <td>@System.Security.AccessControl </td>
   <td>
   Provides programmatic elements that control access to and audit security-related actions on securable objects.
    </td>
</tr>
<tr>
   <td>@System.Security.Authentication </td>
   <td>
   Contains authentication exception types and a set of enumerations that describe the security of a connection. 
    </td>
</tr>
<tr>
   <td>@System.Security.Authentication.ExtendedProtection </td>
   <td>
   Provides support for authentication using extended protection for applications. 
    </td>
</tr>
<tr>
   <td>@System.Security.Claims </td>
   <td>
   Contains classes that implement claims-based identity, including classes that represent claims, claims-based identities, and claims-based principals.
    </td>
</tr>
<tr>
   <td>@System.Security.Cryptography </td>
   <td>
   Provides cryptographic services, including secure encoding and decoding of data, as well as many other operations, such as hashing, random number generation, and message authentication. 
    </td>
</tr>
<tr>
   <td>@System.Security.Cryptography.Pkcs </td>
   <td>
   Provides programming elements for Public Key Cryptography Standards (PKCS), including methods for signing data, exchanging keys, requesting certificates, public key encryption and decryption, and other security functions.
    </td>
</tr>
<tr>
   <td>@System.Security.Cryptography.X509Certificates </td>
   <td>
   Contains the runtime's implementation of the Authenticode X.509 v.3 certificate. This certificate is signed with a private key that uniquely and positively identifies the holder of the certificate.
    </td>
</tr>
<tr>
   <td>@System.Security.Cryptography.Xml </td>
   <td>
   Contains a single type that represents the <b>&lt;X509IssuerSerial&gt;</b> element of an XML digital signature.
    </td>
</tr>
<tr>
   <td>@System.Security.Principal </td>
   <td>
   Defines a principal object that represents the security context under which code is running.  
    </td>
</tr>
<tr>
   <td>@System.ServiceModel </td>
   <td>
   Provides classes related to the service model.
    </td>
</tr>
<tr>
   <td>@System.ServiceModel.Channels </td>
   <td>
   Provides classes related to service model channels.
    </td>
</tr>
<tr>
   <td>@System.ServiceModel.Description </td>
   <td>
   Provides classes related to the service model description.
    </td>
</tr>
<tr>
   <td>@System.ServiceModel.Dispatcher </td>
   <td>
   Provides classes related to dispatching the service model.
    </td>
</tr>
<tr>
   <td>@System.ServiceModel.Security </td>
   <td>
   Deals with general security-related topics.
    </td>
</tr>
<tr>
   <td>@System.ServiceModel.Security.Tokens </td>
   <td>
   Deals with security tokens and certificates.
    </td>
</tr>
<tr>
   <td>@System.ServiceProcess </td>
   <td>
   Provides types that allow you to connect to and control a Windows service application. Windows services are long-running executables with no user interface. 
    </td>
</tr>
<tr>
   <td>@System.Text </td>
   <td>
   Contains classes that represent ASCII and Unicode character encodings; abstract base classes for converting blocks of characters to and from blocks of bytes; and a helper class that manipulates and formats @System.String objects without creating intermediate @System.String instances.
    </td>
</tr>
<tr>
   <td>@System.Text.RegularExpressions </td>
   <td>
   Contains classes that represent the .NET regular expression engine, which allows you to search text for particular patterns. 
    </td>
</tr>
<tr>
   <td>@System.Threading </td>
   <td>
   Provides types that enable multithreaded programming. In addition to classes for synchronizing thread activities and access to data (such as @System.Threading.Mutex, @System.Threading.Monitor, @System.Threading.Interlocked, and [AutoResetEvent](xref:System.Threading.AutoResetEvent)), this namespace includes a @System.Threading.ThreadPool class that allows you to use a pool of system-supplied threads, and a @System.Threading.Timer class that executes callback methods on thread pool threads.
    </td>
</tr>
<tr>
   <td>@System.Threading.Tasks </td>
   <td>
   Provides types that simplify the work of writing concurrent and asynchronous code. The main types are @System.Threading.Tasks.Task, which represents an asynchronous operation that can be waited on and canceled, and @System.Threading.Tasks.Task%601, which is a task that can return a value. 
    </td>
</tr>
<tr>
   <td>@System.Windows.Input </td>
   <td>
   Defines a single interface, @System.Windows.Input.ICommand, that can be used to provide the commanding behavior for UI elements in Windows Runtime apps.
    </td>
</tr>
<tr>
   <td>@System.Xml </td>
   <td>
   Provides standards-based support for processing XML.
    </td>
</tr>
<tr>
   <td>@System.Xml.Linq </td>
   <td>
   Contains types that support LINQ to XML, an in-memory XML programming interface that lets you modify XML documents efficiently and easily.
    </td>
</tr>
<tr>
   <td>@System.Xml.Schema </td>
   <td>
   Contains types that provide standards-based support for <a href="http://www.w3.org/TR/xmlschema-0/">XML Schema Definition Language (XSD)</a> schemas.
    </td>
</tr>
<tr>
   <td>@System.Xml.Serialization </td>
   <td>
   Contains types that are used to serialize objects into XML format documents or streams.
    </td>
</tr>
<tr>
   <td>@System.Xml.XPath </td>
   <td>
   Contains types that define a cursor model for navigating and editing XML information items as instances of the <a href="http://www.w3.org/TR/xpath-datamodel/">XQuery 1.0 and XPath 2.0 Data Model</a>.
    </td>
</tr>
<tr>
   <td>@System.Xml.Xsl </td>
   <td>
   Provides support for Extensible Stylesheet Transformation (XSLT) transforms. It supports the <a href="http://www.w3.org/TR/xslt">W3C XSL Transformations (XSLT) Version 1.0 Recommendation</a>.
    </td>
</tr>
<tr>
   <td>@Windows.Foundation </td>
   <td>
   Contains some basic types used in Universal Windows Platform apps. 
    </td>
</tr>
<tr>
   <td>@Windows.UI </td>
   <td>
   Contains a @Windows.UI.Color type used in Universal Windows Platform apps.
    </td>
</tr>
<tr>
   <td>@Windows.UI.Xaml </td>
   <td>
   Contains XAML-related types used in Universal Windows Platform apps. 
    </td>
</tr>
<tr>
   <td>@Windows.UI.Xaml.Automation </td>
   <td>
   Contains exception types for exceptions thrown by routines that implement UI automation support for custom controls in Universal Windows Platform apps.  
    </td>
</tr>
<tr>
   <td>@Windows.UI.Xaml.Controls.Primitives </td>
   <td>
   Contains a single type, @Windows.UI.Xaml.Controls.Primitives.GeneratorPosition, that describes the position of an item in a Universal Windows Platform app.
    </td>
</tr>
<tr>
   <td>@Windows.UI.Xaml.Markup </td>
   <td>
   Contains an exception type that represents a Xaml parsing error.
    </td>
</tr>
<tr>
   <td>@Windows.UI.Xaml.Media </td>
   <td>
   Contains a single type, @Windows.UI.Xaml.Media.Matrix, which represents a 3 × 3 affine transformation matrix used for transformations in two-dimensional space in Universal Windows Platform apps.
    </td>
</tr>
<tr>
   <td>@Windows.UI.Xaml.Media.Animation </td>
   <td>
   Contains types that provide information about transition animations or animated UI components in Universal Windows Platform apps.
    </td>
</tr>
<tr>
   <td>@Windows.UI.Xaml.Media.Media3D </td>
   <td>
   Contains a single type, @Windows.UI.Xaml.Media.Media3D.Matrix3D, that represents a 4 × 4 matrix used for transformations in a 3-D space in Universal Windows Platform apps. 
    </td>
</tr>
</table> 

## Improving the Documentation ##

If you find an issue or an inconsistency, we would love to hear about it! Go to the [.NET docs repo](https://github.com/dotnet/docs/) on Github, and open an issue to let us know.
