---
title: "Compiler Error CS0518 | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "error-reference"
f1_keywords: 
  - "CS0518"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0518"
ms.assetid: b0b61cbb-c9a7-48c9-9e60-7cdd5ecb3e6c
caps.latest.revision: 8
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Compiler Error CS0518
Predefined type 'type' is not defined or imported  
  
 The main cause for this problem is that the project is not importing mscorlib.dll, which defines the entire System namespace. This can be caused by one of the following:  
  
-   The [/nostdlib](../../../csharp/language-reference/compiler-options/nostdlib-compiler-option.md) option from the command line compiler has been specified. The /nostdlib option prevents the import of mscorlib.dll. Use this option if you want to define or create a user-specific System namespace.  
  
-   An incorrect mscorlib.dll is referenced.  
  
-   A corrupt Visual Studio .NET or .NET Framework common language runtime installation exists.  
  
-   Residual components from an earlier installation that are incompatible with the latest installation remain.  
  
 To resolve this problem, take one of the following actions:  
  
-   Do not specify the /nostdlib option from the command line compiler.  
  
-   Make sure that the project refers to the correct mscorlib.dll.  
  
-   Reinstall the .NET Framework common language runtime (if the previous solutions do not solve the problem).