---
title: "Compiler Error CS1941 | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "error-reference"
f1_keywords: 
  - "CS1941"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS1941"
ms.assetid: 503054d6-9553-4a2a-9b68-4ccfdeccca22
caps.latest.revision: 7
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Compiler Error CS1941
The type of one of the expressions in the 'clause' clause is incorrect. Type inference failed in the call to 'method'.  
  
 Type inference in query expressions flows from the type of the elements in the data source(s).  
  
## To correct this error  
  
1.  If it is not immediately obvious why the error is occurring, examine the query carefully and trace the type of the result of each clause from the data source to the point where the error is occurring.  
  
## Example  
 The following code generates CS1941 because the `equals` operator is being asked to compare an `int` to a `string`.  
  
```  
// cs1941.cs  
using System.Collections;  
using System.Linq;  
class Test  
{  
    static int Main()  
    {  
        var nums = new[] { 1, 2, 3, 4, 5, 6 };  
        var words = new string[] { "lake", "mountain", "sky" };  
        IEnumerable e = from n in nums  
                        join w in words on n equals w // CS1941  
                        select w;  
        return 0;  
    }  
}  
```  
  
 The method in which type inference fails is the method that the query clause is translated to at compile time.  
  
## See Also  
 [LINQ Query Expressions](../../../csharp/programming-guide/linq-query-expressions/index.md)   
 [Type Relationships in LINQ Query Operations](../../../csharp/programming-guide/concepts/linq/type-relationships-in-linq-query-operations.md)