---
title: "Contextual Keywords (C# Reference) | Microsoft Docs"
ms.date: "2017-03-07"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "article"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "contextual keywords [C#]"
ms.assetid: 7c76bc29-a754-4389-b0ab-f6b441018298
caps.latest.revision: 19
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Contextual Keywords (C# Reference)
A contextual keyword is used to provide a specific meaning in the code, but it is not a reserved word in C#. The following contextual keywords are introduced in this section:  
  
|Keyword|Description|  
|-------------|-----------------|  
|[add](../../../csharp/language-reference/keywords/add.md)|Defines a custom event accessor that is invoked when client code subscribes to the event.|  
|[async](../../../csharp/language-reference/keywords/async.md)|Indicates that the modified method, lambda expression, or anonymous method is asynchronous.|  
|[await](../../../csharp/language-reference/keywords/await.md)|Suspends an async method until an awaited task is completed.|  
|[dynamic](../../../csharp/language-reference/keywords/dynamic.md)|Defines a reference type that enables operations in which it occurs to bypass compile-time type checking.|  
|[get](../../../csharp/language-reference/keywords/get.md)|Defines an accessor method for a property or an indexer.|  
|[global](../../../csharp/language-reference/keywords/global.md)|Specifies the default global namespace, which is otherwise unnamed.|  
|[partial](../../../csharp/language-reference/keywords/partial-type.md)|Defines partial classes, structs, and interfaces throughout the same compilation unit.|  
|[remove](../../../csharp/language-reference/keywords/remove.md)|Defines a custom event accessor that is invoked when client code unsubscribes from the event.|  
|[set](../../../csharp/language-reference/keywords/set.md)|Defines an accessor method for a property or an indexer.|  
|[value](../../../csharp/language-reference/keywords/value.md)|Used to set accessors and to add or remove event handlers.|  
|[var](../../../csharp/language-reference/keywords/var.md)|Enables the type of a variable declared at method scope to be determined by the compiler.|  
|[when](when.md)|Specifies a filter condition for a `catch` block or the `case` label of a `switch` statement.|
|[where](../../../csharp/language-reference/keywords/where-generic-type-constraint.md)|Adds constraints to a generic declaration. (See also [where](../../../csharp/language-reference/keywords/where-clause.md)).|  
|[yield](../../../csharp/language-reference/keywords/yield.md)|Used in an iterator block to return a value to the enumerator object or to signal the end of iteration.|  
  
 All query keywords introduced in C# 3.0 are also contextual. For more information, see [Query Keywords (LINQ)](../../../csharp/language-reference/keywords/query-keywords.md).  
  
## See Also  
 [C# Reference](../../../csharp/language-reference/index.md)   
 [C# Programming Guide](../../../csharp/programming-guide/index.md)   
 [C# Keywords](../../../csharp/language-reference/keywords/index.md)