---
title: "Value Types Table (C# Reference) | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "article"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "value types [C#], table"
  - "Visual C#, types"
  - "types [C#], value types"
  - "types [C#], suffixes"
ms.assetid: 67d8f631-b6e3-4d83-9910-5ec497f8c5f3
caps.latest.revision: 11
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Value Types Table (C# Reference)
The following table lists the C# value types by category.  
  
|Value type|Category|Type Suffix|  
|----------------|--------------|-----------------|  
|[bool](../../../csharp/language-reference/keywords/bool.md)|Boolean||  
|[byte](../../../csharp/language-reference/keywords/byte.md)|Unsigned, numeric, integral||  
|[char](../../../csharp/language-reference/keywords/char.md)|Unsigned, numeric, integral||  
|[decimal](../../../csharp/language-reference/keywords/decimal.md)|Numeric, decimal|M or m|  
|[double](../../../csharp/language-reference/keywords/double.md)|Numeric, floating-point|D or d|  
|[enum](../../../csharp/language-reference/keywords/enum.md)|Enumeration||  
|[float](../../../csharp/language-reference/keywords/float.md)|Numeric, floating-point|F or f|  
|[int](../../../csharp/language-reference/keywords/int.md)|Signed, numeric, integral||  
|[long](../../../csharp/language-reference/keywords/long.md)|Signed, numeric, integral|L or l|  
|[sbyte](../../../csharp/language-reference/keywords/sbyte.md)|Signed, numeric, integral||  
|[short](../../../csharp/language-reference/keywords/short.md)|Signed, numeric, integral||  
|[struct](../../../csharp/language-reference/keywords/struct.md)|User-defined structure||  
|[uint](../../../csharp/language-reference/keywords/uint.md)|Unsigned, numeric, integral|U or u|  
|[ulong](../../../csharp/language-reference/keywords/ulong.md)|Unsigned, numeric, integral|UL or ul|  
|[ushort](../../../csharp/language-reference/keywords/ushort.md)|Unsigned, numeric, integral||  
  
## See Also  
 [C# Reference](../../../csharp/language-reference/index.md)   
 [C# Programming Guide](../../../csharp/programming-guide/index.md)   
 [Default Values Table](../../../csharp/language-reference/keywords/default-values-table.md)   
 [Value Types](../../../csharp/language-reference/keywords/value-types.md)   
 [Formatting Numeric Results Table](../../../csharp/language-reference/keywords/formatting-numeric-results-table.md)   
 [Reference Tables for Types](../../../csharp/language-reference/keywords/reference-tables-for-types.md)