---
title: "Compiler Error CS0065 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0065"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0065"
ms.assetid: 49ca30a8-513a-40ed-aa0c-eb696a25b91f
caps.latest.revision: 7
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0065
'event' : event property must have both add and remove accessors  
  
 An event that is not a field must have both access methods.  
  
 The following sample generates CS0065:  
  
```  
// CS0065.cs  
using System;  
public delegate void Eventhandler(object sender, int e);  
public class MyClass  
{  
   public event EventHandler Click   // CS0065,  
   {  
      // to fix, uncomment the add and remove definitions  
      /*  
      add  
      {  
         Click += value;  
      }  
      remove  
      {  
         Click -= value;  
      }  
      */  
   }  
  
   public static void Main()  
   {  
   }  
}  
```  
  
## See Also  
 [Events](../../csharp/programming-guide/events/index.md)