---
title: "Compiler Error CS0213 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0213"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0213"
ms.assetid: 3c1d55e3-2b84-4c28-8206-ef65869a898c
caps.latest.revision: 11
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0213
You cannot use the fixed statement to take the address of an already fixed expression  
  
 A local variable in an [unsafe](../../csharp/language-reference/keywords/unsafe.md) method or a parameter is already fixed (on the stack), so you cannot take the address of either of these two variables in a [fixed](../../csharp/language-reference/keywords/fixed-statement.md) expression. For more information, see [Unsafe Code and Pointers](../../csharp/programming-guide/unsafe-code-pointers/index.md).  
  
## Example  
 The following sample generates CS0213.  
  
```  
// CS0213.cs  
// compile with: /unsafe  
public class MyClass  
{  
   unsafe public static void Main()  
   {  
      int i = 45;  
      fixed (int *j = &i) { }  // CS0213  
      // try the following line instead  
      // int* j = &i;  
  
      int[] a = new int[] {1,2,3};  
      fixed (int *b = a)  
      {  
         fixed (int *c = b) { }  // CS0213  
         // try the following line instead  
         // int *c = b;  
      }  
   }  
}  
```