---
title: "Compiler Error CS0758 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0758"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0758"
ms.assetid: 06ddd548-1311-40db-9078-8a18107b8346
caps.latest.revision: 5
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0758
Both partial method declarations must use a params parameter or neither may use a params parameter  
  
 If one part of a partial method specifies a `params` parameter, the other part must specify one also.  
  
## To correct this error  
  
1.  Either add the `params` modifier in one part of the method, or remove it in the other.  
  
## Example  
 The following code generates CS0758:  
  
```  
using System;  
  
    public partial class C  
    {  
        partial void Part(int i, params char[] array);  
        partial void Part(int i, char[] array) // CS0758  
        {  
        }  
  
        public static int Main()  
        {  
            return 1;  
        }  
  
    }  
```  
  
## See Also  
 [Partial Classes and Methods](../../csharp/programming-guide/classes-and-structs/partial-classes-and-methods.md)   
 [params](../../csharp/language-reference/keywords/params.md)