---
title: "Compiler Error CS0759 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0759"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0759"
ms.assetid: 96f0e178-adbf-4327-8934-ac282c428184
caps.latest.revision: 4
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0759
No defining declaration found for implementing declaration of partial method 'method'.  
  
 A partial method must have a defining declaration that defines the signature (name, return type and parameters) of the method. The implementation or method body is optional.  
  
## To correct this error  
  
1.  Provide a defining declaration for the partial method in the other part of a partial class or struct.  
  
## Example  
 The following example generates CS0759:  
  
```  
// cs0759.cs  
using System;  
  
    public partial class C  
    {  
        partial void Part() // CS0759  
        {  
        }  
  
        public static int Main()  
        {  
            return 1;  
        }  
    }  
```  
  
## See Also  
 [Partial Classes and Methods](../../csharp/programming-guide/classes-and-structs/partial-classes-and-methods.md)