---
title: "Compiler Error CS1632 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS1632"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS1632"
ms.assetid: fa18061a-8c6c-4788-b74e-62bacb16aed8
caps.latest.revision: 8
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS1632
Control cannot leave the body of an anonymous method or lambda expression  
  
 This error occurs if a jump statement (**break**, `goto`, **continue**, etc.) attempts to move control out of an anonymous method block. An anonymous method block is a function body and can only be exited by a return statement or by reaching the end of the block.  
  
 The following sample generates CS1632:  
  
```  
// CS1632.cs  
// compile with: /target:library  
delegate void MyDelegate();  
class MyClass  
{  
   public void Test()  
   {        
      for (int i = 0 ; i < 5 ; i++)  
      {  
         MyDelegate d = delegate {  
            break;   // CS1632  
          };          
      }  
   }  
}  
```