---
title: "Compiler Warning (level 4) CS1712 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS1712"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS1712"
ms.assetid: d9a8be26-c0ba-41fa-b082-1ce4ba7724b7
caps.latest.revision: 9
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Warning (level 4) CS1712
Type parameter 'type parameter' has no matching typeparam tag in the XML comment on 'type' (but other type parameters do)  
  
 The documentation of a generic type is missing a **typeparam** tag. For more information, see [\<typeparam>](../../csharp/programming-guide/xmldoc/typeparam.md).  
  
## Example  
 The following code generates warning CS1712. To resolve this error, add a **typeparam** tag for the type parameter S.  
  
```  
// CS1712.cs  
// compile with: /doc:cs1712.xml  
using System;  
class Test  
{  
    public static void Main() {}  
    /// <param name="j"> This is the j parameter.</param>  
    /// <typeparam name="T"> This is the T type parameter.</typeparam>  
    public void bar<T,S>(int j) {}  // CS1712  
}  
```