---
title: "Compiler Warning (level 1) CS1720 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS1720"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS1720"
ms.assetid: 97adc294-3a4c-4418-a4ed-ccff43125b62
caps.latest.revision: 14
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Warning (level 1) CS1720
Expression will always cause a System.NullReferenceException because the default value of 'generic type' is null  
  
 If you write an expression involving the default of a generic type variable that is a reference type (for example, a class), this error will occur. Consider the following expression:  
  
```  
default(T).ToString()  
```  
  
 Since `T` is a reference type, its default value is null, and so attempting to apply the <xref:System.Object.ToString%2A> method to it will throw a <xref:System.NullReferenceException>.  
  
## Example  
 The class reference constraint on type `T` ensures that `T` is a reference type.  
  
 The following sample generates CS1720.  
  
```  
// CS1720.cs  
using System;  
public class Tester   
{  
    public static void GenericClass<T>(T t1) where T : class   
    {  
        Console.WriteLine(default(T).ToString());  // CS1720  
    }  
    public static void Main() {}  
}  
```