---
title: "Compiler Warning (level 1) CS1911 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS1911"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS1911"
ms.assetid: 95e8a7a0-1c19-4930-a7e9-3ae4060e97d3
caps.latest.revision: 5
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Warning (level 1) CS1911
Access to member 'name' through a 'base' keyword from an anonymous method, lambda expression, query expression, or iterator results in unverifiable code. Consider moving the access into a helper method on the containing type.  
  
 Calling virtual functions with the `base` keyword inside the method body of an iterator or anonymous methods will result in unverifiable code. Unverifiable code will fail to run in a partial trust environment.  
  
 One resolution for CS1911 is to move the virtual function call to a helper function.  
  
## Example  
 The following sample generates CS1911.  
  
```  
// CS1911.cs  
// compile with: /W:1  
using System;  
  
delegate void D();  
delegate D RetD();  
  
class B {  
   protected virtual void M() {  
      Console.WriteLine("B.M");  
   }  
}  
  
class Der : B {  
   protected override void M() {  
      Console.WriteLine("D.M");  
   }  
  
   void Test() { base.M(); }  
   D Test2() { return new D(base.M); }  
  
   public D CallBaseM() {  
      return delegate () { base.M(); };   // CS1911  
  
      // try the following line instead  
      // return delegate () { Test(); };  
   }  
  
   public RetD DelToBaseM() {  
      return delegate () { return new D(base.M); };   // CS1911  
  
      // try the following line instead  
      // return delegate () { return Test2(); };  
   }  
}  
  
class Program {  
   public static void Main() {  
      Der der = new Der();  
      D d = der.CallBaseM();  
      d();  
      RetD rd = der.DelToBaseM();  
      rd()();  
   }  
}  
```