---
title: "Compiler Warning (Level 1) CS1957 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS1957"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS1957"
ms.assetid: a4823211-52ce-4ffa-b19b-ee874069409f
caps.latest.revision: 5
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Warning (Level 1) CS1957
Member 'name' overrides 'method'. There are multiple override candidates at run-time. It is implementation dependent which method will be called.  
  
 Method parameters that vary only by whether they are `ref` or `out` cannot be differentiated at run-time.  
  
### To avoid this warning  
  
1.  Give one of the methods a different name or different number of parameters.  
  
## Example  
 The following code generates CS1957:  
  
```  
// cs1957.cs  
class Base<T, S>  
{  
    public virtual string Test(out T x) // CS1957  
    {  
        x = default(T);  
        return "Base.Test";  
    }  
    public virtual void Test(ref S x) { }  
}  
  
class Derived : Base<int, int>  
{  
    public override string Test(out int x)  
    {  
        x = 0;  
        return "Derived.Test";  
    }  
  
    static int Main()  
    {  
        int x;  
        if (new Derived().Test(out x) == "Derived.Test")  
            return 0;  
        return 1;  
    }  
}  
```