---
title: "Command-Line Arguments (C# Programming Guide) | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "command-line arguments [C#]"
ms.assetid: 0e597e0d-ea7a-41ba-a38a-0198122f3c26
caps.latest.revision: 27
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Command-Line Arguments (C# Programming Guide)
You can send arguments to the `Main` method by defining the method in one of the following ways:  
  
 [!code-cs[csProgGuideMain#2](../../../csharp/programming-guide/inside-a-program/codesnippet/CSharp/command-line-arguments_1.cs)]  
  
 [!code-cs[csProgGuideMain#3](../../../csharp/programming-guide/inside-a-program/codesnippet/CSharp/command-line-arguments_2.cs)]  
  
> [!NOTE]
>  To enable command-line arguments in the `Main` method in a Windows Forms application, you must manually modify the signature of `Main` in program.cs. The code generated by the Windows Forms designer creates a `Main` without an input parameter. You can also use <xref:System.Environment.CommandLine%2A?displayProperty=fullName> or <xref:System.Environment.GetCommandLineArgs%2A?displayProperty=fullName> to access the command-line arguments from any point in a console or Windows application.  
  
 The parameter of the `Main` method is a <xref:System.String> array that represents the command-line arguments. Usually you determine whether arguments exist by testing the `Length` property, for example:  
  
 [!code-cs[csProgGuideMain#4](../../../csharp/programming-guide/inside-a-program/codesnippet/CSharp/command-line-arguments_3.cs)]  
  
 You can also convert the string arguments to numeric types by using the <xref:System.Convert> class or the `Parse` method. For example, the following statement converts the `string` to a `long` number by using the <xref:System.Int64.Parse%2A> method:  
  
```  
long num = Int64.Parse(args[0]);  
```  
  
 It is also possible to use the C# type `long`, which aliases `Int64`:  
  
```  
long num = long.Parse(args[0]);  
```  
  
 You can also use the `Convert` class method `ToInt64` to do the same thing:  
  
```  
long num = Convert.ToInt64(s);  
```  
  
 For more information, see <xref:System.Int64.Parse%2A> and <xref:System.Convert>.  
  
## Example  
 The following example shows how to use command-line arguments in a console application. The application takes one argument at run time, converts the argument to an integer, and calculates the factorial of the number. If no arguments are supplied, the application issues a message that explains the correct usage of the program.  
  
 To compile and run the application from a command prompt, follow these steps:  
  
1.  Paste the following code into any text editor, and then save the file as  a text file with the name `Factorial.cs`.  
  
     [!code-cs[csProgGuideMain#16](../../../csharp/programming-guide/inside-a-program/codesnippet/CSharp/command-line-arguments_4.cs)]  
  
2.  From the **Start** screen or **Start** menu, open a Visual Studio **Developer Command Prompt** window, and then navigate to the folder that contains the file that you just created.  
  
3.  Enter the following command to compile the application.  
  
     `csc Factorial.cs`  
  
     If your application has no compilation errors, an executable file that's named `Factorial.exe` is created.  
  
4.  Enter the following command to calculate the factorial of 3:  
  
     `Factorial 3`  
  
5.  The command produces this output: `The factorial of 3 is 6.`  
  
> [!NOTE]
>  When running an application in Visual Studio, you can specify command-line arguments in the [Debug Page, Project Designer](https://docs.microsoft.com/visualstudio/ide/reference/debug-page-project-designer).  
  
 For more examples about how to use command-line arguments, see [How to: Create and Use Assemblies Using the Command Line](http://msdn.microsoft.com/library/70f65026-3687-4e9c-ab79-c18b97dd8be4).  
  
## See Also  
 <xref:System.Environment?displayProperty=fullName>   
 [C# Programming Guide](../../../csharp/programming-guide/index.md)   
 [Main() and Command-Line Arguments](../../../csharp/programming-guide/main-and-command-args/index.md)   
 [How to: Display Command Line Arguments](../../../csharp/programming-guide/main-and-command-args/how-to-display-command-line-arguments.md)   
 [How to: Access Command-Line Arguments Using foreach](../../../csharp/programming-guide/main-and-command-args/how-to-access-command-line-arguments-using-foreach.md)   
 [Main() Return Values](../../../csharp/programming-guide/main-and-command-args/main-return-values.md)   
 [Classes](../../../csharp/programming-guide/classes-and-structs/classes.md)