---
title: XML Documentation (F#)
description: XML Documentation (F#)
keywords: visual f#, f#, functional programming
author: cartermp
ms.author: phcart
ms.date: 05/16/2016
ms.topic: language-reference
ms.prod: .net
ms.technology: devlang-fsharp
ms.devlang: fsharp
ms.assetid: d99ab1b6-e170-4ec2-a543-43ea7ab15bb2 
---

# XML Documentation

You can produce documentation from triple-slash (///) code comments in F#. XML comments can precede declarations in code files (.fs) or signature (.fsi) files.


## Generating Documentation from Comments
The support in F# for generating documentation from comments is the same as that in other .NET Framework languages. As in other .NET Framework languages, the [-doc compiler option](https://msdn.microsoft.com/library/434394ae-0d4a-459c-a684-bffede519a04) enables you to produce an XML file that contains information that you can convert into documentation by using a tool such as Sandcastle. The documentation generated by using tools that are designed for use with assemblies that are written in other .NET Framework languages generally produce a view of the APIs that is based on the compiled form of F# constructs. Unless tools specifically support F#, documentation generated by these tools does not match the F# view of an API.

For more information about how to generate documentation from XML, see [XML Documentation Comments &#40;C&#35; Programming Guide&#41;](https://msdn.microsoft.com/library/b2s063f7).


## Recommended Tags
There are two ways to write XML documentation comments. One is to just write the documentation directly in a triple-slash comment, without using XML tags. If you do this, the entire comment text is taken as the summary documentation for the code construct that immediately follows. Use this method when you want to write only a brief summary for each construct. The other method is to use XML tags to provide more structured documentation. The second method enables you to specify separate notes for a short summary, additional remarks, documentation for each parameter and type parameter and exceptions thrown, and a description of the return value. The following table describes XML tags that are recognized in F# XML code comments.



|Tag syntax|Description|
|----------|-----------|
|**&lt;c&gt;***text***&lt;/c&gt;**|Specifies that *text* is code. This tag can be used by documentation generators to display text in a font that is appropriate for code.|
|**&lt;summary&gt;***text***&lt;/summary&gt;**|Specifies that *text* is a brief description of the program element. The description is usually one or two sentences.|
|**&lt;remarks&gt;***text***&lt;/remarks&gt;**|Specifies that *text* contains supplementary information about the program element.|
|**&lt;param name="***name***"&gt;***description***&lt;/param&gt;**|Specifies the name and description for a function or method parameter.|
|**&lt;typeparam name="***name***"&gt;***description***&lt;/typeparam&gt;**|Specifies the name and description for a type parameter.|
|**&lt;returns&gt;***text***&lt;/returns&gt;**|Specifies that *text* describes the return value of a function or method.|
|**&lt;exception cref="***type***"&gt;***description***&lt;/exception&gt;**|Specifies the type of exception that can be generated and the circumstances under which it is thrown.|
|**&lt;see cref="***reference***"&gt;***text***&lt;/see&gt;**|Specifies an inline link to another program element. The *reference* is the name as it appears in the XML documentation file. The *text* is the text shown in the link.|
|**&lt;seealso cref="***reference***"/&gt;**|Specifies a See Also link to the documentation for another type. The *reference* is the name as it appears in the XML documentation file. See Also links usually appear at the bottom of a documentation page.|
|**&lt;para&gt;***text***&lt;/para&gt;**|Specifies a paragraph of text. This is used to separate text inside the **remarks** tag.|

## Example

### Description
The following is a typical XML documentation comment in a signature file.


### Code
[!code-fsharp[Main](../../../samples/snippets/fsharp/lang-ref-2/snippet7101.fs)]
    
## Example

### Description
The following example shows the alternative method, without XML tags. In this example, the entire text in the comment is considered a summary. Note that if you do not specify a summary tag explicitly, you should not specify other tags, such as **param** or **returns** tags.


### Code
[!code-fsharp[Main](../../../samples/snippets/fsharp/lang-ref-2/snippet7102.fs)]
    
## See Also
[F# Language Reference](index.md)

[Compiler Options](compiler-options.md)
