---
title: Getting Started with .NET
description: Lists various articles for getting started with .NET, both from a language and platform perspective.
keywords: .NET, Getting Started, C#, F#, Visual Basic
author: cartermp
ms.author: mairaw
ms.date: 11/16/2016
ms.topic: article
ms.prod: .net
ms.technology: dotnet-standard
ms.devlang: dotnet
ms.assetid: 81c07080-acdf-4aef-a66d-0ab52fab2c04
---

# Getting Started

There are a number of ways to get started with .NET.  Because .NET is a massive platform, there are multiple articles in this documentation which show how you can get started with .NET, each from a different perspective.

## Getting started using .NET languages

* The [C# Getting Started](../csharp/getting-started/index.md) articles and [C# Tutorials](../csharp/tutorials/index.md) provide a number of ways to get started in a C#-centric way.

* The [F# Getting Started](../fsharp/tutorials/getting-started/index.md) tutorials provide three primary ways you can use F#: with Visual Studio, Visual Studio Code, or command-line tools.

* The [Visual Basic Getting Started](../visual-basic/getting-started/index.md) articles provide guides for using Visual Basic in Visual Studio, and provide a number of other learning resources.

## Getting started using .NET core

* [Getting Started with .NET Core](../core/getting-started.md) provides an overview of articles which show how to get started with .NET Core on different operating systems and using different tools.

* The [.NET Core Tutorials](../core/tutorials/index.md) detail a number of ways you can get started with .NET Core using your operating system and tooling of choice.

## Getting started using Docker on .NET Framework

The [Docker on .NET Framework](../framework/docker/index.md) shows how you can use .NET Framework on Windows Docker containers.