---
title: "Explicit initialization is not permitted with multiple variables declared with a single type specifier | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "bc30671"
  - "vbc30671"
helpviewer_keywords: 
  - "BC30671"
ms.assetid: 57bbdd58-b58d-4144-8fa6-366a7167df27
caps.latest.revision: 9
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Explicit initialization is not permitted with multiple variables declared with a single type specifier
Initialization is not allowed when multiple variables are declared on the same line.  
  
 **Error ID:** BC30671  
  
## To correct this error  
  
1.  Declare and initialize each item separately.  
  
2.  Declare multiple items together and then initialize each item; for example:  
  
    ```  
    Dim x, b, i As Integer  
    x = 9 : b = 9 : i = 9   
    ' ":" is the same as a new line.  
    ```  
  
## See Also  
 [Dim Statement](../../visual-basic/language-reference/statements/dim-statement.md)   
 [Variable Declaration](../../visual-basic/programming-guide/language-features/variables/variable-declaration.md)