---
title: "&#39;TryCast&#39; operands must be class-constrained type parameters, but &#39;&lt;typeparametername&gt;&#39; has no class constraint | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "BC30793"
  - "vbc30793"
helpviewer_keywords: 
  - "BC30793"
ms.assetid: a38a1da9-4413-4a69-a2ce-0b6d51c2c4ef
caps.latest.revision: 9
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# &#39;TryCast&#39; operands must be class-constrained type parameters, but &#39;&lt;typeparametername&gt;&#39; has no class constraint
The [TryCast Operator](../../visual-basic/language-reference/operators/trycast-operator.md) operator is used with a type parameter operand that is not guaranteed to be a reference type.  
  
 `TryCast` operates only on reference types, such as classes or interfaces. When you pass a type parameter as an argument to `TryCast`, you must constrain that type parameter to be a reference type. You can do this by including one or more of the following in the type parameter's constraint list:  
  
-   One or more interface names (the type argument must implement all of them)  
  
-   At most one class name (the type argument must inherit from it)  
  
-   The [New Operator](../../visual-basic/language-reference/operators/new-operator.md) constraint (the type argument must expose a parameterless constructor that the creating code can access, and therefore it must be a class)  
  
-   The [Class (Visual Basic)](http://msdn.microsoft.com/en-us/0777c6e6-46bc-451b-ad70-57b49d4ef4f7) constraint (the type argument must be a reference type)  
  
 **Error ID:** BC30793  
  
## To correct this error  
  
-   If you need to pass this type parameter to `TryCast`, constrain it with one or more of the constraints in the preceding list.  
  
-   If you cannot require the type parameter to accept only a reference type, you cannot use it with `TryCast`. You might be able to use the [CType Function](../../visual-basic/language-reference/functions/ctype-function.md) instead.  
  
## See Also  
 [Generic Types in Visual Basic](../../visual-basic/programming-guide/language-features/data-types/generic-types.md)   
 [Type List](../../visual-basic/language-reference/statements/type-list.md)   
 [Value Types and Reference Types](../../visual-basic/programming-guide/language-features/data-types/value-types-and-reference-types.md)   
 [Widening and Narrowing Conversions](../../visual-basic/programming-guide/language-features/data-types/widening-and-narrowing-conversions.md)   
 [Implicit and Explicit Conversions](../../visual-basic/programming-guide/language-features/data-types/implicit-and-explicit-conversions.md)