---
title: "None of the accessible &#39;Main&#39; methods with the appropriate signatures found in &#39;&lt;typename&gt;&#39; can be the startup method since they are either generic or nested in generic types | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "vbc30796"
  - "BC30796"
helpviewer_keywords: 
  - "BC30796"
ms.assetid: 606b3629-5a92-4c79-ace2-a530cab8c978
caps.latest.revision: 12
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# None of the accessible &#39;Main&#39; methods with the appropriate signatures found in &#39;&lt;typename&gt;&#39; can be the startup method since they are either generic or nested in generic types
A class, module, or structure does not have any `Main` procedure that qualifies as the project startup procedure.  
  
 Visual Basic requires that the startup procedure for a project must not be dependent on type arguments. Therefore, it must be able to access at least one `Main` procedure that is neither generic nor contained in any generic type.  
  
 **Error ID:** BC30796  
  
## To correct this error  
  
-   Define at least one of the `Main` procedures so that it is not generic and is not contained in a generic type.  
  
     -or-  
  
-   On the **Properties** page for your project, specify a different form or module for the **Startup form** or **Startup object**.  
  
## See Also  
 [NIB How to: Modify Project Properties and Configuration Settings](http://msdn.microsoft.com/en-us/e7184bc5-2f2b-4b4f-aa9a-3ecfcbc48b67)   
 [Generic Types in Visual Basic](../../visual-basic/programming-guide/language-features/data-types/generic-types.md)   
 [NIB: Visual Basic Version of Hello, World](http://msdn.microsoft.com/en-us/9d030b60-e148-4366-a462-69532f02294c)