---
title: "&lt;procedurename1&gt; cannot override &lt;procedurename2&gt; because they differ by parameters declared &#39;ParamArray&#39; | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "bc30906"
  - "vbc30906"
helpviewer_keywords: 
  - "BC30906"
ms.assetid: 12939030-732e-4c6d-8fe9-707b7532174b
caps.latest.revision: 11
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# &lt;procedurename1&gt; cannot override &lt;procedurename2&gt; because they differ by parameters declared &#39;ParamArray&#39;
A procedure in a derived class overrides an identically named procedure in the base class, but the parameter lists are different.  
  
 To override a procedure in an inherited class, the overriding procedure must match its parameter list, access level, and return type (if any). In particular, it must match any [Optional](../../visual-basic/language-reference/modifiers/optional.md) or [ParamArray](../../visual-basic/language-reference/modifiers/paramarray.md) declaration.  
  
 **Error ID:** BC30906  
  
## To correct this error  
  
-   If you want to override the procedure, make the parameter list exactly the same as the parameter list in the base class procedure. If the last parameter is declared with `ParamArray` in the base class procedure, declare it with `ParamArray` in the overriding procedure.  
  
-   If you want a different parameter list from the base class version, you cannot override it. Consider overloading it instead. For more information, see [Procedure Overloading](../../visual-basic/programming-guide/language-features/procedures/procedure-overloading.md).  
  
## See Also  
 [Overrides](../../visual-basic/language-reference/modifiers/overrides.md)   
 [NOT IN BUILD: Overriding Properties and Methods](http://msdn.microsoft.com/en-us/2167e8f5-1225-4b13-9ebd-02591ba90213)