---
title: "Method &#39;&lt;methodname&gt;&#39; does not have a signature compatible with delegate &lt;&#39;delegatename&#39;&gt; | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "vbc31143"
  - "bc31143"
helpviewer_keywords: 
  - "BC31143"
ms.assetid: 88990637-7c92-467e-a3d3-db5498dc1dce
caps.latest.revision: 9
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Method &#39;&lt;methodname&gt;&#39; does not have a signature compatible with delegate &lt;&#39;delegatename&#39;&gt;
This error occurs when a conversion is required between a method and a delegate that is not possible. The cause of the error can be conversion between parameters or, when the method and delegate are functions, conversion in the return values.  
  
 The following code illustrates failed conversions. The delegate is `FunDel`.  
  
```vb  
Delegate Function FunDel(ByVal i As Integer, ByVal d As Double) As Integer  
```  
  
 The following functions each differ from `FunDel` in a way that will cause this error.  
  
```vb  
Function ExampleMethod1(ByVal m As Integer, ByVal aDate As Date) As Integer  
End Function  
  
Function ExampleMethod2(ByVal m As Integer, ByVal aDouble As Double) As Date  
End Function  
```  
  
 Each of the following assignment statements causes the error.  
  
```vb  
Sub Main()  
    ' The second parameters of FunDel and ExampleMethod1, Double and Date,  
    ' are not compatible.  
    'Dim d1 As FunDel = AddressOf ExampleMethod1  
  
    ' The return types of FunDel and ExampleMethod2, Integer and Date,  
    ' are not compatible.  
    'Dim d2 As FunDel = AddressOf ExampleMethod2  
  
End Sub  
```  
  
 **Error ID:** BC31143  
  
## To correct this error  
  
-   Examine the corresponding parameters and, if they are present, return types to determine which pair is not compatible.  
  
## See Also  
 [Relaxed Delegate Conversion](../../visual-basic/programming-guide/language-features/delegates/relaxed-delegate-conversion.md)   
 [NOT IN BUILD: Delegates and the AddressOf Operator](http://msdn.microsoft.com/en-us/7b2ed932-8598-4355-b2f7-5cedb23ee86f)