---
title: "Expression is of type &#39;&lt;typename&gt;&#39;, which is not a collection type | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "bc32023"
  - "vbc32023"
helpviewer_keywords: 
  - "BC32023"
ms.assetid: d0f151be-6b65-498b-b571-03faf24df0d8
caps.latest.revision: 8
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Expression is of type &#39;&lt;typename&gt;&#39;, which is not a collection type
The group variable specified in a `For Each` statement is not a collection object or an array, and its type does not implement the <xref:System.Collections.IEnumerable> interface. The type must either support the [!INCLUDE[vbprvb](../../csharp/programming-guide/concepts/linq/includes/vbprvb_md.md)] collection design pattern or implement <xref:System.Collections.IEnumerable>.  
  
 **Error ID:** BC32023  
  
## To correct this error  
  
-   Declare the group variable to be of a class type that either supports the [!INCLUDE[vbprvb](../../csharp/programming-guide/concepts/linq/includes/vbprvb_md.md)] collection design or implements <xref:System.Collections.IEnumerable>.  
  
## See Also  
 <xref:System.Collections.IEnumerable>   
 [For Each...Next Statement](../../visual-basic/language-reference/statements/for-each-next-statement.md)   
 [Visual Basic Collection Class](http://msdn.microsoft.com/en-us/0cb2d1ad-c58d-42c0-8e69-d81f5a15e532)